/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.lob.lobstore.rdb;

import org.iplass.mtp.impl.lob.LobStoreService;
import org.iplass.mtp.impl.lob.lobstore.LobData;
import org.iplass.mtp.impl.lob.lobstore.LobStore;
import org.iplass.mtp.impl.lob.lobstore.LobValidator;
import org.iplass.mtp.impl.lob.lobstore.rdb.RdbLobData;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.spi.Config;

public class RdbLobStore
implements LobStore {
    private RdbAdapter rdb;
    private boolean manageLobSizeOnRdb;
    private LobValidator lobValidator;

    @Override
    public LobValidator getLobValidator() {
        return this.lobValidator;
    }

    public void setLobValidator(LobValidator lobValidator) {
        this.lobValidator = lobValidator;
    }

    @Override
    public void inited(LobStoreService service, Config config) {
        this.rdb = config.getDependentService(RdbAdapterService.class).getRdbAdapter();
        this.manageLobSizeOnRdb = service.isManageLobSizeOnRdb();
    }

    @Override
    public void destroyed() {
    }

    @Override
    public LobData create(int tenantId, long lobId) {
        return new RdbLobData(tenantId, lobId, this.manageLobSizeOnRdb, this.rdb);
    }

    @Override
    public LobData load(int tenantId, long lobId) {
        return new RdbLobData(tenantId, lobId, this.manageLobSizeOnRdb, this.rdb);
    }

    @Override
    public void remove(int tenantId, long lobId) {
    }
}

