/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata.xmlfile.dom;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.metadata.MetaDataRepository;
import org.iplass.mtp.impl.metadata.MetaDataRuntimeException;
import org.iplass.mtp.impl.metadata.xmlfile.XmlFileMetaDataStore;
import org.iplass.mtp.impl.metadata.xmlfile.dom.DomHandler;
import org.iplass.mtp.impl.metadata.xmlfile.dom.DomHandlerFactory;
import org.iplass.mtp.impl.metadata.xmlfile.dom.NoopDomHandler;
import org.iplass.mtp.impl.metadata.xmlfile.dom.XsiType;
import org.iplass.mtp.impl.metadata.xmlfile.dom.XsiTypeClass;
import org.iplass.mtp.impl.metadata.xmlfile.dom.XsiTypeDomHandler;
import org.iplass.mtp.impl.metadata.xmlfile.dom.extend.XsiTypeList;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XsiTypeDomHandlerFactory
implements DomHandlerFactory {
    private static final String TAGNAME_METADATA = "metaData";
    private List<XsiType> xsiType;
    private String fileStorePath;
    private String groovySourceStorePath;

    public String getFileStorePath() {
        return this.fileStorePath;
    }

    public void setFileStorePath(String fileStorePath) {
        this.fileStorePath = fileStorePath;
    }

    public String getGroovySourceStorePath() {
        return this.groovySourceStorePath;
    }

    public void setGroovySourceStorePath(String groovySourceStorePath) {
        this.groovySourceStorePath = groovySourceStorePath;
    }

    @Override
    public DomHandler createDomHamdler(File xml, String charset, Document doc) {
        String xtStr = this.getXsiTypeName(doc);
        String xtCapitalized = xtStr.substring(0, 1).toUpperCase() + xtStr.substring(1);
        XsiType xt = this.findXsiType(xtCapitalized);
        DomHandler handler = null;
        handler = xt != null ? new XsiTypeDomHandler(xml, new File(this.fileStorePath), new File(this.groovySourceStorePath), charset, xt) : new NoopDomHandler();
        return handler;
    }

    private String getXsiTypeName(Document doc) {
        NamedNodeMap m;
        Node typeAtr;
        String typeName = null;
        NodeList metaDataTags = doc.getElementsByTagName(TAGNAME_METADATA);
        Node node = metaDataTags.item(0);
        if (node != null && (typeAtr = (m = node.getAttributes()).getNamedItem("xsi:type")) != null) {
            typeName = typeAtr.getNodeValue();
        }
        return typeName;
    }

    private XsiType findXsiType(String xsiTypeCapitalized) {
        XsiType ret = null;
        for (XsiType type : this.xsiType) {
            if (!type.getClass().getSimpleName().startsWith(xsiTypeCapitalized)) continue;
            ret = type;
            break;
        }
        return ret;
    }

    @Override
    public void inited(MetaDataRepository service, XmlFileMetaDataStore xmlfileMetaDataStore) {
        this.fileStorePath = xmlfileMetaDataStore.getFileStorePath();
        this.groovySourceStorePath = xmlfileMetaDataStore.getGroovySourceStorePath();
        if (this.groovySourceStorePath == null) {
            this.groovySourceStorePath = this.fileStorePath;
        }
        if (!this.groovySourceStorePath.endsWith("/")) {
            this.groovySourceStorePath = this.groovySourceStorePath + "/";
        }
        this.xsiType = new ArrayList<XsiType>();
        for (Class<?> x : XsiTypeList.class.getAnnotation(XsiTypeClass.class).value()) {
            try {
                this.xsiType.add((XsiType)x.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new MetaDataRuntimeException("can not instantiate " + x.getName(), e);
            }
        }
    }
}

