/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.properties.basic;

import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.definition.properties.FloatProperty;
import org.iplass.mtp.impl.properties.basic.BasicType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FloatType
extends BasicType {
    private static final long serialVersionUID = 3314101651301305269L;
    private static final int hash = 22;
    private static Logger logger = LoggerFactory.getLogger(FloatType.class);

    @Override
    public int hashCode() {
        return 22;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof FloatType;
    }

    @Override
    public FloatProperty createPropertyDefinitionInstance() {
        return new FloatProperty();
    }

    @Override
    public FloatType copy() {
        return new FloatType();
    }

    @Override
    public Class<?> storeType() {
        return Double.class;
    }

    @Override
    public PropertyDefinitionType getEnumType() {
        return PropertyDefinitionType.FLOAT;
    }

    @Override
    public Object fromString(String strValue) {
        if (strValue == null) {
            return null;
        }
        try {
            return Double.valueOf(strValue);
        }
        catch (NumberFormatException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Can't parse to Float:" + strValue);
            }
            return null;
        }
    }
}

