/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query;

import org.iplass.mtp.entity.query.Select;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.hint.HintCommentSyntax;
import org.iplass.mtp.impl.query.value.expr.PolynomialSyntax;

public class SelectSyntax
implements Syntax<Select>,
QueryConstants {
    private PolynomialSyntax polynomial;
    private HintCommentSyntax hintComment;

    @Override
    public Select parse(ParseContext str) throws ParseException {
        if (!str.equalsNextToken("SELECT", ParseContext.TOKEN_DELIMITERS)) {
            throw new ParseException(new EvalError("SELECT expected.", this, str));
        }
        str.consumeChars("SELECT".length());
        Select select = new Select();
        boolean hasSpace = str.consumeChars(ParseContext.WHITE_SPACES);
        if (str.startsWith("/*+")) {
            select.setHintComment(this.hintComment.parse(str));
            str.consumeChars(ParseContext.WHITE_SPACES);
        } else if (!hasSpace) {
            throw new ParseException(new EvalError("space expected.", this, str));
        }
        if (str.equalsNextToken("DISTINCT", ParseContext.TOKEN_DELIMITERS)) {
            str.consumeChars("DISTINCT".length());
            select.setDistinct(true);
            if (!str.consumeChars(ParseContext.WHITE_SPACES)) {
                throw new ParseException(new EvalError("space expected.", this, str));
            }
        }
        boolean isFirst = true;
        while (true) {
            if (isFirst) {
                isFirst = false;
            } else {
                if (!str.startsWith(",")) break;
                str.consumeChars(",".length());
                str.consumeChars(ParseContext.WHITE_SPACES);
            }
            ValueExpression val = this.polynomial.parse(str);
            select.add((Object)val);
        }
        return select;
    }

    @Override
    public void init(SyntaxContext context) {
        this.polynomial = context.getSyntax(PolynomialSyntax.class);
        this.hintComment = context.getSyntax(HintCommentSyntax.class);
    }
}

