/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.value.primary;

import java.util.ArrayList;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.Cast;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.value.expr.PolynomialSyntax;

public class CastSyntax
implements Syntax<Cast>,
QueryConstants {
    private PolynomialSyntax polynomial;

    @Override
    public void init(SyntaxContext context) {
        this.polynomial = context.getSyntax(PolynomialSyntax.class);
    }

    @Override
    public Cast parse(ParseContext str) throws ParseException {
        if (!str.equalsNextToken("CAST", ParseContext.TOKEN_DELIMITERS)) {
            throw new ParseException(new EvalError("CAST expected.", this, str));
        }
        str.consumeChars("CAST".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!str.startsWith("(")) {
            throw new ParseException(new EvalError("( expected.", this, str));
        }
        str.consumeChars("(".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        Cast cast = new Cast();
        ValueExpression value = this.polynomial.parse(str);
        cast.setValue(value);
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!str.equalsNextToken("AS", ParseContext.WHITE_SPACES)) {
            throw new ParseException(new EvalError("AS expected.", this, str));
        }
        str.consumeChars("AS".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        String type = str.nextToken(ParseContext.TOKEN_DELIMITERS);
        if (type == null) {
            throw new ParseException(new EvalError("type expected.", this, str));
        }
        type = type.toUpperCase();
        PropertyDefinitionType pdt = null;
        try {
            pdt = PropertyDefinitionType.valueOf(type);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(new EvalError("invalid type spec.", this, str));
        }
        cast.setType(pdt);
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (str.startsWith("(")) {
            str.consumeChars(1);
            while (!str.isEnd() && str.peekChar() != ')') {
                str.consumeChars(ParseContext.WHITE_SPACES);
                String typeArgStr = str.nextToken(ParseContext.TOKEN_DELIMITERS);
                try {
                    int typeArg = Integer.parseInt(typeArgStr.trim());
                    if (cast.getTypeArguments() == null) {
                        cast.setTypeArguments(new ArrayList<Integer>());
                    }
                    cast.getTypeArguments().add(typeArg);
                }
                catch (NumberFormatException e) {
                    throw new ParseException(new EvalError("invalid type arguments.", this, str));
                }
                str.consumeChars(ParseContext.WHITE_SPACES);
                if (str.peekChar() != ',') {
                    if (str.peekChar() == ')') continue;
                    throw new ParseException(new EvalError(", or ) expected.", this, str));
                }
                str.consumeChars(1);
            }
            if (str.popChar() != ')') {
                throw new ParseException(new EvalError(") expected.", this, str));
            }
            str.consumeChars(ParseContext.WHITE_SPACES);
        }
        if (!str.startsWith(")")) {
            throw new ParseException(new EvalError(") expected.", this, str));
        }
        str.consumeChars(")".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        return cast;
    }
}

