/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.value.window;

import org.iplass.mtp.entity.query.value.aggregate.Aggregate;
import org.iplass.mtp.entity.query.value.primary.PrimaryValue;
import org.iplass.mtp.entity.query.value.window.CumeDist;
import org.iplass.mtp.entity.query.value.window.DenseRank;
import org.iplass.mtp.entity.query.value.window.PartitionBy;
import org.iplass.mtp.entity.query.value.window.PercentRank;
import org.iplass.mtp.entity.query.value.window.Rank;
import org.iplass.mtp.entity.query.value.window.RowNumber;
import org.iplass.mtp.entity.query.value.window.WindowAggregate;
import org.iplass.mtp.entity.query.value.window.WindowFunction;
import org.iplass.mtp.entity.query.value.window.WindowOrderBy;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.value.aggregate.AggregateSyntax;
import org.iplass.mtp.impl.query.value.window.PartitionBySyntax;
import org.iplass.mtp.impl.query.value.window.WindowOrderBySyntax;

public class WindowFunctionSyntax
implements Syntax<PrimaryValue>,
QueryConstants {
    private AggregateSyntax aggregate;
    private PartitionBySyntax partitionBy;
    private WindowOrderBySyntax orderBy;

    @Override
    public void init(SyntaxContext context) {
        this.aggregate = context.getSyntax(AggregateSyntax.class);
        this.partitionBy = context.getSyntax(PartitionBySyntax.class);
        this.orderBy = context.getSyntax(WindowOrderBySyntax.class);
    }

    @Override
    public PrimaryValue parse(ParseContext str) throws ParseException {
        WindowFunction wf = null;
        Aggregate ag = null;
        int currentIndex = str.getCurrentIndex();
        try {
            ag = this.aggregate.parse(str);
        }
        catch (ParseException e) {
            str.setCurrentIndex(currentIndex);
        }
        String token = null;
        if (ag == null) {
            token = str.nextToken(ParseContext.TOKEN_DELIMITERS);
            if (token == null) {
                throw new ParseException(new EvalError("window aggregate function expected.", this, str));
            }
            switch (token = token.toUpperCase()) {
                case "RANK": {
                    wf = new Rank();
                    break;
                }
                case "DENSE_RANK": {
                    wf = new DenseRank();
                    break;
                }
                case "PERCENT_RANK": {
                    wf = new PercentRank();
                    break;
                }
                case "CUME_DIST": {
                    wf = new CumeDist();
                    break;
                }
                case "ROW_NUMBER": {
                    wf = new RowNumber();
                    break;
                }
                default: {
                    str.setCurrentIndex(currentIndex);
                    throw new ParseException(new EvalError("window aggregate function expected.", this, str));
                }
            }
            str.consumeChars(ParseContext.WHITE_SPACES);
            if (!str.startsWith("(")) {
                throw new ParseException(new EvalError("( expected.", this, str));
            }
            str.consumeChars("(".length());
            str.consumeChars(ParseContext.WHITE_SPACES);
            if (!str.startsWith(")")) {
                throw new ParseException(new EvalError(") expected.", this, str));
            }
            str.consumeChars(")".length());
        }
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!str.equalsNextToken("OVER", ParseContext.TOKEN_DELIMITERS)) {
            if (ag != null) {
                return ag;
            }
            throw new ParseException(new EvalError("OVER expected.", this, str));
        }
        str.consumeChars("OVER".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!str.startsWith("(")) {
            throw new ParseException(new EvalError("( expected.", this, str));
        }
        str.consumeChars("(".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (ag != null) {
            wf = new WindowAggregate(ag);
        }
        currentIndex = str.getCurrentIndex();
        try {
            PartitionBy part = this.partitionBy.parse(str);
            wf.setPartitionBy(part);
            str.consumeChars(ParseContext.WHITE_SPACES);
        }
        catch (ParseException e) {
            str.setCurrentIndex(currentIndex);
        }
        currentIndex = str.getCurrentIndex();
        try {
            WindowOrderBy order = this.orderBy.parse(str);
            wf.setOrderBy(order);
            str.consumeChars(ParseContext.WHITE_SPACES);
        }
        catch (ParseException e) {
            str.setCurrentIndex(currentIndex);
        }
        if (!str.startsWith(")")) {
            throw new ParseException(new EvalError(") expected.", this, str));
        }
        str.consumeChars(")".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        return wf;
    }
}

