/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.iplass.mtp.impl.rdb.connection.AbstractConnectionFactory;
import org.iplass.mtp.impl.rdb.connection.ConnectionException;
import org.iplass.mtp.spi.Config;

public class DriverManagerConnectionFactory
extends AbstractConnectionFactory {
    private String url;
    private Properties info;

    @Override
    protected Connection getConnectionInternal() {
        Connection con;
        try {
            Class.forName(this.info.getProperty("driver"));
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        try {
            con = DriverManager.getConnection(this.url, this.info);
        }
        catch (SQLException e) {
            throw new ConnectionException("can not get Driver Managed Connection:", e);
        }
        return con;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void init(Config config) {
        super.init(config);
        this.info = new Properties();
        for (String name : config.getNames()) {
            if (name.equals("warnLogThreshold") || name.equals("transactionIsolationLevel") || name.equals("warnLogBefore")) continue;
            this.info.put(name, config.getValue(name));
        }
        this.url = (String)this.info.remove("url");
    }
}

