/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.sqlserver.function;

import java.util.List;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;

public class SqlServerModFunctionAdapter
implements FunctionAdapter {
    private String field;

    public SqlServerModFunctionAdapter(String field) {
        this.field = field;
    }

    @Override
    public void toSQL(FunctionAdapter.FunctionContext context, Function function, RdbAdapter rdb) {
        if (function.getArguments() == null || function.getArguments().size() != 2) {
            throw new QueryException(function.getName() + " must have two arguments.");
        }
        context.append("(");
        context.appendArgument(function.getArguments().get(0));
        context.append(" % ");
        context.appendArgument(function.getArguments().get(1));
        context.append(")");
    }

    @Override
    public void toSQL(StringBuilder context, List<CharSequence> args, RdbAdapter rdb) {
        if (args == null || args.size() != 2) {
            throw new QueryException(this.getFunctionName() + " must have two arguments.");
        }
        context.append("(");
        context.append(args.get(0));
        context.append(" % ");
        context.append(args.get(1));
        context.append(")");
    }

    @Override
    public String getFunctionName() {
        return this.field;
    }

    @Override
    public Class<?> getType(Function function, FunctionAdapter.ArgumentTypeResolver typeResolver) {
        return Long.class;
    }
}

