/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.script;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyResourceLoader;
import java.io.PrintWriter;
import org.iplass.mtp.impl.script.GroovyScript;
import org.iplass.mtp.impl.script.GroovyScriptContext;
import org.iplass.mtp.impl.script.GroovyScriptService;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.UtilitiyClassResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyScriptEngine
implements ScriptEngine {
    public static final String UTILITY_CLASS_META_PATH = "/utilityClass/";
    private static Logger logger = LoggerFactory.getLogger(GroovyScriptEngine.class);
    private final GroovyClassLoader sharedClassLoader;

    public GroovyScriptEngine(GroovyClassLoader classLoader, GroovyScriptService service) {
        this(classLoader, service, false);
    }

    public GroovyScriptEngine(GroovyClassLoader classLoader, GroovyScriptService service, boolean vanilla) {
        if (!vanilla) {
            classLoader.setResourceLoader((GroovyResourceLoader)new UtilitiyClassResourceLoader(classLoader.getResourceLoader(), service));
        }
        this.sharedClassLoader = classLoader;
        logger.debug("created GroovyScriptEngine");
    }

    @Override
    public Script createScript(String script, String name) {
        return this.createScript(script, name, false);
    }

    @Override
    public Script createScript(String script, String name, boolean sharedClass) {
        name = name.replaceAll("[^\\w\\d]", "_");
        name = "_".concat(name);
        if (logger.isDebugEnabled()) {
            logger.debug("create Script:" + name + " ...");
        }
        if (sharedClass) {
            return new GroovyScript(this.sharedClassLoader, script, name);
        }
        return new GroovyScript(new GroovyClassLoader(this.sharedClassLoader), script, name);
    }

    @Override
    public ScriptContext newScriptContext() {
        return new GroovyScriptContext();
    }

    @Override
    public ScriptContext newScriptContext(PrintWriter out) {
        return new GroovyScriptContext(out);
    }

    public GroovyClassLoader getSharedClassLoader() {
        return this.sharedClassLoader;
    }

    @Override
    public void invalidate() {
        this.sharedClassLoader.clearCache();
        if (this.sharedClassLoader.getResourceLoader() instanceof UtilitiyClassResourceLoader) {
            ((UtilitiyClassResourceLoader)this.sharedClassLoader.getResourceLoader()).clearClassNameList();
        }
    }
}

