/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.script;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.slf4j.Logger;

public class LoggerPrintWriter
extends PrintWriter {
    public LoggerPrintWriter(Logger logger) {
        super((Writer)new LoggerWriter(logger), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                this.out.flush();
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.setError();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private static class LoggerWriter
    extends Writer {
        private Logger logger;
        String bufStr = null;
        StringBuilder buf = null;

        private LoggerWriter(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void write(int c) throws IOException {
            super.write(c);
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            super.write(cbuf);
        }

        @Override
        public void write(String str) throws IOException {
            if (this.buf != null) {
                this.buf.append(str);
            } else if (this.bufStr == null) {
                this.bufStr = str;
            } else {
                this.buf = new StringBuilder();
                this.buf.append(this.bufStr);
                this.buf.append(str);
                this.bufStr = null;
            }
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            this.write(str.substring(off, off + len));
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            if (this.buf != null) {
                this.buf.append(cbuf, off, len);
            } else if (this.bufStr == null) {
                this.bufStr = new String(cbuf, off, len);
            } else {
                this.buf = new StringBuilder();
                this.buf.append(this.bufStr);
                this.buf.append(cbuf, off, len);
                this.bufStr = null;
            }
        }

        @Override
        public Writer append(CharSequence csq) throws IOException {
            return super.append(csq);
        }

        @Override
        public Writer append(CharSequence csq, int start, int end) throws IOException {
            return super.append(csq, start, end);
        }

        @Override
        public Writer append(char c) throws IOException {
            return super.append(c);
        }

        @Override
        public void flush() throws IOException {
            if (this.buf != null) {
                this.logger.info(this.buf.toString());
            } else if (this.bufStr != null) {
                this.logger.info(this.bufStr);
            }
            this.buf = null;
            this.bufStr = null;
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }
    }
}

