/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.sms;

import java.util.Map;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.sms.SmsService;
import org.iplass.mtp.impl.sms.template.MetaSmsMailTemplate;
import org.iplass.mtp.sms.SmsMail;
import org.iplass.mtp.sms.SmsMailManager;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;

public class SmsMailManagerImpl
implements SmsMailManager {
    SmsService smsService = ServiceRegistry.getRegistry().getService(SmsService.class);

    @Override
    public SmsMail createMail() {
        return this.smsService.createMail(ExecuteContext.getCurrentContext().getCurrentTenant());
    }

    @Override
    public SmsMail createMail(String tmplDefName, Map<String, Object> bindings) {
        MetaSmsMailTemplate.SmsMailTemplateRuntime tr = (MetaSmsMailTemplate.SmsMailTemplateRuntime)this.smsService.getRuntimeByName(tmplDefName);
        if (tr == null) {
            throw new SystemException("smsMailTemplate:" + tmplDefName + " not found");
        }
        return tr.createMail(bindings);
    }

    @Override
    public void sendMail(SmsMail smsMail) {
        Tenant tenant = ExecuteContext.getCurrentContext().getCurrentTenant();
        this.smsService.sendSmsMail(tenant, smsMail);
    }
}

