/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.tenant;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.definition.TypedDefinitionManager;
import org.iplass.mtp.impl.definition.AbstractTypedMetaDataService;
import org.iplass.mtp.impl.definition.DefinitionMetaDataTypeMap;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.tenant.MetaTenant;
import org.iplass.mtp.impl.tenant.MetaTenantConfig;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tenant.TenantConfig;
import org.iplass.mtp.tenant.TenantManager;

public class MetaTenantService
extends AbstractTypedMetaDataService<MetaTenant, MetaTenant.MetaTenantHandler>
implements Service {
    public static final String TENANT_META_PATH = "/tenant/";
    private static final String TENANT_FIXED_NAME = "Tenant";
    private Map<Class<? extends TenantConfig>, Class<? extends MetaTenantConfig>> configTypeMap;
    private Map<String, Class<? extends TenantConfig>> configBindNameMap;

    @Override
    public void init(Config config) {
        List<ConfigType> configTypes = config.getValues("configType", ConfigType.class);
        if (configTypes != null) {
            this.configTypeMap = new HashMap<Class<? extends TenantConfig>, Class<? extends MetaTenantConfig>>();
            this.configBindNameMap = new HashMap<String, Class<? extends TenantConfig>>();
            configTypes.forEach(type -> {
                Class<?> defClass = null;
                try {
                    defClass = Class.forName(type.getDefinitionClass());
                }
                catch (ClassCastException | ClassNotFoundException e) {
                    throw new ServiceConfigrationException("configType:" + type.getDefinitionClass() + " can't instanceate.");
                }
                Class<?> metaClass = null;
                try {
                    metaClass = Class.forName(type.getMetadataClass());
                }
                catch (ClassCastException | ClassNotFoundException e) {
                    throw new ServiceConfigrationException("configType:" + type.getMetadataClass() + " can't instanceate.");
                }
                this.configTypeMap.put(defClass, metaClass);
                this.configBindNameMap.put(type.getScriptBindingName(), defClass);
            });
        } else {
            this.configTypeMap = Collections.emptyMap();
            this.configBindNameMap = Collections.emptyMap();
        }
    }

    @Override
    public void destroy() {
    }

    public static String getFixedPath() {
        return TENANT_META_PATH;
    }

    @Override
    public Class<MetaTenant> getMetaDataType() {
        return MetaTenant.class;
    }

    @Override
    public Class<MetaTenant.MetaTenantHandler> getRuntimeType() {
        return MetaTenant.MetaTenantHandler.class;
    }

    @Override
    public void createMetaData(MetaTenant meta) {
        meta.setId(TENANT_FIXED_NAME);
        meta.setName(TENANT_FIXED_NAME);
        MetaDataContext.getContext().store("/tenant/Tenant", meta);
    }

    @Override
    public void updateMetaData(MetaTenant meta) {
        if (this.get() != null) {
            meta.setId(TENANT_FIXED_NAME);
            meta.setName(TENANT_FIXED_NAME);
            super.updateMetaData(meta);
        } else {
            this.createMetaData(meta);
        }
    }

    public MetaTenant.MetaTenantHandler get() {
        return MetaDataContext.getContext().getMetaDataHandler(MetaTenant.MetaTenantHandler.class, "/tenant/Tenant");
    }

    @Override
    public MetaTenant.MetaTenantHandler getRuntimeById(String id) {
        return this.get();
    }

    @Override
    public MetaTenant.MetaTenantHandler getRuntimeByName(String name) {
        return this.get();
    }

    public MetaTenantConfig toMetaConfig(TenantConfig tenantConfig) {
        Class<? extends MetaTenantConfig> metaClass = this.configTypeMap.get(tenantConfig.getClass());
        if (metaClass != null) {
            try {
                return metaClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                return null;
            }
        }
        return null;
    }

    public TenantConfig getBindTenantConfig(Tenant tenant, String bindName) {
        Class<? extends TenantConfig> defTypeClass = this.configBindNameMap.get(bindName);
        if (defTypeClass != null) {
            return tenant.getTenantConfig(defTypeClass);
        }
        return null;
    }

    Collection<Class<? extends MetaTenantConfig>> getMetaTenantConfigClasses() {
        return this.configTypeMap.values();
    }

    public static class ConfigType {
        private String definitionClass;
        private String metadataClass;
        private String scriptBindingName;

        public String getDefinitionClass() {
            return this.definitionClass;
        }

        public void setDefinitionClass(String definitionClass) {
            this.definitionClass = definitionClass;
        }

        public String getMetadataClass() {
            return this.metadataClass;
        }

        public void setMetadataClass(String metadataClass) {
            this.metadataClass = metadataClass;
        }

        public String getScriptBindingName() {
            return this.scriptBindingName;
        }

        public void setScriptBindingName(String scriptBindingName) {
            this.scriptBindingName = scriptBindingName;
        }
    }

    public static class TypeMap
    extends DefinitionMetaDataTypeMap<Tenant, MetaTenant> {
        public TypeMap() {
            super(MetaTenantService.getFixedPath(), MetaTenant.class, Tenant.class);
        }

        @Override
        public TypedDefinitionManager<Tenant> typedDefinitionManager() {
            return ManagerLocator.getInstance().getManager(TenantManager.class);
        }

        @Override
        public Tenant toDefinition(MetaTenant metaData) {
            return this.typedDefinitionManager().get(null);
        }

        @Override
        public String toPath(String defName) {
            return this.pathPrefix + MetaTenantService.TENANT_FIXED_NAME;
        }

        @Override
        public String toDefName(String path) {
            return MetaTenantService.TENANT_FIXED_NAME;
        }
    }
}

