/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.iplass.mtp.Manager;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.DeleteCondition;
import org.iplass.mtp.entity.DeleteOption;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.InsertOption;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.SearchOption;
import org.iplass.mtp.entity.SearchResult;
import org.iplass.mtp.entity.UpdateCondition;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.ValidateResult;
import org.iplass.mtp.entity.bulkupdate.BulkUpdatable;
import org.iplass.mtp.entity.query.Query;

public interface EntityManager
extends Manager {
    public ValidateResult validate(Entity var1);

    public ValidateResult validate(Entity var1, List<String> var2);

    public <T extends Entity> SearchResult<T> searchEntity(Query var1);

    public <T extends Entity> SearchResult<T> searchEntity(Query var1, SearchOption var2);

    public <T extends Entity> void searchEntity(Query var1, Predicate<T> var2);

    public <T extends Entity> void searchEntity(Query var1, SearchOption var2, Predicate<T> var3);

    public SearchResult<Object[]> search(Query var1);

    public SearchResult<Object[]> search(Query var1, SearchOption var2);

    public void search(Query var1, Predicate<Object[]> var2);

    public void search(Query var1, SearchOption var2, Predicate<Object[]> var3);

    public int count(Query var1);

    public Entity load(String var1, String var2);

    public Entity load(String var1, Long var2, String var3);

    public Entity load(String var1, String var2, LoadOption var3);

    public Entity load(String var1, Long var2, String var3, LoadOption var4);

    public Entity loadAndLock(String var1, String var2);

    public Entity loadAndLock(String var1, String var2, LoadOption var3);

    public String insert(Entity var1);

    public String insert(Entity var1, InsertOption var2);

    public void update(Entity var1, UpdateOption var2);

    public void delete(Entity var1, DeleteOption var2);

    public int updateAll(UpdateCondition var1);

    public int deleteAll(DeleteCondition var1);

    public void bulkUpdate(BulkUpdatable var1);

    public BinaryReference loadBinaryReference(long var1);

    public BinaryReference createBinaryReference(String var1, String var2, InputStream var3);

    public BinaryReference createBinaryReference(File var1, String var2, String var3);

    public InputStream getInputStream(BinaryReference var1);

    public OutputStream getOutputStream(BinaryReference var1);

    public boolean lockByUser(String var1, String var2);

    public boolean unlockByUser(String var1, String var2);

    public void purge(long var1, String var3);

    public Entity restore(long var1, String var3);

    public void getRecycleBin(String var1, Predicate<Entity> var2);

    public Entity getRecycleBin(long var1, String var3);

    public Timestamp getCurrentTimestamp();

    public Entity deepCopy(String var1, String var2);

    public <T extends Entity> SearchResult<T> fulltextSearchEntity(String var1, String var2);

    public List<String> fulltextSearchOidList(String var1, String var2);

    public <T extends Entity> SearchResult<T> fulltextSearchEntity(Map<String, List<String>> var1, String var2);

    public <T extends Entity> SearchResult<T> fulltextSearchEntity(Query var1, String var2, SearchOption var3);
}

