/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityRuntimeException;

public class SearchResult<T>
implements Iterable<T>,
AutoCloseable {
    private int totalCount;
    private List<T> list;

    public SearchResult(int totalCount, List<T> list) {
        this.totalCount = totalCount;
        this.list = list;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public List<T> getList() {
        if (this.list == null) {
            return Collections.emptyList();
        }
        return this.list;
    }

    public T getFirst() {
        if (this.list == null) {
            return null;
        }
        if (this.list.size() == 0) {
            return null;
        }
        return this.list.get(0);
    }

    public <P> List<P> getValueList(String propertyName) {
        if (this.list == null || this.list.size() == 0) {
            return Collections.emptyList();
        }
        if (!(this.list.get(0) instanceof Entity)) {
            throw new EntityRuntimeException("for use getValueList(propertyName), result type must Entity.");
        }
        ArrayList res = new ArrayList();
        for (Entity e : this.list) {
            res.add(e.getValue(propertyName));
        }
        return res;
    }

    public <P> List<P> getValueList(int index) {
        if (this.list == null || this.list.size() == 0) {
            return Collections.emptyList();
        }
        if (!(this.list.get(0) instanceof Object[])) {
            throw new EntityRuntimeException("for use getValueList(index), result type must Object[].");
        }
        ArrayList<Object> res = new ArrayList<Object>();
        for (Object[] e : this.list) {
            res.add(e[index]);
        }
        return res;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.list == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.list.iterator();
    }

    public ResultMode getResultMode() {
        return ResultMode.AT_ONCE;
    }

    @Override
    public void close() {
    }

    public static enum ResultMode {
        AT_ONCE,
        STREAM;

    }
}

