/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.QueryVisitor;
import org.iplass.mtp.entity.query.hint.Hint;
import org.iplass.mtp.entity.query.hint.HintComment;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.EntityField;

public class Select
implements ASTNode {
    private static final long serialVersionUID = -5756828427274970672L;
    private HintComment hintComment;
    private boolean isDistinct;
    private List<ValueExpression> selectValues = new ArrayList<ValueExpression>();

    public Select() {
    }

    public Select(boolean isDistinct, List<ValueExpression> selectValues) {
        this.isDistinct = isDistinct;
        this.selectValues = selectValues;
    }

    public Select(boolean isDistinct, ValueExpression[] selectValueArray) {
        this.isDistinct = isDistinct;
        if (this.selectValues != null) {
            if (this.selectValues == null) {
                this.selectValues = new ArrayList<ValueExpression>();
            }
            for (ValueExpression ve : selectValueArray) {
                this.selectValues.add(ve);
            }
        }
    }

    public Select(HintComment hintComment, boolean isDistinct, List<ValueExpression> selectValues) {
        this.hintComment = hintComment;
        this.isDistinct = isDistinct;
        this.selectValues = selectValues;
    }

    public Select(HintComment hintComment, boolean isDistinct, ValueExpression[] selectValueArray) {
        this.hintComment = hintComment;
        this.isDistinct = isDistinct;
        if (this.selectValues != null) {
            if (this.selectValues == null) {
                this.selectValues = new ArrayList<ValueExpression>();
            }
            for (ValueExpression ve : selectValueArray) {
                this.selectValues.add(ve);
            }
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hintComment == null ? 0 : this.hintComment.hashCode());
        result = 31 * result + (this.isDistinct ? 1231 : 1237);
        result = 31 * result + (this.selectValues == null ? 0 : this.selectValues.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Select other = (Select)obj;
        if (this.hintComment == null ? other.hintComment != null : !this.hintComment.equals(other.hintComment)) {
            return false;
        }
        if (this.isDistinct != other.isDistinct) {
            return false;
        }
        return !(this.selectValues == null ? other.selectValues != null : !this.selectValues.equals(other.selectValues));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        if (this.hintComment != null) {
            sb.append(this.hintComment).append(" ");
        }
        if (this.isDistinct) {
            sb.append("distinct ");
        }
        if (this.selectValues != null) {
            for (int i = 0; i < this.selectValues.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.selectValues.get(i));
            }
        }
        return sb.toString();
    }

    public HintComment getHintComment() {
        return this.hintComment;
    }

    public void setHintComment(HintComment hintComment) {
        this.hintComment = hintComment;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public void setDistinct(boolean isDistinct) {
        this.isDistinct = isDistinct;
    }

    public List<ValueExpression> getSelectValues() {
        return this.selectValues;
    }

    public void setSelectValues(List<ValueExpression> selectValues) {
        this.selectValues = selectValues;
    }

    public void accept(QueryVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.hintComment != null) {
                this.hintComment.accept(visitor);
            }
            if (this.selectValues != null) {
                for (ValueExpression exp : this.selectValues) {
                    exp.accept(visitor);
                }
            }
        }
    }

    public Select values(Object ... value) {
        if (value != null) {
            ArrayList<ValueExpression> newSelectValues = new ArrayList<ValueExpression>();
            this.addToList(newSelectValues, value);
            this.selectValues = newSelectValues;
        } else {
            this.selectValues = null;
        }
        return this;
    }

    public Select distinct() {
        this.isDistinct = true;
        return this;
    }

    public HintComment hintComment() {
        if (this.hintComment == null) {
            this.hintComment = new HintComment();
        }
        return this.hintComment;
    }

    public Select addHint(Hint hint) {
        if (this.hintComment == null) {
            this.hintComment = new HintComment();
        }
        this.hintComment.add(hint);
        return this;
    }

    public Select addHint(List<Hint> hintList) {
        if (this.hintComment == null) {
            this.hintComment = new HintComment();
        }
        this.hintComment.add(hintList);
        return this;
    }

    public Select add(Object ... value) {
        if (value != null) {
            ArrayList<ValueExpression> newSelectValues = new ArrayList<ValueExpression>();
            if (this.selectValues != null) {
                newSelectValues.addAll(this.selectValues);
            }
            this.addToList(newSelectValues, value);
            this.selectValues = newSelectValues;
        }
        return this;
    }

    public Select add(Object value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        if (this.selectValues == null) {
            this.selectValues = new ArrayList<ValueExpression>();
        }
        if (value instanceof ValueExpression) {
            this.selectValues.add((ValueExpression)value);
        } else if (value instanceof String) {
            this.selectValues.add(new EntityField((String)value));
        } else {
            throw new EntityRuntimeException("ValueExpression or String type required.");
        }
        return this;
    }

    private void addToList(List<ValueExpression> list, Object[] values) {
        for (Object v : values) {
            if (v instanceof ValueExpression) {
                list.add((ValueExpression)v);
                continue;
            }
            if (v instanceof String) {
                list.add(new EntityField((String)v));
                continue;
            }
            throw new EntityRuntimeException("ValueExpression or String type required.");
        }
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }
}

