/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.value.controlflow;

import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.ConditionVisitor;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.ValueExpressionVisitor;
import org.iplass.mtp.entity.query.value.primary.Literal;

public class When
implements ASTNode {
    private static final long serialVersionUID = 3718712397451605139L;
    private Condition condition;
    private ValueExpression result;

    public When() {
    }

    public When(Condition condition, ValueExpression result) {
        this.condition = condition;
        this.result = result;
    }

    public When(Condition condition, Object resultLiteral) {
        this.condition = condition;
        this.result = resultLiteral instanceof ValueExpression ? (ValueExpression)resultLiteral : new Literal(resultLiteral);
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public ValueExpression getResult() {
        return this.result;
    }

    public void setResult(ValueExpression result) {
        this.result = result;
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    public void accept(ValueExpressionVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.condition != null && visitor instanceof ConditionVisitor) {
                this.condition.accept((ConditionVisitor)((Object)visitor));
            }
            if (this.result != null) {
                this.result.accept(visitor);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("when ");
        sb.append(this.condition);
        sb.append(" then ");
        sb.append(this.result);
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        result = 31 * result + (this.result == null ? 0 : this.result.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        When other = (When)obj;
        if (this.condition == null ? other.condition != null : !this.condition.equals(other.condition)) {
            return false;
        }
        return !(this.result == null ? other.result != null : !this.result.equals(other.result));
    }
}

