/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.value.primary;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.ValueExpressionVisitor;
import org.iplass.mtp.entity.query.value.primary.PrimaryValue;

public class ArrayValue
extends PrimaryValue {
    private static final long serialVersionUID = -6737911797287905026L;
    private List<ValueExpression> values;

    public ArrayValue() {
    }

    public ArrayValue(List<ValueExpression> values) {
        this.values = values;
    }

    public ArrayValue(ValueExpression ... value) {
        if (value != null) {
            this.values = new ArrayList<ValueExpression>();
            for (ValueExpression v : value) {
                this.values.add(v);
            }
        }
    }

    @Override
    public void accept(ValueExpressionVisitor visitor) {
        if (visitor.visit(this) && this.values != null) {
            for (ValueExpression v : this.values) {
                v.accept(visitor);
            }
        }
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    @Override
    public String toString() {
        if (this.values == null) {
            return "array[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("array[");
        for (int i = 0; i < this.values.size(); ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this.values.get(i));
        }
        sb.append("]");
        return sb.toString();
    }

    public List<ValueExpression> getValues() {
        return this.values;
    }

    public void setValues(List<ValueExpression> values) {
        this.values = values;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayValue other = (ArrayValue)obj;
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }
}

