/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.value.window;

import org.iplass.mtp.entity.query.value.primary.PrimaryValue;
import org.iplass.mtp.entity.query.value.window.PartitionBy;
import org.iplass.mtp.entity.query.value.window.WindowOrderBy;
import org.iplass.mtp.entity.query.value.window.WindowSortSpec;

public abstract class WindowFunction
extends PrimaryValue {
    private static final long serialVersionUID = 1570026824441319021L;
    private PartitionBy partitionBy;
    private WindowOrderBy orderBy;

    public PartitionBy getPartitionBy() {
        return this.partitionBy;
    }

    public void setPartitionBy(PartitionBy partitionBy) {
        this.partitionBy = partitionBy;
    }

    public WindowOrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(WindowOrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public WindowFunction partitionBy(Object ... partitionField) {
        if (this.partitionBy == null) {
            this.partitionBy = new PartitionBy();
        }
        for (Object v : partitionField) {
            this.partitionBy.add(v);
        }
        return this;
    }

    public WindowFunction orderBy(WindowSortSpec ... sortSpec) {
        if (this.orderBy == null) {
            this.orderBy = new WindowOrderBy();
        }
        for (WindowSortSpec o : sortSpec) {
            this.orderBy.add(o);
        }
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.orderBy == null ? 0 : this.orderBy.hashCode());
        result = 31 * result + (this.partitionBy == null ? 0 : this.partitionBy.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WindowFunction other = (WindowFunction)obj;
        if (this.orderBy == null ? other.orderBy != null : !this.orderBy.equals(other.orderBy)) {
            return false;
        }
        return !(this.partitionBy == null ? other.partitionBy != null : !this.partitionBy.equals(other.partitionBy));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.writeWindowFunctionType(sb);
        sb.append(" over(");
        if (this.partitionBy != null) {
            sb.append(this.partitionBy);
        }
        if (this.orderBy != null) {
            if (this.partitionBy != null) {
                sb.append(' ');
            }
            sb.append(this.orderBy);
        }
        sb.append(")");
        return sb.toString();
    }

    protected abstract void writeWindowFunctionType(StringBuilder var1);
}

