/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth;

import java.util.List;
import java.util.TreeSet;
import org.iplass.mtp.impl.auth.UserContext;
import org.iplass.mtp.impl.auth.authenticate.AnonymousUserContext;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.auth.authorize.builtin.group.GroupContext;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;

public class UserBinding {
    private static final String GROUP_CODE = "groupCode";
    private UserContext userContext;
    private TenantAuthorizeContext authContext;
    private boolean otherTenant;
    private int tenantId;

    UserBinding(UserContext userContext, TenantAuthorizeContext authContext) {
        this.userContext = userContext;
        this.authContext = authContext;
        TenantContext callerTenant = ExecuteContext.getCurrentContext().getTenantContext();
        this.otherTenant = callerTenant.getTenantId() != authContext.getTenantContext().getTenantId();
        this.tenantId = callerTenant.getTenantId();
    }

    public Object getAttribute(String name) {
        if (name.equals(GROUP_CODE)) {
            return this.userContext.getGroupCode();
        }
        if (name.equals("admin") && this.otherTenant) {
            return false;
        }
        if (name.equals("accountId") && this.userContext instanceof AnonymousUserContext) {
            return null;
        }
        return this.userContext.getAttribute(name);
    }

    public boolean isAnonymous() {
        return this.userContext.getUser().isAnonymous();
    }

    public boolean isAdmin() {
        if (this.otherTenant) {
            return false;
        }
        return this.userContext.getUser().isAdmin();
    }

    public boolean isLocalAdmin() {
        return this.otherTenant && this.userContext.getUser().isAdmin();
    }

    public boolean isGrantAllPermissions() {
        if (this.otherTenant) {
            return false;
        }
        return this.userContext.getUser().isAdmin() && this.authContext.isGrantAllPermissionsToAdmin();
    }

    public boolean isOtherTenant() {
        return this.otherTenant;
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public String[] getGroupCodeWithChildren() {
        String[] groupCodeList = this.userContext.getGroupCode();
        if (groupCodeList == null) {
            return null;
        }
        TreeSet<String> list = new TreeSet<String>();
        for (String gc : groupCodeList) {
            GroupContext groupContext = this.authContext.getGroupContext(gc);
            if (groupContext == null) continue;
            List<GroupContext> gcl = groupContext.getAllNestedChildGroup();
            for (GroupContext gclgc : gcl) {
                list.add(gclgc.getGroupCode());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] getGroupCodeWithParents() {
        String[] groupCodeList = this.userContext.getGroupCode();
        if (groupCodeList == null) {
            return null;
        }
        TreeSet<String> list = new TreeSet<String>();
        for (String gc : groupCodeList) {
            GroupContext groupContext = this.authContext.getGroupContext(gc);
            if (groupContext == null) continue;
            List<GroupContext> gcl = groupContext.getGroupPath();
            for (GroupContext gclgc : gcl) {
                list.add(gclgc.getGroupCode());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] getGroupOidWithChildren() {
        String[] groupCodeList = this.userContext.getGroupCode();
        if (groupCodeList == null) {
            return null;
        }
        TreeSet<String> list = new TreeSet<String>();
        for (String gc : groupCodeList) {
            GroupContext groupContext = this.authContext.getGroupContext(gc);
            if (groupContext == null) continue;
            List<GroupContext> gcl = groupContext.getAllNestedChildGroup();
            for (GroupContext gclgc : gcl) {
                list.add(gclgc.getOid());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] getGroupOidWithParents() {
        String[] groupCodeList = this.userContext.getGroupCode();
        if (groupCodeList == null) {
            return null;
        }
        TreeSet<String> list = new TreeSet<String>();
        for (String gc : groupCodeList) {
            GroupContext groupContext = this.authContext.getGroupContext(gc);
            if (groupContext == null) continue;
            List<GroupContext> gcl = groupContext.getGroupPath();
            for (GroupContext gclgc : gcl) {
                list.add(gclgc.getOid());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] getGroupOid() {
        String[] groupCodeList = this.userContext.getGroupCode();
        if (groupCodeList == null) {
            return null;
        }
        TreeSet<String> list = new TreeSet<String>();
        for (String gc : groupCodeList) {
            GroupContext groupContext = this.authContext.getGroupContext(gc);
            if (groupContext == null) continue;
            list.add(groupContext.getOid());
        }
        return list.toArray(new String[list.size()]);
    }

    public boolean memberOf(String groupCode) {
        String[] groupCodeList = this.userContext.getGroupCode();
        if (groupCodeList == null) {
            return false;
        }
        for (String code : groupCodeList) {
            if (!code.equals(groupCode)) continue;
            return true;
        }
        for (String code : groupCodeList) {
            GroupContext group = this.authContext.getGroupContext(code);
            if (group == null) continue;
            List<GroupContext> path = group.getGroupPath();
            for (GroupContext gc : path) {
                if (!gc.getGroupCode().equals(groupCode)) continue;
                return true;
            }
        }
        return false;
    }
}

