/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.Select;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.hint.CacheHint;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProvider;
import org.iplass.mtp.impl.auth.authenticate.UserEntityResolver;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.builder.EntityBuilder;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;

public class DefaultUserEntityResolver
implements UserEntityResolver {
    public static List<String> DEFAULT_EAGER_LOAD_REFERENCE_PROPERTY = Collections.unmodifiableList(Arrays.asList("rank", "groups"));
    private AuthService authService;
    private boolean enableCache = true;
    private String unmodifiableUniqueKeyProperty = "oid";
    private List<String> eagerLoadReferenceProperty;
    private String filterCondition;
    private boolean byLoad = false;
    private Condition filterConditionNode;

    public boolean isEnableCache() {
        return this.enableCache;
    }

    public void setEnableCache(boolean enableCache) {
        this.enableCache = enableCache;
    }

    public boolean isByLoad() {
        return this.byLoad;
    }

    public void setByLoad(boolean byLoad) {
        this.byLoad = byLoad;
    }

    @Override
    public String getUnmodifiableUniqueKeyProperty() {
        return this.unmodifiableUniqueKeyProperty;
    }

    public void setUnmodifiableUniqueKeyProperty(String unmodifiableUniqueKeyProperty) {
        this.unmodifiableUniqueKeyProperty = unmodifiableUniqueKeyProperty;
    }

    public List<String> getEagerLoadReferenceProperty() {
        return this.eagerLoadReferenceProperty;
    }

    public void setEagerLoadReferenceProperty(List<String> eagerLoadReferenceProperty) {
        this.eagerLoadReferenceProperty = eagerLoadReferenceProperty;
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
    }

    @Override
    public User searchUser(AccountHandle account) {
        User user = this.searchUser(account.getUnmodifiableUniqueKey());
        return user;
    }

    public User searchUser(String key) {
        return this.authService.doSecuredAction(AuthContextHolder.getAuthContext().privilegedAuthContextHolder(), () -> {
            if (this.byLoad) {
                return this.searchUserByLoad(key);
            }
            return this.searchUserByOneEQL(key);
        });
    }

    private User searchUserByOneEQL(String key) {
        try {
            EntityContext ec = EntityContext.getCurrentContext();
            ArrayList<ValueExpression> selectVals = new ArrayList<ValueExpression>();
            EntityHandler userEh = ec.getHandlerByName("mtp.auth.User");
            for (PropertyHandler ph : userEh.getPropertyList(ec)) {
                if (!(ph instanceof PrimitivePropertyHandler)) continue;
                selectVals.add(new EntityField(ph.getName()));
            }
            if (this.eagerLoadReferenceProperty != null) {
                for (String refName : this.eagerLoadReferenceProperty) {
                    EntityHandler refEh = ((ReferencePropertyHandler)userEh.getPropertyCascade(refName, ec)).getReferenceEntityHandler(ec);
                    for (PropertyHandler ph : refEh.getPropertyList(ec)) {
                        if (!(ph instanceof PrimitivePropertyHandler)) continue;
                        selectVals.add(new EntityField(refName + "." + ph.getName()));
                    }
                }
            }
            Query q = new Query();
            q.setSelect(new Select(false, selectVals));
            if (this.enableCache) {
                q.select().addHint(new CacheHint(CacheHint.CacheScope.TRANSACTION));
            }
            q.from("mtp.auth.User");
            Condition c = new Equals(this.unmodifiableUniqueKeyProperty, key);
            if (this.filterConditionNode != null) {
                c = new And(c, (Condition)this.filterConditionNode.copy());
            }
            q.where(c);
            final EntityBuilder eb = new EntityBuilder(userEh, ec, q.getSelect().getSelectValues());
            EntityManager em = ManagerLocator.getInstance().getManager(EntityManager.class);
            em.search(q, new Predicate<Object[]>(){

                @Override
                public boolean test(Object[] data) {
                    eb.handle(data, null);
                    return true;
                }
            });
            eb.finished();
            Collection<Entity> result = eb.getCollection();
            if (!result.isEmpty()) {
                return (User)result.iterator().next();
            }
            return null;
        }
        catch (Exception e) {
            throw new EntityRuntimeException("failed to search mtp.auth.User.", e);
        }
    }

    private User searchUserByLoad(String key) {
        try {
            final String[] oid = new String[1];
            EntityManager em = ManagerLocator.getInstance().getManager(EntityManager.class);
            if (!this.unmodifiableUniqueKeyProperty.equals("oid")) {
                Query q = new Query().select("oid").from("mtp.auth.User");
                Condition c = new Equals(this.unmodifiableUniqueKeyProperty, key);
                if (this.filterConditionNode != null) {
                    c = new And(c, (Condition)this.filterConditionNode.copy());
                }
                q.where(c);
                em.search(q, new Predicate<Object[]>(){

                    @Override
                    public boolean test(Object[] data) {
                        oid[0] = (String)data[0];
                        return false;
                    }
                });
            } else {
                oid[0] = key;
            }
            if (oid[0] != null) {
                User user = this.eagerLoadReferenceProperty == null ? (User)em.load(oid[0], "mtp.auth.User", new LoadOption(false, false)) : (User)em.load(oid[0], "mtp.auth.User", new LoadOption(this.eagerLoadReferenceProperty));
                if (this.eagerLoadReferenceProperty != null) {
                    for (String pName : this.eagerLoadReferenceProperty) {
                        Object ref = user.getValue(pName);
                        if (ref == null) continue;
                        if (ref instanceof Entity) {
                            Entity refE = (Entity)ref;
                            user.setValue(pName, em.load(refE.getOid(), refE.getDefinitionName()));
                            continue;
                        }
                        if (!(ref instanceof Entity[])) continue;
                        Entity[] refEs = (Entity[])ref;
                        for (int i = 0; i < refEs.length; ++i) {
                            refEs[i] = em.load(refEs[i].getOid(), refEs[i].getDefinitionName());
                            user.setValue(pName, refEs);
                        }
                    }
                }
                return user;
            }
            return null;
        }
        catch (Exception e) {
            throw new EntityRuntimeException("failed to search mtp.auth.User.", e);
        }
    }

    @Override
    public void inited(AuthService service, AuthenticationProvider provider) {
        this.authService = service;
        if (this.filterCondition != null) {
            this.filterConditionNode = Condition.newCondition(this.filterCondition);
        }
    }
}

