/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.builtin;

import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.builtin.BuiltinAccount;

public class BuiltinAccountHandle
implements AccountHandle {
    private static final long serialVersionUID = -5079682470668709171L;
    private String accountId;
    private String oid;
    private boolean isAccountLocked;
    private boolean isPasswordExpired;
    private boolean isInitialLogin;
    private Map<String, Object> attributeMap;
    private int authenticationProviderIndex;

    public BuiltinAccountHandle() {
    }

    public BuiltinAccountHandle(BuiltinAccount account, String policyName) {
        this.accountId = account.getAccountId();
        this.oid = account.getOid();
        this.getAttributeMap().put("lastPasswordChange", account.getLastPasswordChange());
        this.getAttributeMap().put("accountPolicy", policyName);
        this.getAttributeMap().put("lastLoginOn", account.getLastLoginOn());
    }

    @Override
    public boolean isAccountLocked() {
        return this.isAccountLocked;
    }

    public void setAccountLocked(boolean isAccountLocked) {
        this.isAccountLocked = isAccountLocked;
    }

    @Override
    public boolean isExpired() {
        return this.isPasswordExpired;
    }

    public void setPasswordExpired(boolean isPasswordExpired) {
        this.isPasswordExpired = isPasswordExpired;
    }

    @Override
    public boolean isInitialLogin() {
        return this.isInitialLogin;
    }

    public void setInitialLogin(boolean isInitialLogin) {
        this.isInitialLogin = isInitialLogin;
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap<String, Object>();
        }
        return this.attributeMap;
    }

    @Override
    public Credential getCredential() {
        return new IdPasswordCredential(this.accountId, null);
    }

    @Override
    public void setAuthenticationProviderIndex(int authenticationProviderIndex) {
        this.authenticationProviderIndex = authenticationProviderIndex;
    }

    @Override
    public int getAuthenticationProviderIndex() {
        return this.authenticationProviderIndex;
    }

    @Override
    public String getUnmodifiableUniqueKey() {
        return this.oid;
    }
}

