/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.builtin.policy;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.iplass.mtp.auth.login.CredentialUpdateException;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.auth.policy.AccountNotification;
import org.iplass.mtp.auth.policy.AccountNotificationListener;
import org.iplass.mtp.auth.policy.PasswordNotification;
import org.iplass.mtp.auth.policy.PropertyNotification;
import org.iplass.mtp.auth.policy.definition.AccountNotificationListenerDefinition;
import org.iplass.mtp.auth.policy.definition.AuthenticationPolicyDefinition;
import org.iplass.mtp.impl.auth.AccountManagementModuleWrapper;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.LoggingAccountManagementModule;
import org.iplass.mtp.impl.auth.authenticate.AccountManagementModule;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProvider;
import org.iplass.mtp.impl.auth.authenticate.builtin.BuiltinAccount;
import org.iplass.mtp.impl.auth.authenticate.builtin.BuiltinAccountHandle;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaAccountLockoutPolicy;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaAccountNotificationListener;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaPasswordPolicy;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaRememberMePolicy;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.util.random.SecureRandomGenerator;
import org.iplass.mtp.impl.util.random.SecureRandomService;
import org.iplass.mtp.spi.ServiceRegistry;

public class MetaAuthenticationPolicy
extends BaseRootMetaData
implements DefinableMetaData<AuthenticationPolicyDefinition> {
    private static final long serialVersionUID = 7953683827749947294L;
    private MetaAccountLockoutPolicy accountLockoutPolicy;
    private MetaPasswordPolicy passwordPolicy;
    private boolean recordLastLoginDate = true;
    private MetaRememberMePolicy rememberMePolicy;
    private List<String> authenticationProvider;
    private List<MetaAccountNotificationListener> notificationListener;

    public List<String> getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    public void setAuthenticationProvider(List<String> authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    public MetaRememberMePolicy getRememberMePolicy() {
        return this.rememberMePolicy;
    }

    public void setRememberMePolicy(MetaRememberMePolicy rememberMePolicy) {
        this.rememberMePolicy = rememberMePolicy;
    }

    public MetaAccountLockoutPolicy getAccountLockoutPolicy() {
        return this.accountLockoutPolicy;
    }

    public void setAccountLockoutPolicy(MetaAccountLockoutPolicy accountLockoutPolicy) {
        this.accountLockoutPolicy = accountLockoutPolicy;
    }

    public MetaPasswordPolicy getPasswordPolicy() {
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(MetaPasswordPolicy passwordPolicy) {
        this.passwordPolicy = passwordPolicy;
    }

    public boolean isRecordLastLoginDate() {
        return this.recordLastLoginDate;
    }

    public void setRecordLastLoginDate(boolean recordLastLoginDate) {
        this.recordLastLoginDate = recordLastLoginDate;
    }

    public List<MetaAccountNotificationListener> getNotificationListener() {
        return this.notificationListener;
    }

    public void setNotificationListener(List<MetaAccountNotificationListener> notificationListener) {
        this.notificationListener = notificationListener;
    }

    @Override
    public AuthenticationPolicyRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new AuthenticationPolicyRuntime();
    }

    @Override
    public MetaAuthenticationPolicy copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public void applyConfig(AuthenticationPolicyDefinition def) {
        this.name = def.getName();
        this.description = def.getDescription();
        this.displayName = def.getDisplayName();
        this.localizedDisplayNameList = I18nUtil.toMeta(def.getLocalizedDisplayNameList());
        if (def.getAccountLockoutPolicy() != null) {
            this.accountLockoutPolicy = new MetaAccountLockoutPolicy();
            this.accountLockoutPolicy.applyConfig(def.getAccountLockoutPolicy());
        } else {
            this.accountLockoutPolicy = null;
        }
        if (def.getPasswordPolicy() != null) {
            this.passwordPolicy = new MetaPasswordPolicy();
            this.passwordPolicy.applyConfig(def.getPasswordPolicy());
        } else {
            this.passwordPolicy = null;
        }
        this.recordLastLoginDate = def.isRecordLastLoginDate();
        if (def.getRememberMePolicy() != null) {
            this.rememberMePolicy = new MetaRememberMePolicy();
            this.rememberMePolicy.applyConfig(def.getRememberMePolicy());
        } else {
            this.rememberMePolicy = null;
        }
        if (def.getNotificationListener() != null) {
            this.notificationListener = new ArrayList<MetaAccountNotificationListener>();
            for (AccountNotificationListenerDefinition anld : def.getNotificationListener()) {
                MetaAccountNotificationListener manl = MetaAccountNotificationListener.newMeta(anld);
                manl.applyConfig(anld);
                this.notificationListener.add(manl);
            }
        } else {
            this.notificationListener = null;
        }
        this.authenticationProvider = def.getAuthenticationProvider() != null ? new ArrayList<String>(def.getAuthenticationProvider()) : null;
    }

    @Override
    public AuthenticationPolicyDefinition currentConfig() {
        AuthenticationPolicyDefinition def = new AuthenticationPolicyDefinition();
        def.setName(this.name);
        def.setDescription(this.description);
        def.setDisplayName(this.displayName);
        def.setLocalizedDisplayNameList(I18nUtil.toDef(this.localizedDisplayNameList));
        if (this.accountLockoutPolicy != null) {
            def.setAccountLockoutPolicy(this.accountLockoutPolicy.currentConfig());
        }
        if (this.passwordPolicy != null) {
            def.setPasswordPolicy(this.passwordPolicy.currentConfig());
        }
        def.setRecordLastLoginDate(this.recordLastLoginDate);
        if (this.rememberMePolicy != null) {
            def.setRememberMePolicy(this.rememberMePolicy.currentConfig());
        }
        if (this.notificationListener != null) {
            ArrayList<AccountNotificationListenerDefinition> nlist = new ArrayList<AccountNotificationListenerDefinition>();
            for (MetaAccountNotificationListener manl : this.notificationListener) {
                nlist.add(manl.currentConfig());
            }
            def.setNotificationListener(nlist);
        }
        if (this.authenticationProvider != null) {
            def.setAuthenticationProvider(new ArrayList<String>(this.authenticationProvider));
        }
        return def;
    }

    private static String resourceString(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }

    public class AuthenticationPolicyRuntime
    extends BaseMetaDataRuntime {
        private List<AccountNotificationListener> listeners;
        private Pattern passwordPattern;
        private char[] randomPasswordIncludeSigns;
        private char[] randomPasswordExcludeChars;
        private AccountManagementModule amm;

        public AuthenticationPolicyRuntime() {
            try {
                this.listeners = new ArrayList<AccountNotificationListener>();
                if (MetaAuthenticationPolicy.this.notificationListener != null) {
                    AuthenticationPolicyDefinition def = MetaAuthenticationPolicy.this.currentConfig();
                    for (int i = 0; i < MetaAuthenticationPolicy.this.notificationListener.size(); ++i) {
                        AccountNotificationListener anl = ((MetaAccountNotificationListener)MetaAuthenticationPolicy.this.notificationListener.get(i)).createInstance(MetaAuthenticationPolicy.this.name, i);
                        anl.init(def);
                        this.listeners.add(anl);
                    }
                }
                if (MetaAuthenticationPolicy.this.passwordPolicy != null) {
                    if (MetaAuthenticationPolicy.this.passwordPolicy.getPasswordPattern() != null && MetaAuthenticationPolicy.this.passwordPolicy.getPasswordPattern().length() > 0) {
                        this.passwordPattern = Pattern.compile(MetaAuthenticationPolicy.this.passwordPolicy.getPasswordPattern());
                    }
                    if (MetaAuthenticationPolicy.this.passwordPolicy.getRandomPasswordIncludeSigns() != null && MetaAuthenticationPolicy.this.passwordPolicy.getRandomPasswordIncludeSigns().length() > 0) {
                        this.randomPasswordIncludeSigns = MetaAuthenticationPolicy.this.passwordPolicy.getRandomPasswordIncludeSigns().toCharArray();
                    }
                    if (MetaAuthenticationPolicy.this.passwordPolicy.getRandomPasswordExcludeChars() != null && MetaAuthenticationPolicy.this.passwordPolicy.getRandomPasswordExcludeChars().length() > 0) {
                        this.randomPasswordExcludeChars = MetaAuthenticationPolicy.this.passwordPolicy.getRandomPasswordExcludeChars().toCharArray();
                    }
                }
                if (MetaAuthenticationPolicy.this.authenticationProvider != null && MetaAuthenticationPolicy.this.authenticationProvider.size() > 0) {
                    AuthenticationProvider[] aps;
                    AccountManagementModuleWrapper ammr = new AccountManagementModuleWrapper();
                    for (AuthenticationProvider ap : aps = ServiceRegistry.getRegistry().getService(AuthService.class).getAuthenticationProviders()) {
                        if (!MetaAuthenticationPolicy.this.authenticationProvider.contains(ap.getProviderName())) continue;
                        ammr.add(ap.getAccountManagementModule());
                    }
                    this.amm = new LoggingAccountManagementModule(ammr.stripOrThis());
                }
            }
            catch (RuntimeException e) {
                this.setIllegalStateException(e);
            }
        }

        public AccountManagementModule getAccountManagementModule() {
            return this.amm;
        }

        @Override
        public MetaAuthenticationPolicy getMetaData() {
            return MetaAuthenticationPolicy.this;
        }

        public List<AccountNotificationListener> getListeners() {
            return this.listeners;
        }

        public void addAccountNotificationListener(AccountNotificationListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<AccountNotificationListener>();
            }
            this.listeners.add(listener);
        }

        public boolean removeAccountNotificationListener(AccountNotificationListener listener) {
            if (this.listeners != null) {
                return this.listeners.remove(listener);
            }
            return false;
        }

        public void notify(AccountNotification notification) {
            this.checkState();
            if (this.listeners != null) {
                block8: for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    AccountNotificationListener listener = this.listeners.get(i);
                    switch (notification.getType()) {
                        case CREATED: {
                            listener.created((PasswordNotification)notification);
                            continue block8;
                        }
                        case CREDENTIAL_RESET: {
                            listener.credentialReset((PasswordNotification)notification);
                            continue block8;
                        }
                        case ROCKEDOUT: {
                            listener.rockedout(notification);
                            continue block8;
                        }
                        case CREDENTIAL_UPDATED: {
                            listener.credentialUpdated((PasswordNotification)notification);
                            continue block8;
                        }
                        case PROPERTY_UPDATED: {
                            listener.propertyUpdated((PropertyNotification)notification);
                            continue block8;
                        }
                        case REMOVE: {
                            listener.remove(notification);
                            continue block8;
                        }
                    }
                }
            }
        }

        public boolean isJustLockedout(BuiltinAccount account) {
            return this.isCheckLockout() && account.getLoginErrorCnt() == MetaAuthenticationPolicy.this.accountLockoutPolicy.getLockoutFailureCount();
        }

        public boolean isCheckLockout() {
            return MetaAuthenticationPolicy.this.accountLockoutPolicy.getLockoutFailureCount() > 0;
        }

        public boolean initLoginStatus(BuiltinAccount account) {
            if (this.isCheckLockout() && MetaAuthenticationPolicy.this.accountLockoutPolicy.getLockoutFailureExpirationInterval() > 0) {
                Timestamp loginErrorDate = account.getLoginErrorDate();
                if (account.getLoginErrorCnt() > 0 && loginErrorDate != null) {
                    long currentTime = System.currentTimeMillis();
                    if (loginErrorDate.getTime() + TimeUnit.MINUTES.toMillis(MetaAuthenticationPolicy.this.accountLockoutPolicy.getLockoutFailureExpirationInterval()) < currentTime) {
                        account.resetLoginErrorCount();
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean checkLoginPolicy(BuiltinAccountHandle accountHandle, BuiltinAccount account) {
            boolean isUpdateAccount = false;
            long currentTime = System.currentTimeMillis();
            if (this.isCheckLockout()) {
                if (account.getLoginErrorCnt() >= MetaAuthenticationPolicy.this.accountLockoutPolicy.getLockoutFailureCount()) {
                    Timestamp loginErrorDate = account.getLoginErrorDate();
                    if (MetaAuthenticationPolicy.this.accountLockoutPolicy.getLockoutDuration() == 0 || loginErrorDate == null || loginErrorDate.getTime() + TimeUnit.MINUTES.toMillis(MetaAuthenticationPolicy.this.accountLockoutPolicy.getLockoutDuration()) >= currentTime) {
                        accountHandle.setAccountLocked(true);
                    } else {
                        account.resetLoginErrorCount();
                        isUpdateAccount = true;
                    }
                } else if (account.getLoginErrorCnt() > 0) {
                    account.resetLoginErrorCount();
                    isUpdateAccount = true;
                }
            }
            if (account.getLastPasswordChange() == null) {
                accountHandle.setPasswordExpired(true);
                accountHandle.setInitialLogin(true);
            } else if (this.isOverMaximumPasswordAge(account, currentTime)) {
                accountHandle.setPasswordExpired(true);
            }
            if (MetaAuthenticationPolicy.this.isRecordLastLoginDate() && !accountHandle.isAccountLocked() && !accountHandle.isExpired()) {
                account.setLastLoginOn(new Timestamp(currentTime));
                isUpdateAccount = true;
            }
            return isUpdateAccount;
        }

        public void checkPasswordUpdatePolicy(IdPasswordCredential newIdPass, BuiltinAccount account) {
            this.checkPasswordPattern(newIdPass.getPassword());
            if (this.isUnderMinimumPasswordAge(account, System.currentTimeMillis())) {
                throw new CredentialUpdateException(MetaAuthenticationPolicy.resourceString("impl.auth.authenticate.updateCredential.minTermErr", new Object[0]));
            }
        }

        private boolean isOverMaximumPasswordAge(BuiltinAccount account, long now) {
            if (MetaAuthenticationPolicy.this.passwordPolicy.getMaximumPasswordAge() > 0) {
                if (account.getLastPasswordChange() == null) {
                    return true;
                }
                long lastPasswordChange = account.getLastPasswordChange().getTime();
                if (now >= lastPasswordChange + TimeUnit.DAYS.toMillis(MetaAuthenticationPolicy.this.passwordPolicy.getMaximumPasswordAge())) {
                    return true;
                }
            }
            return false;
        }

        private boolean isUnderMinimumPasswordAge(BuiltinAccount account, long now) {
            if (MetaAuthenticationPolicy.this.passwordPolicy.getMinimumPasswordAge() > 0) {
                if (account.getLastPasswordChange() == null) {
                    return false;
                }
                long lastPasswordChange = account.getLastPasswordChange().getTime();
                if (now <= lastPasswordChange + TimeUnit.DAYS.toMillis(MetaAuthenticationPolicy.this.passwordPolicy.getMinimumPasswordAge())) {
                    return true;
                }
            }
            return false;
        }

        public void checkPasswordPattern(String password) {
            if (this.passwordPattern != null && !this.passwordPattern.matcher(password).matches()) {
                String passwordPatternErrorMessage = I18nUtil.stringMeta(MetaAuthenticationPolicy.this.passwordPolicy.getPasswordPatternErrorMessage(), MetaAuthenticationPolicy.this.passwordPolicy.getLocalizedPasswordPatternErrorMessageList());
                throw new CredentialUpdateException(passwordPatternErrorMessage);
            }
        }

        public String makePassword() {
            return this.makeRandomString(MetaAuthenticationPolicy.this.passwordPolicy.getRandomPasswordLength(), this.randomPasswordIncludeSigns != null, this.randomPasswordIncludeSigns, this.randomPasswordExcludeChars);
        }

        public boolean isResetPasswordWithSpecificPassword() {
            return MetaAuthenticationPolicy.this.passwordPolicy.isResetPasswordWithSpecificPassword();
        }

        private String makeRandomString(int length, boolean isSign, char[] sign, char[] excludedChar) {
            char[] c = new char[length];
            int num = isSign ? 4 : 3;
            for (int i = 0; i < c.length; ++i) {
                int buf = 32;
                switch (RandomHolder.random.randomInt(num)) {
                    case 0: {
                        buf = this.createBuf(97, 26, null, false, excludedChar, RandomHolder.random);
                        break;
                    }
                    case 1: {
                        buf = this.createBuf(65, 26, null, false, excludedChar, RandomHolder.random);
                        break;
                    }
                    case 2: {
                        buf = this.createBuf(48, 10, null, false, excludedChar, RandomHolder.random);
                        break;
                    }
                    case 3: {
                        buf = this.createBuf(-1, -1, sign, true, excludedChar, RandomHolder.random);
                    }
                }
                c[i] = buf;
            }
            return new String(c);
        }

        private char createBuf(int start, int length, char[] sign, boolean signBuf, char[] excludedChar, SecureRandomGenerator rand) {
            char buf;
            block4: {
                boolean exclude;
                block0: do {
                    if (signBuf) {
                        int index = rand.randomInt(sign.length - 1);
                        buf = sign[index];
                    } else {
                        buf = (char)(start + rand.randomInt(length));
                    }
                    exclude = false;
                    if (excludedChar == null) break block4;
                    for (char c : excludedChar) {
                        if (c != buf) continue;
                        exclude = true;
                        continue block0;
                    }
                } while (exclude);
                return buf;
            }
            return buf;
        }
    }

    private static class RandomHolder {
        static final SecureRandomGenerator random = ServiceRegistry.getRegistry().getService(SecureRandomService.class).createGenerator();

        private RandomHolder() {
        }
    }
}

