/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.jaas;

import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.IdPasswordCredential;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;

public class JaasAccountHandle
implements AccountHandle {
    private static final long serialVersionUID = -1085557232795815436L;
    private String id;
    private String uniqueKey;
    private boolean isAccountLocked;
    private boolean isPasswordExpired;
    private boolean isInitialLogin;
    private Map<String, Object> attributeMap;
    private int authenticationProviderIndex;
    private Subject subject;
    private transient LoginContext loginContext;

    public JaasAccountHandle() {
    }

    public JaasAccountHandle(String id, Class<? extends Principal> uniqueKeyPrincipalType, LoginContext loginContext) {
        this.id = id;
        this.loginContext = loginContext;
        this.subject = loginContext.getSubject();
        this.attributeMap = new HashMap<String, Object>();
        for (Principal p : this.subject.getPrincipals()) {
            Object prev;
            if (p.getClass() == uniqueKeyPrincipalType) {
                this.uniqueKey = p.getName();
            }
            if ((prev = this.attributeMap.get(p.getClass().getName())) == null) {
                this.attributeMap.put(p.getClass().getName(), p.getName());
                continue;
            }
            if (prev instanceof String) {
                this.attributeMap.put(p.getClass().getName(), new String[]{(String)prev, p.getName()});
                continue;
            }
            String[] prevArray = (String[])prev;
            String[] newArray = Arrays.copyOf(prevArray, prevArray.length + 1);
            newArray[prevArray.length] = p.getName();
            this.attributeMap.put(p.getClass().getName(), newArray);
        }
        if (this.uniqueKey == null) {
            this.uniqueKey = id;
        }
    }

    public Subject getSubject() {
        return this.subject;
    }

    public LoginContext getLoginContext() {
        return this.loginContext;
    }

    @Override
    public boolean isAccountLocked() {
        return this.isAccountLocked;
    }

    public void setAccountLocked(boolean isAccountLocked) {
        this.isAccountLocked = isAccountLocked;
    }

    @Override
    public boolean isExpired() {
        return this.isPasswordExpired;
    }

    public void setPasswordExpired(boolean isPasswordExpired) {
        this.isPasswordExpired = isPasswordExpired;
    }

    @Override
    public boolean isInitialLogin() {
        return this.isInitialLogin;
    }

    public void setInitialLogin(boolean isInitialLogin) {
        this.isInitialLogin = isInitialLogin;
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        return this.attributeMap;
    }

    @Override
    public Credential getCredential() {
        return new IdPasswordCredential(this.id, null);
    }

    @Override
    public void setAuthenticationProviderIndex(int authenticationProviderIndex) {
        this.authenticationProviderIndex = authenticationProviderIndex;
    }

    @Override
    public int getAuthenticationProviderIndex() {
        return this.authenticationProviderIndex;
    }

    @Override
    public String getUnmodifiableUniqueKey() {
        return this.uniqueKey;
    }
}

