/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.simpletoken;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.token.SimpleAuthTokenCredential;
import org.iplass.mtp.auth.login.token.SimpleAuthTokenInfo;
import org.iplass.mtp.auth.token.AuthTokenInfo;
import org.iplass.mtp.impl.auth.authenticate.token.AuthToken;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenHandler;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenService;
import org.iplass.mtp.spi.Config;

public class SimpleAuthTokenHandler
extends AuthTokenHandler {
    public static final String TYPE_SIMPLE_DEFAULT = "SAT";

    @Override
    public void inited(AuthTokenService service, Config config) {
        super.inited(service, config);
        if (this.getType() == null) {
            this.setType(TYPE_SIMPLE_DEFAULT);
        }
    }

    @Override
    public AuthTokenInfo toAuthTokenInfo(AuthToken authToken) {
        SimpleAuthTokenInfo info = new SimpleAuthTokenInfo();
        info.setType(authToken.getType());
        info.setKey(authToken.getSeries());
        Map details = (Map)((Object)authToken.getDetails());
        if (details != null) {
            info.setApplication((String)details.get("application"));
        }
        return info;
    }

    @Override
    public Credential toCredential(AuthToken newToken) {
        return new SimpleAuthTokenCredential(newToken.encodeToken());
    }

    @Override
    protected Serializable createDetails(String seriesString, String tokenString, String userUniqueId, String policyName, AuthTokenInfo tokenInfo) {
        SimpleAuthTokenInfo sat = (SimpleAuthTokenInfo)tokenInfo;
        HashMap<String, String> details = null;
        if (sat.getApplication() != null) {
            details = new HashMap<String, String>();
            details.put("application", sat.getApplication());
        }
        return details;
    }
}

