/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cluster;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.iplass.mtp.impl.cluster.ClusterEventListener;

public class ListenerMap {
    private final ConcurrentHashMap<String, List<ClusterEventListener>> listenerMap = new ConcurrentHashMap(16, 0.75f, 32);

    public void init() {
        this.listenerMap.clear();
    }

    public List<ClusterEventListener> getListener(String eventName) {
        List<ClusterEventListener> l = this.listenerMap.get(eventName);
        if (l == null) {
            return Collections.emptyList();
        }
        return l;
    }

    public void addListener(String eventName, ClusterEventListener listener) {
        CopyOnWriteArrayList<ClusterEventListener> newList;
        List currentList = this.listenerMap.get(eventName);
        if (currentList == null && (currentList = (List)this.listenerMap.putIfAbsent(eventName, newList = new CopyOnWriteArrayList<ClusterEventListener>(new ClusterEventListener[]{listener}))) == null) {
            return;
        }
        currentList.add((ClusterEventListener)listener);
    }

    public void removeListener(String eventName, ClusterEventListener listener) {
        List<ClusterEventListener> currentList = this.listenerMap.get(eventName);
        if (currentList != null) {
            currentList.remove(listener);
        }
    }
}

