/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.core;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateUtils;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.impl.core.Executable;
import org.iplass.mtp.impl.core.Finalizable;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.i18n.I18nService;
import org.iplass.mtp.impl.i18n.LocaleFormat;
import org.iplass.mtp.impl.logging.LoggingContext;
import org.iplass.mtp.impl.tenant.MetaTenant;
import org.iplass.mtp.impl.tenant.MetaTenantI18nInfo;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.tenant.TenantI18nInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ExecuteContext {
    public static final String MDC_TENANT = "tenant";
    public static final String MDC_TENANT_NAME = "tenantName";
    private static final Logger logger = LoggerFactory.getLogger(ExecuteContext.class);
    private TenantContext tenantContext;
    private Tenant currentTenant;
    private String clientId;
    private Timestamp currentTimestamp;
    private Date currentLocalDate;
    private Time currentLocalTime;
    private ExecuteContext prevStacked;
    private String language;
    private Locale langLocale;
    private Timestamp defaultEndDate;
    private Locale locale;
    private TimeZone timeZone;
    private LocaleFormat localeFormat;
    private HashMap<String, AttributeEntry> contextMap;
    private static ThreadLocal<ExecuteContext> context = new ThreadLocal();

    public static final ExecuteContext getCurrentContext() {
        if (context.get() == null) {
            logger.debug("no ExecuteContext... create dummy as tenant -1");
            TenantContext t = new TenantContext(-1, "_shared", "/", true);
            ExecuteContext.initContext(new ExecuteContext(t, "0", "0"));
        }
        return context.get();
    }

    public static boolean isInited() {
        return context.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeAs(TenantContext tenant, Executable<T> exec) {
        AttributeEntry val;
        ExecuteContext current = context.get();
        String currentMdcTenant = MDC.get((String)MDC_TENANT);
        String currentMdcTenantName = MDC.get((String)MDC_TENANT_NAME);
        ExecuteContext nested = null;
        try {
            if (current != null) {
                nested = new ExecuteContext(tenant);
                nested.prevStacked = current;
                if (current.contextMap != null) {
                    HashMap<String, AttributeEntry> nestedContextMap = new HashMap<String, AttributeEntry>();
                    for (Map.Entry<String, AttributeEntry> e : current.contextMap.entrySet()) {
                        val = e.getValue();
                        if (val == null || !val.isShare || val.removed) continue;
                        nestedContextMap.put(e.getKey(), val);
                    }
                    nested.contextMap = nestedContextMap;
                }
                nested.currentTimestamp = current.currentTimestamp;
            } else {
                nested = new ExecuteContext(tenant);
            }
            context.set(nested);
            MDC.put((String)MDC_TENANT, (String)nested.getTenantContext().getTenantIdString());
            MDC.put((String)MDC_TENANT_NAME, (String)nested.getTenantContext().getTenantName());
            if (logger.isDebugEnabled()) {
                if (current == null) {
                    logger.debug("execute as tenant:" + tenant.getTenantId() + ", context:" + nested);
                } else {
                    logger.debug("execute as tenant:" + tenant.getTenantId() + ", prevStackTenant:" + current.getClientTenantId() + ", context:" + nested);
                }
            }
            T t = exec.execute();
            return t;
        }
        finally {
            try {
                if (current != null && nested != null && nested.contextMap != null) {
                    if (current.contextMap == null) {
                        current.contextMap = new HashMap();
                    }
                    for (Map.Entry<String, AttributeEntry> e : nested.contextMap.entrySet()) {
                        val = e.getValue();
                        if (val == null || !val.isShare) continue;
                        if (val.removed) {
                            current.contextMap.remove(e.getKey());
                            continue;
                        }
                        current.contextMap.put(e.getKey(), val);
                    }
                }
            }
            catch (RuntimeException e) {
                logger.error("error on ExecuteContext#executeAs() finally process:" + e, (Throwable)e);
            }
            finally {
                if (nested != null) {
                    nested.finallyProcess();
                }
                context.set(current);
                if (currentMdcTenant != null) {
                    MDC.put((String)MDC_TENANT, (String)currentMdcTenant);
                } else {
                    MDC.remove((String)MDC_TENANT);
                }
                if (currentMdcTenantName != null) {
                    MDC.put((String)MDC_TENANT_NAME, (String)currentMdcTenantName);
                } else {
                    MDC.remove((String)MDC_TENANT_NAME);
                }
            }
        }
    }

    public static void finContext() {
        ExecuteContext current = context.get();
        if (current != null) {
            current.finallyProcess();
            context.remove();
            MDC.clear();
        }
    }

    public static void initContext(ExecuteContext mtfContext) {
        ExecuteContext previous = context.get();
        if (previous != null) {
            logger.debug("previous ExecuteContext exists.. so cleanup before initContext:" + previous);
            previous.finallyProcess();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("init execute context:" + mtfContext);
        }
        context.set(mtfContext);
        if (mtfContext != null && mtfContext.getTenantContext() != null) {
            MDC.put((String)MDC_TENANT, (String)mtfContext.getTenantContext().getTenantIdString());
            MDC.put((String)MDC_TENANT_NAME, (String)mtfContext.getTenantContext().getTenantName());
        } else {
            MDC.clear();
        }
    }

    public static void setContext(ExecuteContext mtfContext) {
        if (logger.isDebugEnabled()) {
            logger.debug("set context:" + mtfContext);
        }
        context.set(mtfContext);
        if (mtfContext != null && mtfContext.getTenantContext() != null) {
            MDC.put((String)MDC_TENANT, (String)mtfContext.getTenantContext().getTenantIdString());
            MDC.put((String)MDC_TENANT_NAME, (String)mtfContext.getTenantContext().getTenantName());
        } else {
            MDC.clear();
        }
    }

    public ExecuteContext(TenantContext tenantContext, String clientId, String sessionId) {
        this.tenantContext = tenantContext;
        this.clientId = clientId;
    }

    public ExecuteContext(TenantContext tenantContext) {
        this.tenantContext = tenantContext;
    }

    public void mdcPut(String key, String val) {
        LoggingContext lc;
        String preVal = MDC.get((String)key);
        MDC.put((String)key, (String)val);
        if (!Objects.equals(preVal, val) && (lc = this.getTenantContext().getResource(LoggingContext.class)) != null) {
            lc.resetMatched(this);
        }
    }

    public Timestamp getDefaultEndDate() {
        if (this.defaultEndDate == null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                sdf.setTimeZone(this.getTimeZone());
                this.defaultEndDate = new Timestamp(sdf.parse("20991231").getTime());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return (Timestamp)this.defaultEndDate.clone();
    }

    public Locale getLocale() {
        this.initI18n();
        return this.locale;
    }

    public TimeZone getTimeZone() {
        this.initI18n();
        return this.timeZone;
    }

    public LocaleFormat getLocaleFormat() {
        this.initI18n();
        return this.localeFormat;
    }

    public Locale getLangLocale() {
        this.initI18n();
        return this.langLocale;
    }

    private void initI18n() {
        if (this.locale == null || this.langLocale == null) {
            MetaTenantI18nInfo.MetaTenantI18nInfoRuntime tenanti18n;
            I18nService i18n = ServiceRegistry.getRegistry().getService(I18nService.class);
            MetaTenant.MetaTenantHandler mth = this.tenantContext.getTenantRuntime();
            MetaTenantI18nInfo.MetaTenantI18nInfoRuntime metaTenantI18nInfoRuntime = tenanti18n = mth != null ? mth.getConfigRuntime(MetaTenantI18nInfo.MetaTenantI18nInfoRuntime.class) : null;
            if (this.locale == null) {
                if (tenanti18n != null) {
                    this.locale = tenanti18n.getLocale();
                    this.timeZone = tenanti18n.getTimeZone();
                } else {
                    this.locale = i18n.getLocale();
                    this.timeZone = i18n.getTimezone();
                }
                this.localeFormat = i18n.getLocaleFormat(this.locale.toString(), this.getCurrentTenant());
            }
            if (this.langLocale == null) {
                User user;
                String lang;
                TenantI18nInfo t = this.getCurrentTenant().getTenantConfig(TenantI18nInfo.class);
                if (t.isUseMultilingual() && t.getUseLanguageList() != null && (lang = (user = AuthContext.getCurrentContext().getUser()).getLanguage()) != null) {
                    for (String tl : t.getUseLanguageList()) {
                        if (!lang.equals(tl)) continue;
                        this.language = lang;
                        this.langLocale = Locale.forLanguageTag(this.language);
                        break;
                    }
                }
                if (this.langLocale == null) {
                    if (tenanti18n != null) {
                        this.langLocale = tenanti18n.getLangLocale();
                        this.language = this.langLocale.toLanguageTag();
                    } else {
                        this.langLocale = i18n.selectLangLocale(this.locale);
                        this.language = this.langLocale.toLanguageTag();
                    }
                }
            }
        }
    }

    public String getLanguage() {
        this.initI18n();
        return this.language;
    }

    public void setLanguage(String language) {
        if (language != null && !language.equals(this.language)) {
            this.language = language;
            this.langLocale = Locale.forLanguageTag(language);
        }
    }

    public void clearLanguage() {
        this.language = null;
        this.langLocale = null;
    }

    public ExecuteContext getPrevStacked() {
        return this.prevStacked;
    }

    private void finallyProcess() {
        if (logger.isDebugEnabled()) {
            logger.debug("finalize execute context:" + this);
        }
        try {
            if (this.contextMap != null) {
                for (Map.Entry<String, AttributeEntry> e : this.contextMap.entrySet()) {
                    AttributeEntry val = e.getValue();
                    if (val == null || !(val.attribute instanceof Finalizable) || val.isShare && this.prevStacked != null) continue;
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug("finalize " + e.getValue() + "...");
                        }
                        ((Finalizable)((Object)e.getValue())).finallyProcess();
                    }
                    catch (Exception ex) {
                        logger.error("execute context finalize error, mybe resource leak...", (Throwable)ex);
                    }
                }
            }
        }
        catch (RuntimeException e) {
            logger.error("error on ExecuteContext#finallyProcess():" + e, (Throwable)e);
        }
        this.contextMap = null;
    }

    public int getClientTenantId() {
        return this.tenantContext.getTenantId();
    }

    public Tenant getCurrentTenant() {
        if (this.currentTenant == null) {
            this.currentTenant = this.tenantContext.loadTenantInfo();
        }
        return this.currentTenant;
    }

    public TenantContext getTenantContext() {
        return this.tenantContext;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Object getAttribute(String key) {
        if (this.contextMap == null) {
            return null;
        }
        AttributeEntry val = this.contextMap.get(key);
        if (val == null) {
            return null;
        }
        if (val.removed) {
            return null;
        }
        return val.attribute;
    }

    public void setAttribute(String key, Object value, boolean shareContext) {
        if (this.contextMap == null) {
            this.contextMap = new HashMap();
        }
        this.contextMap.put(key, new AttributeEntry(value, shareContext));
    }

    public Timestamp getCurrentTimestamp() {
        if (this.currentTimestamp == null) {
            this.currentTimestamp = new Timestamp(System.currentTimeMillis());
        }
        return (Timestamp)this.currentTimestamp.clone();
    }

    public void setCurrentTimestamp(Timestamp currentTimestamp) {
        this.currentTimestamp = currentTimestamp;
        this.currentLocalDate = null;
        this.currentLocalTime = null;
    }

    public void refreshCurrentTimestamp() {
        this.currentTimestamp = new Timestamp(System.currentTimeMillis());
        this.currentLocalDate = null;
        this.currentLocalTime = null;
    }

    public Date getCurrentLocalDate() {
        if (this.currentLocalDate == null) {
            Timestamp ts = this.getCurrentTimestamp();
            if (this.getCurrentTenant() != null && this.getCurrentTenant().getTenantConfig(TenantI18nInfo.class).getTimezone() != null) {
                TimeZone systemTz = TimeZone.getDefault();
                TimeZone localTz = this.getTimeZone();
                int offset = localTz.getOffset(ts.getTime()) - systemTz.getOffset(ts.getTime());
                ts.setTime(ts.getTime() + (long)offset);
            }
            this.currentLocalDate = new Date(DateUtils.truncate((java.util.Date)ts, (int)5).getTime());
        }
        return (Date)this.currentLocalDate.clone();
    }

    public Time getCurrentLocalTime() {
        if (this.currentLocalTime == null) {
            Timestamp ts = this.getCurrentTimestamp();
            if (this.getCurrentTenant() != null && this.getCurrentTenant().getTenantConfig(TenantI18nInfo.class).getTimezone() != null) {
                TimeZone systemTz = TimeZone.getDefault();
                TimeZone localTz = this.getTimeZone();
                int offset = localTz.getOffset(ts.getTime()) - systemTz.getOffset(ts.getTime());
                ts.setTime(ts.getTime() + (long)offset);
            }
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(ts.getTime());
            cal.set(1970, 0, 1);
            this.currentLocalTime = new Time(cal.getTimeInMillis());
        }
        return (Time)this.currentLocalTime.clone();
    }

    public void removeAttribute(String key) {
        if (this.contextMap != null) {
            AttributeEntry val = this.contextMap.get(key);
            if (val != null && val.isShare) {
                val.removed = true;
                val.attribute = null;
            } else {
                this.contextMap.remove(key);
            }
        }
    }

    private static class AttributeEntry {
        boolean isShare;
        Object attribute;
        boolean removed = false;

        AttributeEntry(Object attribute, boolean isShare) {
            this.attribute = attribute;
            this.isShare = isShare;
        }
    }
}

