/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.core.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.iplass.mtp.impl.core.config.GroovyScriptObjectBuilder;
import org.iplass.mtp.spi.ObjectBuilder;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameValue {
    private static final Logger logger = LoggerFactory.getLogger(NameValue.class);
    private String name;
    private String value;
    private String textValue;
    private String className;
    private NameValue[] arg;
    private NameValue[] property;
    private boolean isEncrypted;
    private boolean isFinal;
    private boolean isAdditional;
    private boolean isInherit = true;
    private boolean isIfnone;
    private boolean isNull;
    private String ref;
    private String builder;
    private String buildScript;

    public NameValue() {
    }

    public NameValue(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @XmlAttribute
    public boolean isIfnone() {
        return this.isIfnone;
    }

    public void setIfnone(boolean isIfnone) {
        this.isIfnone = isIfnone;
    }

    @XmlAttribute
    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public void setEncrypted(boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
    }

    @XmlAttribute
    public boolean isInherit() {
        return this.isInherit;
    }

    public void setInherit(boolean isInherit) {
        this.isInherit = isInherit;
    }

    @XmlAttribute
    public boolean isAdditional() {
        return this.isAdditional;
    }

    public void setAdditional(boolean isAdditional) {
        this.isAdditional = isAdditional;
    }

    @XmlAttribute
    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    @XmlAttribute
    public boolean isNull() {
        return this.isNull;
    }

    public void setNull(boolean isNull) {
        this.isNull = isNull;
    }

    @XmlAttribute(name="class")
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public NameValue[] getArg() {
        return this.arg;
    }

    public void setArg(NameValue[] arg) {
        this.arg = arg;
    }

    public NameValue[] getProperty() {
        return this.property;
    }

    public void setProperty(NameValue[] property) {
        this.property = property;
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @XmlElement(name="value")
    public String getTextValue() {
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        if (textValue != null) {
            textValue = textValue.trim();
        }
        this.textValue = textValue;
    }

    @XmlAttribute
    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    @XmlAttribute
    public String getBuilder() {
        return this.builder;
    }

    public void setBuilder(String builder) {
        this.builder = builder;
    }

    public String getBuildScript() {
        return this.buildScript;
    }

    public void setBuildScript(String buildScript) {
        this.buildScript = buildScript;
    }

    public String value() {
        if (this.value != null && this.value.length() != 0) {
            return this.value;
        }
        return this.textValue;
    }

    public NameValue merge(NameValue superNameValue) {
        NameValue merged = new NameValue();
        merged.name = this.name;
        merged.isAdditional = this.isAdditional;
        merged.isFinal = this.isFinal;
        merged.isEncrypted = this.isEncrypted;
        merged.isIfnone = this.isIfnone;
        if (this.ref != null) {
            merged.ref = this.ref;
        } else {
            merged.ref = superNameValue.ref;
            merged.className = this.className != null ? this.className : superNameValue.className;
            merged.textValue = this.textValue != null ? this.textValue : superNameValue.textValue;
            merged.value = this.value != null ? this.value : superNameValue.value;
            merged.property = NameValue.mergeNameValueArray(this.name, this.property, superNameValue.property);
            merged.arg = this.arg != null ? this.arg : superNameValue.arg;
            merged.builder = this.builder != null ? this.builder : superNameValue.builder;
            merged.buildScript = this.buildScript != null ? this.buildScript : superNameValue.buildScript;
        }
        return merged;
    }

    public ObjectBuilder<?> builder() {
        if (this.builder != null && this.buildScript != null) {
            throw new ServiceConfigrationException("specify either builder or buildScript on property/bean element. name:" + this.name + ", builder:" + this.builder + ", buildScript:" + this.concat(this.buildScript));
        }
        if (this.builder != null) {
            try {
                return (ObjectBuilder)Class.forName(this.builder).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new ServiceConfigrationException(e);
            }
        }
        if (this.buildScript != null) {
            return new GroovyScriptObjectBuilder(this.buildScript);
        }
        return null;
    }

    private String concat(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() < 256) {
            return str;
        }
        return str.substring(0, 256) + "...";
    }

    static NameValue[] mergeNameValueArray(String targetName, NameValue[] myPropArray, NameValue[] superPropArray) {
        HashSet<String> noInheritPropList = new HashSet<String>();
        HashSet<String> finalPropList = new HashSet<String>();
        HashSet<String> superConfigPropList = new HashSet<String>();
        if (myPropArray != null) {
            for (NameValue p : myPropArray) {
                if (p.isInherit()) continue;
                noInheritPropList.add(p.getName());
            }
            HashMap<String, Object> newProps = new HashMap<String, Object>();
            if (superPropArray != null) {
                for (NameValue p : superPropArray) {
                    superConfigPropList.add(p.getName());
                    if (p.isFinal()) {
                        finalPropList.add(p.getName());
                    }
                    if (noInheritPropList.contains(p.getName()) && !p.isFinal()) continue;
                    Object np = newProps.get(p.getName());
                    if (np == null) {
                        newProps.put(p.getName(), p);
                        continue;
                    }
                    if (np instanceof ArrayList) {
                        ((ArrayList)np).add(p);
                        continue;
                    }
                    ArrayList<NameValue> pArray = new ArrayList<NameValue>();
                    pArray.add((NameValue)np);
                    pArray.add(p);
                    newProps.put(p.getName(), pArray);
                }
            }
            HashSet<String> resetOverridePropList = new HashSet<String>();
            for (NameValue p : myPropArray) {
                ArrayList<NameValue> pArray;
                Object sp = newProps.get(p.getName());
                if (finalPropList.contains(p.getName())) {
                    logger.warn(targetName + "." + p.getName() + " is declared Final, so Can not override configration.");
                    continue;
                }
                if (!superConfigPropList.contains(p.getName()) || noInheritPropList.contains(p.getName())) {
                    if (logger.isTraceEnabled()) {
                        if (noInheritPropList.contains(p.getName())) {
                            logger.trace(targetName + "." + p.getName() + " is not inherit, so hole override parent's configration.");
                        } else {
                            logger.trace(targetName + "." + p.getName() + " is added.");
                        }
                    }
                    if (sp == null) {
                        newProps.put(p.getName(), p);
                        continue;
                    }
                    if (sp instanceof ArrayList) {
                        ((ArrayList)sp).add(p);
                        continue;
                    }
                    pArray = new ArrayList<NameValue>();
                    pArray.add((NameValue)sp);
                    pArray.add(p);
                    newProps.put(p.getName(), pArray);
                    continue;
                }
                if (p.isAdditional()) {
                    if (logger.isTraceEnabled()) {
                        logger.trace(targetName + "." + p.getName() + " is override(additional mode).");
                    }
                    if (sp instanceof ArrayList) {
                        ((ArrayList)sp).add(p);
                        continue;
                    }
                    pArray = new ArrayList();
                    pArray.add((NameValue)sp);
                    pArray.add(p);
                    newProps.put(p.getName(), pArray);
                    continue;
                }
                if (!p.isIfnone() || !superConfigPropList.contains(p.getName())) {
                    if (!resetOverridePropList.contains(p.getName())) {
                        if (logger.isTraceEnabled()) {
                            logger.trace(targetName + "." + p.getName() + " is override.");
                        }
                        resetOverridePropList.add(p.getName());
                        if (sp instanceof ArrayList) {
                            newProps.put(p.getName(), p.merge((NameValue)((ArrayList)sp).get(0)));
                            continue;
                        }
                        newProps.put(p.getName(), p.merge((NameValue)sp));
                        continue;
                    }
                    if (sp instanceof ArrayList) {
                        ((ArrayList)sp).add(p);
                        continue;
                    }
                    pArray = new ArrayList();
                    pArray.add((NameValue)sp);
                    pArray.add(p);
                    newProps.put(p.getName(), pArray);
                    continue;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace(targetName + "." + p.getName() + " is declared ifnone, so Can not override configration.");
            }
            ArrayList<NameValue> list = new ArrayList<NameValue>();
            for (Map.Entry e : newProps.entrySet()) {
                Object v = e.getValue();
                if (v instanceof ArrayList) {
                    for (NameValue vv : (ArrayList)v) {
                        list.add(vv);
                    }
                    continue;
                }
                list.add((NameValue)v);
            }
            return list.toArray(new NameValue[list.size()]);
        }
        return superPropArray;
    }
}

