/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb;

import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.iplass.mtp.impl.datastore.MetaPropertyStore;
import org.iplass.mtp.impl.datastore.PropertyStoreHandler;
import org.iplass.mtp.impl.datastore.grdb.GRdbPropertyStoreRuntime;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.rdb.adapter.BaseRdbTypeAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.spi.ServiceRegistry;

public class MetaGRdbMultiplePropertyStore
extends MetaPropertyStore {
    private static final long serialVersionUID = -1703768839712299060L;
    private List<MetaGRdbPropertyStore> store;

    public MetaGRdbMultiplePropertyStore() {
    }

    public MetaGRdbMultiplePropertyStore(List<MetaGRdbPropertyStore> store) {
        this.store = store;
    }

    public List<MetaGRdbPropertyStore> getStore() {
        return this.store;
    }

    public void setStore(List<MetaGRdbPropertyStore> store) {
        this.store = store;
    }

    public void add(MetaGRdbPropertyStore propStore) {
        if (this.store == null) {
            this.store = new ArrayList<MetaGRdbPropertyStore>();
        }
        this.store.add(propStore);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.store == null ? 0 : this.store.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaGRdbMultiplePropertyStore other = (MetaGRdbMultiplePropertyStore)obj;
        return !(this.store == null ? other.store != null : !this.store.equals(other.store));
    }

    @Override
    public MetaGRdbMultiplePropertyStore copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public GRdbMultiplePropertyStoreHandler createRuntime(PropertyHandler property, MetaEntity metaEntity) {
        return new GRdbMultiplePropertyStoreHandler(property, metaEntity);
    }

    public class GRdbMultiplePropertyStoreHandler
    extends PropertyStoreHandler
    implements GRdbPropertyStoreRuntime {
        private BaseRdbTypeAdapter typeMapping;
        private PrimitivePropertyHandler propertyRuntime;
        private List<MetaGRdbPropertyStore.GRdbPropertyStoreHandler> list;

        private GRdbMultiplePropertyStoreHandler(PropertyHandler propertyRuntime, MetaEntity metaEntity) {
            this.propertyRuntime = (PrimitivePropertyHandler)propertyRuntime;
            RdbAdapter rdb = ServiceRegistry.getRegistry().getService(RdbAdapterService.class).getRdbAdapter();
            PropertyType type = this.propertyRuntime.getMetaData().getType();
            this.typeMapping = rdb.getRdbTypeAdapter(type);
            if (MetaGRdbMultiplePropertyStore.this.store == null) {
                this.list = Collections.emptyList();
            } else {
                this.list = new ArrayList<MetaGRdbPropertyStore.GRdbPropertyStoreHandler>(MetaGRdbMultiplePropertyStore.this.store.size());
                for (int i = 0; i < propertyRuntime.getMetaData().getMultiplicity(); ++i) {
                    this.list.add(new MetaGRdbPropertyStore.GRdbPropertyStoreHandler(propertyRuntime, (MetaGRdbPropertyStore)MetaGRdbMultiplePropertyStore.this.store.get(i), metaEntity));
                }
            }
        }

        @Override
        public BaseRdbTypeAdapter getSingleColumnRdbTypeAdapter() {
            return this.typeMapping;
        }

        @Override
        public int getColCount() {
            return this.list.size();
        }

        @Override
        public boolean isNative() {
            if (MetaGRdbMultiplePropertyStore.this.store == null || MetaGRdbMultiplePropertyStore.this.store.size() == 0) {
                return false;
            }
            return ((MetaGRdbPropertyStore)MetaGRdbMultiplePropertyStore.this.store.get(0)).isNative();
        }

        @Override
        public boolean isExternalIndex() {
            if (MetaGRdbMultiplePropertyStore.this.store == null || MetaGRdbMultiplePropertyStore.this.store.size() == 0) {
                return false;
            }
            return ((MetaGRdbPropertyStore)MetaGRdbMultiplePropertyStore.this.store.get(0)).isExternalIndex();
        }

        @Override
        public PrimitivePropertyHandler getPropertyRuntime() {
            return this.propertyRuntime;
        }

        @Override
        public Object fromDataStore(ResultSet rs, int colNum) throws SQLException {
            ArrayList<Object> vals = new ArrayList<Object>(MetaGRdbMultiplePropertyStore.this.store.size());
            int nullCount = 0;
            for (int i = 0; i < this.propertyRuntime.getMetaData().getMultiplicity(); ++i) {
                Object val = this.getSingleColumnRdbTypeAdapter().fromDataStore(rs, colNum + i);
                if (val == null) {
                    ++nullCount;
                    continue;
                }
                if (nullCount > 0) {
                    for (int j = 0; j < nullCount; ++j) {
                        vals.add(null);
                    }
                    nullCount = 0;
                }
                vals.add(val);
            }
            if (vals.size() > 0) {
                return vals.toArray((Object[])Array.newInstance(this.propertyRuntime.getMetaData().getType().storeType(), vals.size()));
            }
            return null;
        }

        @Override
        public MetaGRdbMultiplePropertyStore getMetaData() {
            return MetaGRdbMultiplePropertyStore.this;
        }

        @Override
        public boolean isMulti() {
            return true;
        }

        @Override
        public List<MetaGRdbPropertyStore.GRdbPropertyStoreHandler> asList() {
            return this.list;
        }
    }
}

