/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.sql;

import java.util.List;
import java.util.TreeSet;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.ColContext;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UpdateSqlHandler;

public class ObjStoreMaintenanceSql
extends UpdateSqlHandler {
    public String insertNewPage(int tenantId, String metaId, int pageNo, String tableNamePostfix, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(MetaGRdbEntityStore.makeObjStoreName(tableNamePostfix));
        sb.append("(");
        sb.append("TENANT_ID").append(",");
        sb.append("OBJ_DEF_ID").append(",");
        sb.append("PG_NO").append(",");
        sb.append("OBJ_ID").append(",");
        sb.append("OBJ_VER");
        sb.append(") SELECT ");
        sb.append(tenantId).append(",");
        sb.append("'").append(rdb.sanitize(metaId)).append("',");
        sb.append(pageNo).append(",");
        sb.append("OBJ_ID").append(",");
        sb.append("OBJ_VER");
        sb.append(" FROM ").append(MetaGRdbEntityStore.makeObjStoreName(tableNamePostfix));
        sb.append(" WHERE ");
        sb.append("TENANT_ID").append("=").append(tenantId);
        sb.append(" AND ");
        sb.append("OBJ_DEF_ID").append("='").append(rdb.sanitize(metaId)).append("'");
        sb.append(" AND ");
        sb.append("PG_NO").append("=0");
        return sb.toString();
    }

    public String insertNewPageRB(int tenantId, String metaId, int pageNo, String tableNamePostfix, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(MetaGRdbEntityStore.makeObjRbTableName(tableNamePostfix));
        sb.append("(");
        sb.append("RB_ID").append(",");
        sb.append("RB_DATE").append(",");
        sb.append("RB_USER").append(",");
        sb.append("TENANT_ID").append(",");
        sb.append("OBJ_DEF_ID").append(",");
        sb.append("PG_NO").append(",");
        sb.append("OBJ_ID").append(",");
        sb.append("OBJ_VER");
        sb.append(") SELECT ");
        sb.append("RB_ID").append(",");
        sb.append("RB_DATE").append(",");
        sb.append("RB_USER").append(",");
        sb.append(tenantId).append(",");
        sb.append("'").append(rdb.sanitize(metaId)).append("',");
        sb.append(pageNo).append(",");
        sb.append("OBJ_ID").append(",");
        sb.append("OBJ_VER");
        sb.append(" FROM ").append(MetaGRdbEntityStore.makeObjRbTableName(tableNamePostfix));
        sb.append(" WHERE ");
        sb.append("TENANT_ID").append("=").append(tenantId);
        sb.append(" AND ");
        sb.append("OBJ_DEF_ID").append("='").append(rdb.sanitize(metaId)).append("'");
        sb.append(" AND ");
        sb.append("PG_NO").append("=0");
        return sb.toString();
    }

    public String deletePage(int tenantId, String id, int fromPageNo, int toPageNo, String tableNamePostfix, RdbAdapter rdb) {
        return this.deletePageInternal(tenantId, id, fromPageNo, toPageNo, MetaGRdbEntityStore.makeObjStoreName(tableNamePostfix), rdb);
    }

    public String deletePageRB(int tenantId, String id, int fromPageNo, int toPageNo, String tableNamePostfix, RdbAdapter rdb) {
        return this.deletePageInternal(tenantId, id, fromPageNo, toPageNo, MetaGRdbEntityStore.makeObjRbTableName(tableNamePostfix), rdb);
    }

    private String deletePageInternal(int tenantId, String id, int fromPageNo, int toPageNo, String tableName, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(tableName);
        sb.append(" WHERE ");
        sb.append("TENANT_ID").append("=").append(tenantId);
        sb.append(" AND ");
        sb.append("OBJ_DEF_ID").append("='").append(rdb.sanitize(id)).append("'");
        sb.append(" AND ");
        sb.append("PG_NO").append(" IN(");
        for (int i = fromPageNo; i <= toPageNo; ++i) {
            if (i != fromPageNo) {
                sb.append(",");
            }
            sb.append(i);
        }
        sb.append(")");
        return sb.toString();
    }

    public String updateCol(int tenantId, String metaId, int defVer, int pageNo, List<ColContext.ColCopy> ccl, String tableNamePostfix, RdbAdapter rdb) {
        return this.updateColInternal(tenantId, metaId, defVer, pageNo, ccl, MetaGRdbEntityStore.makeObjStoreName(tableNamePostfix), rdb);
    }

    private String updateColInternal(int tenantId, String metaId, int defVer, int pageNo, List<ColContext.ColCopy> ccl, String tableName, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        if (rdb.isNeedFromClauseTableAliasUpdateStatement()) {
            sb.append("UPDATE ").append("M");
        } else {
            sb.append("UPDATE ").append(tableName).append(" M");
        }
        sb.append(" SET ");
        boolean addedCol = false;
        if (pageNo == 0) {
            sb.append("OBJ_DEF_VER").append("=").append(defVer);
            addedCol = true;
        }
        if (ccl != null && ccl.size() > 0) {
            for (int i = 0; i < ccl.size(); ++i) {
                if (addedCol) {
                    sb.append(",");
                } else {
                    addedCol = true;
                }
                ColContext.ColCopy cc = ccl.get(i);
                if (cc.isSetToNull()) {
                    if (cc.getIndexType() == null) {
                        sb.append(cc.getToColName()).append("=null");
                        continue;
                    }
                    sb.append(cc.getToColName() + "_TD").append("=null");
                    sb.append(",");
                    sb.append(cc.getToColName()).append("=null");
                    continue;
                }
                if (cc.getFromPageNo() == pageNo) {
                    if (cc.getIndexType() == null) {
                        sb.append(cc.getToColName()).append("=");
                        cc.getConverter().appendConvertExp(sb, cc.getFromColName(), rdb);
                        continue;
                    }
                    sb.append(cc.getToColName() + "_TD").append("=");
                    if (cc.getIndexType() == IndexType.UNIQUE_WITHOUT_NULL || cc.getIndexType() == IndexType.NON_UNIQUE) {
                        sb.append("CASE WHEN ").append(cc.getFromColName()).append(" IS NULL THEN NULL ELSE '");
                        sb.append(MetaGRdbPropertyStore.makeInternalIndexKey(tenantId, rdb.sanitize(metaId), pageNo));
                        sb.append("' END");
                    } else {
                        sb.append("'");
                        sb.append(MetaGRdbPropertyStore.makeInternalIndexKey(tenantId, rdb.sanitize(metaId), pageNo));
                        sb.append("'");
                    }
                    sb.append(",");
                    sb.append(cc.getToColName()).append("=");
                    cc.getConverter().appendConvertExp(sb, cc.getFromColName(), rdb);
                    continue;
                }
                if (cc.getIndexType() == null) {
                    sb.append(cc.getToColName()).append("=");
                    sb.append("(SELECT ");
                    cc.getConverter().appendConvertExp(sb, cc.getFromColName(), rdb);
                    sb.append(" FROM ").append(tableName).append(" S");
                    sb.append(" WHERE ");
                    sb.append("M.").append("TENANT_ID").append("=S.").append("TENANT_ID");
                    sb.append(" AND ");
                    sb.append("M.").append("OBJ_DEF_ID").append("=S.").append("OBJ_DEF_ID");
                    sb.append(" AND ");
                    sb.append("S.").append("PG_NO").append("=").append(cc.getFromPageNo());
                    sb.append(" AND ");
                    sb.append("M.").append("OBJ_ID").append("=S.").append("OBJ_ID");
                    sb.append(" AND ");
                    sb.append("M.").append("OBJ_VER").append("=S.").append("OBJ_VER");
                    sb.append(")");
                    continue;
                }
                sb.append(cc.getToColName() + "_TD").append("=");
                if (cc.getIndexType() == IndexType.UNIQUE_WITHOUT_NULL) {
                    sb.append("CASE WHEN ");
                    sb.append("(SELECT ");
                    cc.getConverter().appendConvertExp(sb, cc.getFromColName(), rdb);
                    sb.append(" FROM ").append(tableName).append(" S");
                    sb.append(" WHERE ");
                    sb.append("M.").append("TENANT_ID").append("=S.").append("TENANT_ID");
                    sb.append(" AND ");
                    sb.append("M.").append("OBJ_DEF_ID").append("=S.").append("OBJ_DEF_ID");
                    sb.append(" AND ");
                    sb.append("S.").append("PG_NO").append("=").append(cc.getFromPageNo());
                    sb.append(" AND ");
                    sb.append("M.").append("OBJ_ID").append("=S.").append("OBJ_ID");
                    sb.append(" AND ");
                    sb.append("M.").append("OBJ_VER").append("=S.").append("OBJ_VER");
                    sb.append(")");
                    sb.append(" IS NULL THEN NULL ELSE '");
                    sb.append(MetaGRdbPropertyStore.makeInternalIndexKey(tenantId, rdb.sanitize(metaId), pageNo));
                    sb.append("' END");
                } else {
                    sb.append("'");
                    sb.append(MetaGRdbPropertyStore.makeInternalIndexKey(tenantId, rdb.sanitize(metaId), pageNo));
                    sb.append("'");
                }
                sb.append(",");
                sb.append(cc.getToColName()).append("=");
                sb.append("(SELECT ");
                sb.append(cc.getFromColName());
                sb.append(" FROM ").append(tableName).append(" S");
                sb.append(" WHERE ");
                sb.append("M.").append("TENANT_ID").append("=S.").append("TENANT_ID");
                sb.append(" AND ");
                sb.append("M.").append("OBJ_DEF_ID").append("=S.").append("OBJ_DEF_ID");
                sb.append(" AND ");
                sb.append("S.").append("PG_NO").append("=").append(cc.getFromPageNo());
                sb.append(" AND ");
                sb.append("M.").append("OBJ_ID").append("=S.").append("OBJ_ID");
                sb.append(" AND ");
                sb.append("M.").append("OBJ_VER").append("=S.").append("OBJ_VER");
                sb.append(")");
            }
        }
        if (rdb.isNeedFromClauseTableAliasUpdateStatement()) {
            sb.append(" FROM ").append(tableName).append(" M");
        }
        sb.append(" WHERE ").append("TENANT_ID").append("=").append(tenantId);
        sb.append(" AND ").append("OBJ_DEF_ID").append("='").append(rdb.sanitize(metaId)).append("'");
        sb.append(" AND ").append("PG_NO").append("=").append(pageNo);
        return sb.toString();
    }

    public String updateColRB(int tenantId, String metaId, int defVer, int pageNo, List<ColContext.ColCopy> ccl, String tableNamePostfix, RdbAdapter rdb) {
        return this.updateColInternal(tenantId, metaId, defVer, pageNo, ccl, MetaGRdbEntityStore.makeObjRbTableName(tableNamePostfix), rdb);
    }

    public String updateColDirectJoin(int tenantId, String metaId, int defVer, List<ColContext.ColCopy>[] ccl, String tableNamePostfix, RdbAdapter rdb) {
        return this.updateColDirectJoinInternal(tenantId, metaId, defVer, ccl, MetaGRdbEntityStore.makeObjStoreName(tableNamePostfix), rdb);
    }

    public String updateColDirectJoinRB(int tenantId, String metaId, int defVer, List<ColContext.ColCopy>[] ccl, String tableNamePostfix, RdbAdapter rdb) {
        return this.updateColDirectJoinInternal(tenantId, metaId, defVer, ccl, MetaGRdbEntityStore.makeObjRbTableName(tableNamePostfix), rdb);
    }

    private String updateColDirectJoinInternal(int tenantId, String metaId, int defVer, List<ColContext.ColCopy>[] ccls, String tableName, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        if (rdb.isNeedFromClauseTableAliasUpdateStatement()) {
            sb.append("UPDATE ").append("p0");
        } else {
            sb.append("UPDATE ").append(tableName).append(" p0");
        }
        this.multitableJoinClause(sb, tenantId, metaId, defVer, ccls, tableName, rdb);
        this.multitableUpdateSetClause(sb, tenantId, metaId, defVer, ccls, rdb);
        if (rdb.isNeedFromClauseTableAliasUpdateStatement()) {
            sb.append(" FROM ").append(tableName).append(" p0");
        }
        sb.append(" WHERE p0.").append("TENANT_ID").append("=").append(tenantId);
        sb.append(" AND p0.").append("OBJ_DEF_ID").append("='").append(rdb.sanitize(metaId)).append("'");
        sb.append(" AND p0.").append("PG_NO").append("=0");
        return sb.toString();
    }

    private void multitableJoinClause(StringBuilder sb, int tenantId, String metaId, int defVer, List<ColContext.ColCopy>[] ccls, String tableName, RdbAdapter rdb) {
        TreeSet<Integer> joinPages = new TreeSet<Integer>();
        for (int i = 0; i < ccls.length; ++i) {
            if (ccls[i] == null) continue;
            for (ColContext.ColCopy cc : ccls[i]) {
                if (!cc.isSetToNull() && cc.getFromPageNo() != 0) {
                    joinPages.add(cc.getFromPageNo());
                }
                if (cc.getToPageNo() == 0) continue;
                joinPages.add(cc.getToPageNo());
            }
        }
        for (Integer i : joinPages) {
            sb.append(" INNER JOIN ").append(tableName).append(" p").append(i);
            sb.append(" ON p0.").append("TENANT_ID").append("=p").append(i).append(".").append("TENANT_ID");
            sb.append(" AND p0.").append("OBJ_DEF_ID").append("=p").append(i).append(".").append("OBJ_DEF_ID");
            sb.append(" AND p0.").append("OBJ_ID").append("=p").append(i).append(".").append("OBJ_ID");
            sb.append(" AND p0.").append("OBJ_VER").append("=p").append(i).append(".").append("OBJ_VER");
            sb.append(" AND p").append(i).append(".").append("PG_NO").append("=").append(i);
        }
    }

    private void multitableUpdateSetClause(StringBuilder sb, int tenantId, String metaId, int defVer, List<ColContext.ColCopy>[] ccls, RdbAdapter rdb) {
        sb.append(" SET ");
        sb.append("p0.").append("OBJ_DEF_VER").append("=").append(defVer);
        for (int i = 0; i < ccls.length; ++i) {
            if (ccls[i] == null) continue;
            for (ColContext.ColCopy cc : ccls[i]) {
                sb.append(",");
                if (cc.isSetToNull()) {
                    if (cc.getIndexType() == null) {
                        sb.append("p").append(cc.getToPageNo()).append(".").append(cc.getToColName()).append("=null");
                        continue;
                    }
                    sb.append("p").append(cc.getToPageNo()).append(".").append(cc.getToColName() + "_TD").append("=null");
                    sb.append(",");
                    sb.append("p").append(cc.getToPageNo()).append(".").append(cc.getToColName()).append("=null");
                    continue;
                }
                if (cc.getIndexType() == null) {
                    sb.append("p").append(cc.getToPageNo()).append(".").append(cc.getToColName()).append("=");
                    cc.getConverter().appendConvertExp(sb, "p" + cc.getFromPageNo() + "." + cc.getFromColName(), rdb);
                    continue;
                }
                sb.append("p").append(cc.getToPageNo()).append(".").append(cc.getToColName() + "_TD").append("=");
                if (cc.getIndexType() == IndexType.UNIQUE_WITHOUT_NULL || cc.getIndexType() == IndexType.NON_UNIQUE) {
                    sb.append("CASE WHEN ").append("p").append(cc.getFromPageNo()).append(".").append(cc.getFromColName()).append(" IS NULL THEN NULL ELSE '");
                    sb.append(MetaGRdbPropertyStore.makeInternalIndexKey(tenantId, rdb.sanitize(metaId), cc.getToPageNo()));
                    sb.append("' END");
                } else {
                    sb.append("'");
                    sb.append(MetaGRdbPropertyStore.makeInternalIndexKey(tenantId, rdb.sanitize(metaId), cc.getToPageNo()));
                    sb.append("'");
                }
                sb.append(",");
                sb.append("p").append(cc.getToPageNo()).append(".").append(cc.getToColName()).append("=");
                cc.getConverter().appendConvertExp(sb, "p" + cc.getFromPageNo() + "." + cc.getFromColName(), rdb);
            }
        }
    }
}

