/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate;

import java.sql.Connection;
import java.sql.SQLException;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.bulkupdate.BulkUpdatable;
import org.iplass.mtp.entity.bulkupdate.BulkUpdateEntity;
import org.iplass.mtp.impl.datastore.grdb.strategy.GRdbEntityStoreStrategy;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.BulkUpdateState;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.BulkUpdateStrategy;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;

public class BulkContextBaseBulkUpdateStrategy
implements BulkUpdateStrategy {
    private GRdbEntityStoreStrategy storeStrategy;
    private RdbAdapter rdb;

    public BulkContextBaseBulkUpdateStrategy(GRdbEntityStoreStrategy storeStrategy, RdbAdapter rdb) {
        this.storeStrategy = storeStrategy;
        this.rdb = rdb;
    }

    @Override
    public void bulkUpdate(BulkUpdatable bulkUpdatable, EntityContext entityContext, EntityHandler entityHandler, String clientId) {
        int tenantId = entityContext.getLocalTenantId();
        int buffSize = this.rdb.getBatchSize();
        try (Connection con = this.rdb.getConnection();
             BulkUpdateState updateState = new BulkUpdateState(this.storeStrategy, tenantId, clientId, entityContext, entityHandler, bulkUpdatable, con, this.rdb, buffSize);){
            int count = 0;
            for (BulkUpdateEntity target : bulkUpdatable) {
                if (target.getEntity().getVersion() == null) {
                    target.getEntity().setVersion(0L);
                }
                if (target.getEntity().getState() == null) {
                    target.getEntity().setValue("state", "V");
                }
                updateState.addToBuffer(target);
                if (++count < buffSize) continue;
                updateState.doUpdate();
                count = 0;
            }
            if (count > 0) {
                updateState.doUpdate();
            }
            updateState.flushAll();
        }
        catch (SQLException e) {
            throw new EntityRuntimeException(e);
        }
    }
}

