/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.impl.datastore.grdb.GRdbPropertyStoreRuntime;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.BulkUpdateState;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.IndexTableKey;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.mapper.ColumnValueMapper;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.sql.IndexBulkDeleteSql;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.sql.IndexBulkInsertSql;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.sql.ObjStoreBulkUpdateSql;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.sql.ReferenceBulkDeleteSql;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.sql.ReferenceBulkInsertSql;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkDeleteContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkInsertContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkUpdateContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.ColumnValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BulkUpdateHandler {
    private static Logger logger = LoggerFactory.getLogger(BulkUpdateHandler.class);
    BulkUpdateContext[] objStoreUpdate;
    ObjStoreBulkUpdateSql.ObjStoreBulkUpdateSqlResult[] objStoreUpdateMapper;
    int[] colSize;
    BulkDeleteContext objRefDeleteByOidPropId;
    BulkInsertContext objRefInsert;
    List<ReferencePropertyHandler> refs;
    Map<IndexTableKey, IndexUpdateContext> objIndexUpdate;
    List<PrimitivePropertyHandler> indexes;

    BulkUpdateHandler(BulkUpdateState state) throws SQLException {
        GRdbPropertyStoreRuntime colDef;
        MetaGRdbEntityStore.GRdbEntityStoreRuntime store = (MetaGRdbEntityStore.GRdbEntityStoreRuntime)state.eh.getEntityStoreRuntime();
        String tableName = store.OBJ_STORE();
        this.objStoreUpdateMapper = new ObjStoreBulkUpdateSql.ObjStoreBulkUpdateSqlResult[store.getCurrentMaxPage() + 1];
        this.objStoreUpdate = new BulkUpdateContext[this.objStoreUpdateMapper.length];
        this.colSize = new int[this.objStoreUpdateMapper.length];
        for (int i = 0; i <= store.getCurrentMaxPage(); ++i) {
            this.objStoreUpdateMapper[i] = i == 0 ? ObjStoreBulkUpdateSql.updateMain(state.tenantId, state.eh, state.bulkUpdatable.getUpdateProperties(), state.rdb, state.entityContext) : ObjStoreBulkUpdateSql.updateSub(state.tenantId, state.eh, i, state.bulkUpdatable.getUpdateProperties(), state.rdb, state.entityContext);
            if (this.objStoreUpdateMapper[i] == null) continue;
            BulkUpdateContext ret = state.rdb.createBulkUpdateContext();
            ArrayList<ColumnValue> keyCv = new ArrayList<ColumnValue>();
            for (ColumnValueMapper columnValueMapper : this.objStoreUpdateMapper[i].keys) {
                columnValueMapper.columns(keyCv, state.rdb);
            }
            ArrayList<ColumnValue> valueCv = new ArrayList<ColumnValue>();
            for (ColumnValueMapper m3 : this.objStoreUpdateMapper[i].values) {
                m3.columns(valueCv, state.rdb);
            }
            ret.setContext(tableName, keyCv, valueCv, this.objStoreUpdateMapper[i].additionalConditionExpression, state.con);
            this.objStoreUpdate[i] = ret;
            this.colSize[i] = valueCv.size();
        }
        this.refs = state.eh.getReferencePropertyList(true, state.entityContext);
        if (state.bulkUpdatable.getUpdateProperties() != null) {
            ArrayList<ReferencePropertyHandler> filtered = new ArrayList<ReferencePropertyHandler>();
            for (ReferencePropertyHandler rph : this.refs) {
                if (!state.bulkUpdatable.getUpdateProperties().contains(rph.getName())) continue;
                filtered.add(rph);
            }
            this.refs = filtered;
        }
        if (this.refs.size() > 0) {
            this.objRefDeleteByOidPropId = ReferenceBulkDeleteSql.deleteByOidVersionRefId(state.eh, state.con, state.rdb);
            this.objRefInsert = ReferenceBulkInsertSql.insert(state.eh, state.con, state.rdb);
        }
        this.indexes = new ArrayList<PrimitivePropertyHandler>();
        for (PrimitivePropertyHandler pph : state.eh.getIndexedPropertyList(state.entityContext)) {
            if (state.bulkUpdatable.getUpdateProperties() != null && !state.bulkUpdatable.getUpdateProperties().contains(pph.getName()) || !(colDef = (GRdbPropertyStoreRuntime)((Object)pph.getStoreSpecProperty())).isExternalIndex()) continue;
            boolean needAdd = true;
            if (state.eh.isVersioned() && (pph.getMetaData().getIndexType() == IndexType.UNIQUE || pph.getMetaData().getIndexType() == IndexType.UNIQUE_WITHOUT_NULL)) {
                needAdd = false;
            }
            if (!needAdd) continue;
            this.indexes.add(pph);
        }
        for (PrimitivePropertyHandler pph : this.indexes) {
            IndexTableKey ikey;
            IndexUpdateContext indexUpdateContext;
            colDef = (GRdbPropertyStoreRuntime)((Object)pph.getStoreSpecProperty());
            if (this.objIndexUpdate == null) {
                this.objIndexUpdate = new HashMap<IndexTableKey, IndexUpdateContext>();
            }
            if ((indexUpdateContext = this.objIndexUpdate.get(ikey = new IndexTableKey(pph.getMetaData().getIndexType(), colDef.getSingleColumnRdbTypeAdapter().getColOfIndex()))) != null) continue;
            MetaGRdbPropertyStore.GRdbPropertyStoreHandler col = colDef.asList().get(0);
            IndexUpdateContext indexUpdateContext2 = new IndexUpdateContext();
            indexUpdateContext2.objIndexDeleteByOidAndVersion = IndexBulkDeleteSql.deleteByOidVersionColName(col, state.con, state.rdb);
            indexUpdateContext2.objIndexInsert = IndexBulkInsertSql.insert(col, state.con, state.rdb);
            this.objIndexUpdate.put(ikey, indexUpdateContext2);
        }
    }

    public void flushAll() throws SQLException {
        for (BulkUpdateContext buc : this.objStoreUpdate) {
            if (buc == null || buc.getCurrentSize() <= 0) continue;
            buc.execute();
        }
        if (this.objRefDeleteByOidPropId != null && this.objRefDeleteByOidPropId.getCurrentSize() > 0) {
            this.objRefDeleteByOidPropId.execute();
        }
        if (this.objRefInsert != null && this.objRefInsert.getCurrentSize() > 0) {
            this.objRefInsert.execute();
        }
        if (this.objIndexUpdate != null) {
            for (Map.Entry entry : this.objIndexUpdate.entrySet()) {
                if (((IndexUpdateContext)entry.getValue()).objIndexDeleteByOidAndVersion.getCurrentSize() > 0) {
                    ((IndexUpdateContext)entry.getValue()).objIndexDeleteByOidAndVersion.execute();
                }
                if (((IndexUpdateContext)entry.getValue()).objIndexInsert.getCurrentSize() <= 0) continue;
                ((IndexUpdateContext)entry.getValue()).objIndexInsert.execute();
            }
        }
    }

    public void close() {
        for (BulkUpdateContext buc : this.objStoreUpdate) {
            try {
                if (buc == null) continue;
                buc.close();
            }
            catch (SQLException e) {
                logger.error("fail to BulkUpdateHandler close. maybe resource leak.", (Throwable)e);
            }
        }
        if (this.objRefDeleteByOidPropId != null) {
            try {
                this.objRefDeleteByOidPropId.close();
            }
            catch (SQLException e) {
                logger.error("fail to BulkUpdateHandler close. maybe resource leak.", (Throwable)e);
            }
        }
        if (this.objRefInsert != null) {
            try {
                this.objRefInsert.close();
            }
            catch (SQLException e) {
                logger.error("fail to BulkUpdateHandler close. maybe resource leak.", (Throwable)e);
            }
        }
        if (this.objIndexUpdate != null) {
            for (Map.Entry entry : this.objIndexUpdate.entrySet()) {
                try {
                    ((IndexUpdateContext)entry.getValue()).objIndexDeleteByOidAndVersion.close();
                }
                catch (SQLException e) {
                    logger.error("fail to BulkUpdateHandler close. maybe resource leak.", (Throwable)e);
                }
                try {
                    ((IndexUpdateContext)entry.getValue()).objIndexInsert.close();
                }
                catch (SQLException e) {
                    logger.error("fail to BulkUpdateHandler close. maybe resource leak.", (Throwable)e);
                }
            }
        }
    }

    public void addValue(BulkUpdateState state, Entity entity) throws SQLException {
        for (int i = 0; i < this.objStoreUpdate.length; ++i) {
            if (this.objStoreUpdate[i] == null) continue;
            ArrayList<Object> key = new ArrayList<Object>(5);
            for (ColumnValueMapper columnValueMapper : this.objStoreUpdateMapper[i].keys) {
                columnValueMapper.values(key, entity, state.rdb);
            }
            ArrayList<Object> values = new ArrayList<Object>(this.colSize[i]);
            for (ColumnValueMapper cm3 : this.objStoreUpdateMapper[i].values) {
                cm3.values(values, entity, state.rdb);
            }
            this.objStoreUpdate[i].add(key, values);
            if (this.objStoreUpdate[i].getCurrentSize() < state.rdb.getBatchSize()) continue;
            this.objStoreUpdate[i].execute();
        }
        String oid = entity.getOid();
        Long ver = entity.getVersion();
        if (this.objRefInsert != null) {
            for (ReferencePropertyHandler referencePropertyHandler : this.refs) {
                Object val;
                String targetObjDefId = referencePropertyHandler.getReferenceEntityHandler(state.entityContext).getMetaData().getId();
                ReferenceBulkDeleteSql.addValueForDeleteByOidVersionRefId(this.objRefDeleteByOidPropId, state.tenantId, state.eh, referencePropertyHandler.getId(), oid, ver);
                if (this.objRefDeleteByOidPropId.getCurrentSize() >= state.rdb.getBatchSize()) {
                    this.objRefDeleteByOidPropId.execute();
                }
                if ((val = entity.getValue(referencePropertyHandler.getName())) == null) continue;
                if (val instanceof Entity[]) {
                    for (Entity target : (Entity[])val) {
                        ReferenceBulkInsertSql.addValueForInsert(this.objRefInsert, state.tenantId, state.eh, referencePropertyHandler.getId(), oid, ver, targetObjDefId, target.getOid(), target.getVersion());
                        if (this.objRefInsert.getCurrentSize() < state.rdb.getBatchSize()) continue;
                        if (this.objRefDeleteByOidPropId.getCurrentSize() > 0) {
                            this.objRefDeleteByOidPropId.execute();
                        }
                        this.objRefInsert.execute();
                    }
                    continue;
                }
                Entity target = (Entity)val;
                ReferenceBulkInsertSql.addValueForInsert(this.objRefInsert, state.tenantId, state.eh, referencePropertyHandler.getId(), oid, ver, targetObjDefId, target.getOid(), target.getVersion());
                if (this.objRefInsert.getCurrentSize() < state.rdb.getBatchSize()) continue;
                if (this.objRefDeleteByOidPropId.getCurrentSize() > 0) {
                    this.objRefDeleteByOidPropId.execute();
                }
                this.objRefInsert.execute();
            }
        }
        if (this.objIndexUpdate != null) {
            for (PrimitivePropertyHandler primitivePropertyHandler : this.indexes) {
                MetaGRdbPropertyStore.GRdbPropertyStoreHandler colDef = ((GRdbPropertyStoreRuntime)((Object)primitivePropertyHandler.getStoreSpecProperty())).asList().get(0);
                IndexTableKey ikey = new IndexTableKey(primitivePropertyHandler.getMetaData().getIndexType(), colDef.getSingleColumnRdbTypeAdapter().getColOfIndex());
                IndexUpdateContext iuc = this.objIndexUpdate.get(ikey);
                IndexBulkDeleteSql.addValueForDeleteByOidVersionColName(iuc.objIndexDeleteByOidAndVersion, state.tenantId, colDef, oid, ver);
                if (iuc.objIndexDeleteByOidAndVersion.getCurrentSize() >= state.rdb.getBatchSize()) {
                    iuc.objIndexDeleteByOidAndVersion.execute();
                }
                Object val = entity.getValue(primitivePropertyHandler.getName());
                boolean needAdd = true;
                if (ikey.indexType == IndexType.UNIQUE_WITHOUT_NULL && val == null) {
                    needAdd = false;
                }
                if (needAdd) {
                    IndexBulkInsertSql.addValueForInsert(iuc.objIndexInsert, state.tenantId, colDef, oid, ver, val);
                }
                if (iuc.objIndexInsert.getCurrentSize() < state.rdb.getBatchSize()) continue;
                if (iuc.objIndexDeleteByOidAndVersion.getCurrentSize() > 0) {
                    iuc.objIndexDeleteByOidAndVersion.execute();
                }
                iuc.objIndexInsert.execute();
            }
        }
    }

    static class IndexUpdateContext {
        BulkDeleteContext objIndexDeleteByOidAndVersion;
        BulkInsertContext objIndexInsert;

        IndexUpdateContext() {
        }
    }
}

