/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy.metadata.diff;

import java.sql.SQLException;
import java.sql.Statement;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.ColResolver;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.diff.Diff;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.diff.UpdPropertyIndexType;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaPrimitiveProperty;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;

public class UpdProperty
extends Diff {
    private UpdPropertyIndexType updPropertyIndexType;
    private MetaPrimitiveProperty previousProperty;
    private MetaPrimitiveProperty nextProperty;
    private ColResolver colResolver;
    private MetaEntity nextEntity;

    public UpdProperty(MetaPrimitiveProperty previousProperty, MetaPrimitiveProperty nextProperty, MetaEntity nextEntity, ColResolver colResolver) {
        this.previousProperty = previousProperty;
        this.nextProperty = nextProperty;
        this.colResolver = colResolver;
        this.nextEntity = nextEntity;
        if (previousProperty.getIndexType() != null && previousProperty.getIndexType() != IndexType.NON_INDEXED || nextProperty.getIndexType() != null && nextProperty.getIndexType() != IndexType.NON_INDEXED) {
            this.updPropertyIndexType = new UpdPropertyIndexType(previousProperty, nextProperty, nextEntity);
        }
    }

    @Override
    public void applyToData(Statement stmt, RdbAdapter rdb, int tenantId) throws SQLException {
        if (this.updPropertyIndexType != null) {
            this.updPropertyIndexType.applyToData(stmt, rdb, tenantId);
        }
    }

    @Override
    public void modifyMetaData() {
        if (this.nextProperty.getMultiplicity() > 1) {
            this.nextProperty.setIndexType(IndexType.NON_INDEXED);
        }
        this.colResolver.allocateCol(this.nextProperty, this.previousProperty, this.nextEntity.getVersionControlType());
        if (this.updPropertyIndexType != null) {
            this.updPropertyIndexType.modifyMetaData();
        }
    }

    @Override
    public boolean needDataModify() {
        return this.updPropertyIndexType != null && this.updPropertyIndexType.needDataModify();
    }
}

