/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.definition.DefinitionManager;
import org.iplass.mtp.definition.DefinitionSummary;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.EntityDefinitionModifyResult;
import org.iplass.mtp.impl.datastore.StoreService;
import org.iplass.mtp.impl.definition.DefinitionService;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.EntityService;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.metadata.MetaDataDuplicatePathException;
import org.iplass.mtp.impl.metadata.MetaDataEntryInfo;
import org.iplass.mtp.impl.properties.extend.AutoNumberType;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityDefinitionManagerImpl
implements EntityDefinitionManager {
    private static final Logger logger = LoggerFactory.getLogger(EntityDefinitionManagerImpl.class);
    private EntityService dmHandlerService = ServiceRegistry.getRegistry().getService(EntityService.class);
    private DefinitionService dm = DefinitionService.getInstance();

    @Override
    public EntityDefinitionModifyResult create(EntityDefinition definition) {
        EntityDefinition checked = this.checkAndModify(definition);
        final Future<String> result = this.dmHandlerService.createDataModelSchema(checked);
        return new EntityDefinitionModifyResult(){
            private static final long serialVersionUID = 7145015583970134749L;

            @Override
            public boolean isSuccess() {
                String id = null;
                try {
                    id = (String)result.get();
                }
                catch (ExecutionException e) {
                    this.message = "exception occured during entity definition create:" + e.getCause().getMessage();
                    logger.error(this.message, e.getCause());
                    if (e.getCause() instanceof MetaDataDuplicatePathException) {
                        this.message = EntityDefinitionManagerImpl.resourceString("impl.metadata.duplicatePath", new Object[0]);
                    }
                    return false;
                }
                catch (InterruptedException e) {
                    this.message = "execution interrrupted during entity definition create:" + e.getMessage();
                    logger.error(this.message, (Throwable)e);
                    return false;
                }
                if (id == null) {
                    return false;
                }
                EntityContext.getCurrentContext().refreshTransactionLocalCache(id);
                return true;
            }
        };
    }

    private EntityDefinition checkAndModify(EntityDefinition definition) {
        return definition;
    }

    @Override
    public List<String> definitionList() {
        return this.dmHandlerService.nameList();
    }

    @Override
    public List<DefinitionSummary> definitionNameList() {
        return this.definitionNameList("");
    }

    @Override
    public List<DefinitionSummary> definitionNameList(String filterPath) {
        List<MetaDataEntryInfo> entryInfoList = this.dmHandlerService.list(filterPath);
        ArrayList<DefinitionSummary> ret = new ArrayList<DefinitionSummary>(entryInfoList.size());
        for (MetaDataEntryInfo definition : entryInfoList) {
            DefinitionSummary def = new DefinitionSummary(definition.getPath(), this.dm.getDefinitionName(EntityDefinition.class, definition.getPath()), definition.getDisplayName(), definition.getDescription());
            ret.add(def);
        }
        return ret;
    }

    @Override
    public EntityDefinition get(String definitionName) {
        EntityContext ctx = EntityContext.getCurrentContext();
        EntityHandler eh = ctx.getHandlerByName(definitionName);
        if (eh == null) {
            return null;
        }
        return eh.getMetaData().currentConfig(ctx);
    }

    @Override
    public EntityDefinitionModifyResult remove(String definitionName) {
        EntityDefinition definition = this.get(definitionName);
        if (definition == null) {
            throw new EntityRuntimeException(definitionName + " not found.");
        }
        EntityDefinition checked = this.checkAndModify(definition);
        final Future<String> result = this.dmHandlerService.removeDataModelSchema(checked);
        return new EntityDefinitionModifyResult(){
            private static final long serialVersionUID = 7145015583970134749L;

            @Override
            public boolean isSuccess() {
                String id = null;
                try {
                    id = (String)result.get();
                }
                catch (ExecutionException e) {
                    this.message = "exception occured during entity definition remove:" + e.getCause().getMessage();
                    logger.error(this.message, e.getCause());
                    return false;
                }
                catch (InterruptedException e) {
                    this.message = "execution interrrupted during entity definition remove:" + e.getMessage();
                    logger.error(this.message, (Throwable)e);
                    return false;
                }
                if (id == null) {
                    return false;
                }
                EntityContext.getCurrentContext().refreshTransactionLocalCache(id);
                return true;
            }
        };
    }

    @Override
    public EntityDefinitionModifyResult update(EntityDefinition definition) {
        return this.update(definition, null);
    }

    @Override
    public EntityDefinitionModifyResult update(EntityDefinition definition, Map<String, String> renamePropertyMap) {
        if (this.get(definition.getName()) == null) {
            throw new EntityRuntimeException(definition.getName() + " not found.");
        }
        EntityDefinition checked = this.checkAndModify(definition);
        final Future<String> result = this.dmHandlerService.updateDataModelSchema(checked, renamePropertyMap);
        return new EntityDefinitionModifyResult(){
            private static final long serialVersionUID = 7145015583970134749L;

            @Override
            public boolean isSuccess() {
                String id = null;
                try {
                    id = (String)result.get();
                }
                catch (ExecutionException e) {
                    this.message = "exception occured during entity definition update:" + e.getCause().getMessage();
                    logger.error(this.message, e.getCause());
                    return false;
                }
                catch (InterruptedException e) {
                    this.message = "execution interrrupted during entity definition update:" + e.getMessage();
                    logger.error(this.message, (Throwable)e);
                    return false;
                }
                if (id == null) {
                    return false;
                }
                EntityContext.getCurrentContext().refreshTransactionLocalCache(id);
                return true;
            }
        };
    }

    @Override
    public void renameEntityDefinition(String from, String to) {
        ManagerLocator.getInstance().getManager(DefinitionManager.class).rename(EntityDefinition.class, from, to);
    }

    @Override
    public void renamePropertyDefinition(String defName, String from, String to) {
        this.dmHandlerService.renameProperty(defName, from, to);
    }

    @Override
    public long getAutoNumberCurrentValue(String definitionName, String propertyName) {
        return this.getAutoNumberCurrentValue(definitionName, propertyName, null);
    }

    @Override
    public long getAutoNumberCurrentValue(String definitionName, String propertyName, String subUnitKey) {
        AutoNumberType.AutoNumberTypeRuntime typeRuntime = this.getAutoNumberRuntime(definitionName, propertyName);
        return typeRuntime.currentValue(subUnitKey);
    }

    @Override
    public List<Pair<String, Long>> getAutoNumberCurrentValueList(String definitionName, String propertyName) {
        AutoNumberType.AutoNumberTypeRuntime typeRuntime = this.getAutoNumberRuntime(definitionName, propertyName);
        return typeRuntime.keySet().stream().map(key -> {
            long value = typeRuntime.currentValue((String)key);
            return new ImmutablePair(key, (Object)value);
        }).collect(Collectors.toList());
    }

    @Override
    public void resetAutoNumberCounter(String definitionName, String propertyName, long startsWith) {
        this.resetAutoNumberCounter(definitionName, propertyName, null, startsWith);
    }

    @Override
    public void resetAutoNumberCounter(String definitionName, String propertyName, String subUnitKey, long startsWith) {
        AutoNumberType.AutoNumberTypeRuntime typeRuntime = this.getAutoNumberRuntime(definitionName, propertyName);
        typeRuntime.resetCounter(subUnitKey, startsWith);
    }

    private AutoNumberType.AutoNumberTypeRuntime getAutoNumberRuntime(String definitionName, String propertyName) {
        EntityContext eContext = EntityContext.getCurrentContext();
        EntityHandler eh = eContext.getHandlerByName(definitionName);
        PropertyHandler ph = eh.getProperty(propertyName, eContext);
        if (!(ph instanceof PrimitivePropertyHandler)) {
            throw new EntityRuntimeException(definitionName + "." + propertyName + " is not AutoNumberProperty");
        }
        if (!(((PrimitivePropertyHandler)ph).getMetaData().getType() instanceof AutoNumberType)) {
            throw new EntityRuntimeException(definitionName + "." + propertyName + " is not AutoNumberProperty");
        }
        return (AutoNumberType.AutoNumberTypeRuntime)((PrimitivePropertyHandler)ph).getTypeSpecificRuntime();
    }

    @Override
    public List<String> getStorageSpaceList() {
        StoreService storeService = ServiceRegistry.getRegistry().getService(StoreService.class);
        return storeService.getStorageSpaceList();
    }

    @Override
    public boolean isLockedSchema(String definitionName) {
        return this.dmHandlerService.isLockedSchema(definitionName);
    }

    @Override
    public void rename(String oldDefinitionName, String newDefinitionName) {
        this.renameEntityDefinition(oldDefinitionName, newDefinitionName);
    }

    @Override
    public Class<EntityDefinition> getDefinitionType() {
        return EntityDefinition.class;
    }

    @Override
    public List<DefinitionSummary> definitionSummaryList(String filterPath, boolean recursive) {
        DefinitionManager manager = ManagerLocator.getInstance().getManager(DefinitionManager.class);
        return manager.listName(this.getDefinitionType(), filterPath, recursive);
    }

    private static String resourceString(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }
}

