/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity;

import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.definition.TypedDefinitionManager;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.VersionControlType;
import org.iplass.mtp.entity.interceptor.EntityInterceptor;
import org.iplass.mtp.impl.async.AsyncTaskService;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.datastore.DataStore;
import org.iplass.mtp.impl.datastore.StoreService;
import org.iplass.mtp.impl.datastore.strategy.ApplyMetaDataStrategy;
import org.iplass.mtp.impl.datastore.strategy.EntityStoreStrategy;
import org.iplass.mtp.impl.definition.AbstractTypedMetaDataService;
import org.iplass.mtp.impl.definition.DefinitionMetaDataTypeMap;
import org.iplass.mtp.impl.entity.AdditionalStoreMaintainer;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.ExtendPropertyAdapterFactory;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.MetaStoreMapping;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.entity.versioning.NonVersionController;
import org.iplass.mtp.impl.entity.versioning.NumberbaseVersionController;
import org.iplass.mtp.impl.entity.versioning.TimebaseVersionController;
import org.iplass.mtp.impl.entity.versioning.VersionController;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.metadata.MetaDataEntryInfo;
import org.iplass.mtp.impl.metadata.MetaDataRepository;
import org.iplass.mtp.impl.metadata.MetaDataRuntimeException;
import org.iplass.mtp.impl.util.KeyGenerator;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityService
extends AbstractTypedMetaDataService<MetaEntity, EntityHandler>
implements Service {
    public static final String ENTITY_META_PATH = "/entity/";
    public static final String ENTITY_NAME = "Entity";
    private static final Logger logger = LoggerFactory.getLogger(EntityService.class);
    private AsyncTaskService asyncTaskService;
    private StoreService storeService;
    private List<AdditionalStoreMaintainer> additionalStoreMaintainer;
    private EntityInterceptor[] interceptors;
    private int limitOfReferences = 1000;
    private int purgeTargetDate;
    private final EnumMap<VersionControlType, VersionController> versionControllers = new EnumMap(VersionControlType.class);
    private ExtendPropertyAdapterFactory extendPropertyAdapterFactory;

    public EntityService() {
        this.versionControllers.put(VersionControlType.NONE, new NonVersionController());
        this.versionControllers.put(VersionControlType.VERSIONED, new NumberbaseVersionController());
        this.versionControllers.put(VersionControlType.TIMEBASE, new TimebaseVersionController());
    }

    public static String getFixedPath() {
        return ENTITY_META_PATH;
    }

    public int getLimitOfReferences() {
        return this.limitOfReferences;
    }

    public int getPurgeTargetDate() {
        return this.purgeTargetDate;
    }

    public ExtendPropertyAdapterFactory getExtendPropertyAdapterFactory() {
        return this.extendPropertyAdapterFactory;
    }

    public VersionController getVersionController(EntityHandler eh) {
        if (eh.getMetaData().getVersionControlType() == null) {
            return this.versionControllers.get((Object)VersionControlType.NONE);
        }
        return this.versionControllers.get((Object)eh.getMetaData().getVersionControlType());
    }

    public Future<String> createDataModelSchema(EntityDefinition definition) {
        EntityContext context = EntityContext.getCurrentContext();
        MetaEntity metaData = new MetaEntity();
        metaData.applyConfig(definition, context, new KeyGenerator());
        return this.createDataModelSchema(metaData, null);
    }

    public Future<String> createDataModelSchema(final MetaEntity newMeta, final MetaDataConfig config) {
        Callable<String> task = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Transaction.requiresNew(t -> {
                    EntityContext context = EntityContext.getCurrentContext();
                    return EntityService.this.doCreate(newMeta, config, context, true);
                });
            }
        };
        return this.asyncTaskService.execute(task);
    }

    public String createDataModelSchema(MetaEntity newMeta, MetaDataConfig config, boolean doAutoReload) {
        EntityContext eContext = EntityContext.getCurrentContext();
        return this.doCreate(newMeta, config, eContext, doAutoReload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doCreate(MetaEntity newMeta, MetaDataConfig config, EntityContext context, boolean doAutoReload) {
        block12: {
            MetaDataEntry curEntry;
            DataStore ds = this.storeService.getDataStore();
            ApplyMetaDataStrategy configDataModel = ds.getApplyMetaDataStrategy();
            if (newMeta.getId() == null) {
                newMeta.setId(new KeyGenerator().generateId());
            }
            String path = this.convertPath(ENTITY_META_PATH + newMeta.getName());
            int curerntMaxVersion = -1;
            List<MetaDataEntryInfo> infoList = ServiceRegistry.getRegistry().getService(MetaDataRepository.class).getHistoryById(ExecuteContext.getCurrentContext().getClientTenantId(), newMeta.getId());
            if (infoList != null) {
                for (MetaDataEntryInfo mi : infoList) {
                    if (mi.getState() == MetaDataEntry.State.VALID) {
                        throw new MetaDataRuntimeException("Registered metadata already exists. id=" + newMeta.getId() + ", path=" + path);
                    }
                    if (curerntMaxVersion >= mi.getVersion()) continue;
                    curerntMaxVersion = mi.getVersion();
                }
            }
            MetaEntity prevMeta = null;
            if (curerntMaxVersion >= 0 && (curEntry = MetaDataContext.getContext().getMetaDataEntryById(newMeta.getId(), curerntMaxVersion)) != null && curEntry.getMetaData() instanceof MetaEntity) {
                prevMeta = (MetaEntity)curEntry.getMetaData();
            }
            if (prevMeta == null) {
                configDataModel.create(newMeta, context);
                MetaDataContext.getContext().store(path, newMeta, config, doAutoReload);
                logger.info("created " + newMeta.getName() + "(" + newMeta.getId() + ")");
            } else {
                boolean prepare = configDataModel.prepare(newMeta, prevMeta, context);
                if (!prepare) {
                    throw new EntityRuntimeException("can not prepare for re-create Entity:" + newMeta.getName() + "(tenant=" + ExecuteContext.getCurrentContext().getClientTenantId() + ")");
                }
                boolean res = false;
                try {
                    res = this.updateData(configDataModel, ExecuteContext.getCurrentContext().getClientTenantId(), newMeta, prevMeta, context, config, curerntMaxVersion);
                    if (res) {
                        MetaDataContext.getContext().store(path, newMeta, config, doAutoReload);
                        logger.info("re-created " + newMeta.getName() + "(" + newMeta.getId() + ")");
                        break block12;
                    }
                    throw new EntityRuntimeException("can not re-create Entity Definition:" + newMeta.getName() + "(tenant=" + ExecuteContext.getCurrentContext().getClientTenantId() + ")");
                }
                finally {
                    configDataModel.finish(res, newMeta, prevMeta, context);
                }
            }
        }
        return newMeta.getId();
    }

    private boolean doPrepare(ApplyMetaDataStrategy st, int tenantId, MetaEntity newOne, MetaEntity previous, EntityContext context) {
        return Transaction.requiresNew(t -> {
            boolean prepare = st.prepare(newOne, previous, context);
            return prepare;
        });
    }

    private boolean updateData(ApplyMetaDataStrategy st, int tenantId, MetaEntity newOne, MetaEntity previous, EntityContext context, MetaDataConfig config, Integer previousVersion) {
        int[] targetTenantIds = null;
        TenantContextService tcService = ServiceRegistry.getRegistry().getService(TenantContextService.class);
        MetaDataEntry ent = previousVersion == null ? MetaDataContext.getContext().getMetaDataEntryById(previous.getId()) : MetaDataContext.getContext().getMetaDataEntryById(previous.getId(), previousVersion);
        if (tcService.getSharedTenantId() == tenantId && ent.isSharable() && !ent.isDataSharable()) {
            List<Integer> allTenantIds = tcService.getAllTenantIdList();
            List<Integer> overwritedTenantIds = MetaDataContext.getContext().getOverwriteTenantIdList(previous.getId());
            Iterator<Integer> it = allTenantIds.iterator();
            while (it.hasNext()) {
                Integer id = it.next();
                if (!overwritedTenantIds.contains(id)) continue;
                logger.info(id + "'s MetaData:" + ent.getPath() + " (" + ent.getMetaData().getId() + ") is overwrote. so skip data patch.");
                it.remove();
            }
            targetTenantIds = new int[allTenantIds.size()];
            for (int i = 0; i < allTenantIds.size(); ++i) {
                targetTenantIds[i] = allTenantIds.get(i);
            }
        } else {
            targetTenantIds = new int[]{tenantId};
        }
        return st.modify(newOne, previous, context, targetTenantIds);
    }

    private boolean doModify(ApplyMetaDataStrategy st, int tenantId, MetaEntity newOne, MetaEntity previous, EntityContext context, MetaDataConfig config, Integer previousVersion) {
        return Transaction.requiresNew(transaction -> {
            boolean res = this.updateData(st, tenantId, newOne, previous, context, config, previousVersion);
            if (!res) {
                transaction.setRollbackOnly();
                return false;
            }
            TenantContext tc = ServiceRegistry.getRegistry().getService(TenantContextService.class).getTenantContext(tenantId);
            tc.getMetaDataContext().update(this.convertPath(ENTITY_META_PATH + newOne.getName()), newOne);
            if (config != null) {
                tc.getMetaDataContext().updateConfig(this.convertPath(ENTITY_META_PATH + newOne.getName()), config);
            }
            return true;
        });
    }

    private boolean doRemove(ApplyMetaDataStrategy st, int tenantId, MetaEntity previous, EntityContext context) {
        return Transaction.requiresNew(t -> {
            TenantContext tc = ServiceRegistry.getRegistry().getService(TenantContextService.class).getTenantContext(tenantId);
            tc.getMetaDataContext().remove(this.convertPath(ENTITY_META_PATH + previous.getName()));
            return true;
        });
    }

    private boolean doDefragMeta(ApplyMetaDataStrategy st, int tenantId, MetaEntity target, EntityContext context) {
        return Transaction.requiresNew(transaction -> {
            boolean res;
            MetaEntity before = target.copy();
            int[] targetTenantIds = null;
            TenantContextService tcService = ServiceRegistry.getRegistry().getService(TenantContextService.class);
            MetaDataEntry ent = MetaDataContext.getContext().getMetaDataEntryById(target.getId());
            if (tcService.getSharedTenantId() == tenantId && ent.isSharable() && !ent.isDataSharable()) {
                List<Integer> allTenantIds = tcService.getAllTenantIdList();
                List<Integer> overwritedTenantIds = MetaDataContext.getContext().getOverwriteTenantIdList(target.getId());
                Iterator<Integer> it = allTenantIds.iterator();
                while (it.hasNext()) {
                    Integer id = it.next();
                    if (!overwritedTenantIds.contains(id)) continue;
                    logger.info(id + "'s MetaData:" + ent.getPath() + " (" + ent.getMetaData().getId() + ") is overwrote. so skip defrag data.");
                    it.remove();
                }
                targetTenantIds = new int[allTenantIds.size()];
                for (int i = 0; i < allTenantIds.size(); ++i) {
                    targetTenantIds[i] = allTenantIds.get(i);
                }
            } else {
                targetTenantIds = new int[]{tenantId};
            }
            if (!(res = st.defrag(target, context, targetTenantIds))) {
                transaction.setRollbackOnly();
                return false;
            }
            if (!before.equals(target)) {
                TenantContext tc = ServiceRegistry.getRegistry().getService(TenantContextService.class).getTenantContext(tenantId);
                tc.getMetaDataContext().update(this.convertPath(ENTITY_META_PATH + target.getName()), target);
            }
            return true;
        });
    }

    private void doFinish(boolean modifyResult, ApplyMetaDataStrategy st, int tenantId, MetaEntity newOne, MetaEntity previous, EntityContext context) {
        Transaction.requiresNew(t -> st.finish(modifyResult, newOne, previous, context));
    }

    public Future<String> updateDataModelSchema(EntityDefinition definition) {
        return this.updateDataModelSchema(definition, null);
    }

    public Future<String> updateDataModelSchema(EntityDefinition definition, Map<String, String> renamePropertyMap) {
        EntityContext context = EntityContext.getCurrentContext();
        EntityHandler currentHandler = context.getHandlerByName(definition.getName());
        if (currentHandler == null) {
            throw new MetaDataRuntimeException(definition.getName() + " not found.");
        }
        MetaEntity newMeta = currentHandler.getMetaData().copy();
        if (renamePropertyMap != null) {
            for (Map.Entry<String, String> entry : renamePropertyMap.entrySet()) {
                MetaProperty p = newMeta.getDeclaredProperty(entry.getKey());
                if (p == null) {
                    throw new MetaDataRuntimeException(definition.getName() + "'s " + entry.getKey() + " not found.");
                }
                p.setName(entry.getValue());
            }
        }
        newMeta.applyConfig(definition, context, new KeyGenerator());
        return this.updateDataModelSchema(newMeta, null);
    }

    public Future<String> updateDataModelSchema(final MetaEntity newMeta, final MetaDataConfig config) {
        Callable<String> task = new Callable<String>(){

            @Override
            public String call() throws Exception {
                ExecuteContext currentContext = ExecuteContext.getCurrentContext();
                EntityContext context = EntityContext.getCurrentContext();
                EntityHandler currentHandler = context.getHandlerById(newMeta.getId());
                DataStore currentDs = EntityService.this.storeService.getDataStore();
                ApplyMetaDataStrategy reConfigDataModel = currentDs.getApplyMetaDataStrategy();
                if (newMeta.getEntityStoreDefinition() != null && !newMeta.getEntityStoreDefinition().getClass().equals(currentDs.getEntityStoreType()) && currentHandler.getMetaData().getStoreMapping() != null) {
                    newMeta.setStoreMapping((MetaStoreMapping)currentHandler.getMetaData().getStoreMapping().copy());
                }
                logger.info("update " + currentHandler.getMetaData().getName() + "(" + currentHandler.getMetaData().getId() + ") process start");
                boolean prepare = EntityService.this.doPrepare(reConfigDataModel, currentContext.getClientTenantId(), newMeta, currentHandler.getMetaData(), context);
                if (!prepare) {
                    throw new EntityRuntimeException("can not prepare for update Entity:" + currentHandler.getMetaData().getName() + "(tenant=" + currentContext.getClientTenantId() + ")");
                }
                boolean result = false;
                try {
                    result = EntityService.this.doModify(reConfigDataModel, currentContext.getClientTenantId(), newMeta, currentHandler.getMetaData(), context, config, null);
                    if (result) {
                        String string = newMeta.getId();
                        return string;
                    }
                    throw new EntityRuntimeException("can not modify Entity Definition:" + currentHandler.getMetaData().getName() + "(tenant=" + currentContext.getClientTenantId() + ")");
                }
                finally {
                    EntityService.this.doFinish(result, reConfigDataModel, currentContext.getClientTenantId(), newMeta, currentHandler.getMetaData(), context);
                    if (result) {
                        logger.info("update " + currentHandler.getMetaData().getName() + "(" + currentHandler.getMetaData().getId() + ") process finish");
                    } else {
                        logger.info("update " + currentHandler.getMetaData().getName() + "(" + currentHandler.getMetaData().getId() + ") process fail");
                    }
                }
            }
        };
        return this.asyncTaskService.execute(task);
    }

    public Future<String> removeDataModelSchema(EntityDefinition definition) {
        EntityContext context = EntityContext.getCurrentContext();
        MetaEntity metaData = new MetaEntity();
        metaData.applyConfig(definition, context, new KeyGenerator());
        return this.removeDataModelSchema(metaData);
    }

    public Future<String> removeDataModelSchema(final MetaEntity curMeta) {
        Callable<String> task = new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws Exception {
                String string;
                ExecuteContext currentContext = ExecuteContext.getCurrentContext();
                EntityContext context = EntityContext.getCurrentContext();
                EntityHandler currentHandler = context.getHandlerByName(curMeta.getName());
                ApplyMetaDataStrategy reConfigDataModel = currentHandler.getDataStore().getApplyMetaDataStrategy();
                MetaEntity metaEntity = currentHandler.getMetaData();
                logger.info("remove " + currentHandler.getMetaData().getName() + "(" + currentHandler.getMetaData().getId() + ") process start");
                boolean prepare = EntityService.this.doPrepare(reConfigDataModel, currentContext.getClientTenantId(), metaEntity, metaEntity, context);
                if (!prepare) {
                    throw new EntityRuntimeException("can not prepare for remove Entity:" + currentHandler.getMetaData().getName() + "(tenant=" + currentContext.getClientTenantId() + ")");
                }
                boolean result = false;
                MetaEntity newOne = null;
                try {
                    MetaDataEntry ent = MetaDataContext.getContext().getMetaDataEntryById(metaEntity.getId());
                    if (ent.getRepositryType() == MetaDataEntry.RepositoryType.SHARED_OVERWRITE) {
                        MetaDataContext shredContext = ServiceRegistry.getRegistry().getService(TenantContextService.class).getSharedTenantContext().getMetaDataContext();
                        MetaDataEntry shared = shredContext.getMetaDataEntryById(metaEntity.getId());
                        if (shared != null) {
                            result = EntityService.this.doModify(reConfigDataModel, currentContext.getClientTenantId(), (MetaEntity)shared.getMetaData(), metaEntity, context, null, null);
                            newOne = (MetaEntity)shared.getMetaData();
                        } else {
                            result = EntityService.this.doRemove(reConfigDataModel, currentContext.getClientTenantId(), metaEntity, context);
                            newOne = metaEntity;
                        }
                    } else {
                        result = EntityService.this.doRemove(reConfigDataModel, currentContext.getClientTenantId(), metaEntity, context);
                        newOne = metaEntity;
                    }
                    if (!result) {
                        throw new EntityRuntimeException("can not delete Entity definition:" + currentHandler.getMetaData().getName() + "(tenant=" + currentContext.getClientTenantId() + ")");
                    }
                    string = metaEntity.getId();
                }
                catch (Throwable throwable) {
                    EntityService.this.doFinish(result, reConfigDataModel, currentContext.getClientTenantId(), newOne, metaEntity, context);
                    if (result) {
                        logger.info("remove " + currentHandler.getMetaData().getName() + "(" + currentHandler.getMetaData().getId() + ") process finish");
                    } else {
                        logger.info("remove " + currentHandler.getMetaData().getName() + "(" + currentHandler.getMetaData().getId() + ") process fail");
                    }
                    throw throwable;
                }
                EntityService.this.doFinish(result, reConfigDataModel, currentContext.getClientTenantId(), newOne, metaEntity, context);
                if (result) {
                    logger.info("remove " + currentHandler.getMetaData().getName() + "(" + currentHandler.getMetaData().getId() + ") process finish");
                } else {
                    logger.info("remove " + currentHandler.getMetaData().getName() + "(" + currentHandler.getMetaData().getId() + ") process fail");
                }
                return string;
            }
        };
        return this.asyncTaskService.execute(task);
    }

    public void renameProperty(String defName, String from, String to) {
        EntityHandler eh = this.getRuntimeByName(defName);
        if (eh == null) {
            throw new MetaDataRuntimeException(defName + " not found.");
        }
        MetaEntity meta = eh.getMetaData().copy();
        MetaProperty p = meta.getDeclaredProperty(from);
        if (p == null) {
            throw new MetaDataRuntimeException(defName + "'s " + from + " not found.");
        }
        if (meta.getDeclaredProperty(to) != null) {
            throw new MetaDataRuntimeException(defName + "'s " + to + " already declared.");
        }
        p.setName(to);
        MetaDataContext.getContext().update(this.convertPath(ENTITY_META_PATH + defName), meta);
    }

    @Override
    public List<String> nameList() {
        List<String> pathList = MetaDataContext.getContext().pathList(EntityService.getFixedPath());
        pathList.replaceAll(new UnaryOperator<String>(){

            @Override
            public String apply(String path) {
                return path.substring(EntityService.getFixedPath().length()).replace("/", ".");
            }
        });
        pathList.removeIf(new Predicate<String>(){

            @Override
            public boolean test(String name) {
                return EntityService.ENTITY_NAME.equals(name);
            }
        });
        return pathList;
    }

    @Override
    public List<MetaDataEntryInfo> list() {
        return this.list("");
    }

    @Override
    public List<MetaDataEntryInfo> list(String path) {
        List<MetaDataEntryInfo> list = MetaDataContext.getContext().definitionList(this.convertPath(EntityService.getFixedPath() + path));
        if (list != null) {
            final String entityPath = EntityService.getFixedPath() + ENTITY_NAME;
            list.removeIf(new Predicate<MetaDataEntryInfo>(){

                @Override
                public boolean test(MetaDataEntryInfo definition) {
                    return entityPath.equals(definition.getPath());
                }
            });
        }
        return list;
    }

    @Override
    public EntityHandler getRuntimeByName(String name) {
        return MetaDataContext.getContext().getMetaDataHandler(EntityHandler.class, this.convertPath(ENTITY_META_PATH + name));
    }

    @Override
    public EntityHandler getRuntimeById(String id) {
        return MetaDataContext.getContext().getMetaDataHandlerById(EntityHandler.class, id);
    }

    public EntityHandler getHandlerById(String id, int version) {
        return MetaDataContext.getContext().getMetaDataHandlerById(EntityHandler.class, id, version);
    }

    public void purgeById(String id) {
        Transaction.required(t -> {
            ExecuteContext context = ExecuteContext.getCurrentContext();
            EntityContext eContext = EntityContext.getCurrentContext();
            DataStore dataStore = this.storeService.getDataStore();
            EntityStoreStrategy strategy = dataStore.getEntityStoreStrategy();
            logger.info("purge by id:" + id + ") process start");
            strategy.purgeById(eContext, id);
            if (this.additionalStoreMaintainer != null) {
                for (AdditionalStoreMaintainer asm : this.additionalStoreMaintainer) {
                    asm.clean(context.getClientTenantId(), id);
                }
            }
            logger.info("purge by id:" + id + ") process finish");
        });
    }

    public void defragByName(String name) {
        ExecuteContext context = ExecuteContext.getCurrentContext();
        EntityContext eContext = EntityContext.getCurrentContext();
        EntityHandler eh = this.getRuntimeByName(name);
        MetaEntity meta = eh.getMetaData();
        DataStore ds = this.storeService.getDataStore();
        EntityStoreStrategy dataStrategy = ds.getEntityStoreStrategy();
        ApplyMetaDataStrategy metaStrategy = ds.getApplyMetaDataStrategy();
        boolean result = false;
        if (eh.isUseSharedMetaData()) {
            result = true;
        } else {
            logger.info("defrag " + name + "(" + meta.getId() + ") process start");
            boolean prepare = this.doPrepare(metaStrategy, context.getClientTenantId(), meta, meta, eContext);
            if (!prepare) {
                throw new EntityRuntimeException("can not prepare for defrag Entity:" + meta.getName() + "(tenant=" + context.getClientTenantId() + ")");
            }
            MetaEntity target = meta.copy();
            try {
                result = this.doDefragMeta(metaStrategy, context.getClientTenantId(), target, eContext);
            }
            catch (RuntimeException e) {
                throw new EntityRuntimeException("can not defrag Entity:" + meta.getName() + "(tenant=" + context.getClientTenantId() + ")", e);
            }
            finally {
                this.doFinish(result, metaStrategy, context.getClientTenantId(), target, meta, eContext);
            }
        }
        if (result) {
            eh = this.getRuntimeByName(name);
            dataStrategy.defragData(eContext, eh);
            if (this.additionalStoreMaintainer != null) {
                for (AdditionalStoreMaintainer asm : this.additionalStoreMaintainer) {
                    asm.defrag(context.getClientTenantId(), eh);
                }
            }
            logger.info("defrag " + name + "(" + meta.getId() + ") process finish");
        } else {
            logger.info("defrag " + name + "(" + meta.getId() + ") process fail");
        }
    }

    public boolean isLockedSchema(String name) {
        EntityContext context = EntityContext.getCurrentContext();
        EntityHandler currentHandler = context.getHandlerByName(name);
        if (currentHandler != null) {
            DataStore currentDs = this.storeService.getDataStore();
            ApplyMetaDataStrategy configDataModel = currentDs.getApplyMetaDataStrategy();
            return configDataModel.isLocked(currentHandler.getMetaData(), context);
        }
        return false;
    }

    @Override
    public void destroy() {
    }

    public EntityInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    @Override
    public void init(Config config) {
        this.asyncTaskService = config.getDependentService(AsyncTaskService.class);
        this.storeService = config.getDependentService(StoreService.class);
        List<?> interceptorList = config.getBeans("interceptor");
        if (interceptorList != null) {
            this.interceptors = interceptorList.toArray(new EntityInterceptor[interceptorList.size()]);
        }
        if (config.getValue("limitOfReferences") != null) {
            this.limitOfReferences = Integer.parseInt(config.getValue("limitOfReferences"));
        }
        if (config.getValue("purgeTargetDate") != null) {
            this.purgeTargetDate = Integer.parseInt(config.getValue("purgeTargetDate"));
        }
        this.additionalStoreMaintainer = config.getValues("additionalStoreMaintainer", AdditionalStoreMaintainer.class);
        this.extendPropertyAdapterFactory = config.getValue("extendPropertyAdapterFactory", ExtendPropertyAdapterFactory.class);
        if (this.extendPropertyAdapterFactory == null) {
            this.extendPropertyAdapterFactory = new ExtendPropertyAdapterFactory();
        }
    }

    private String convertPath(String path) {
        return path.replace(".", "/");
    }

    @Override
    public void createMetaData(MetaEntity meta) {
        this.createDataModelSchema(meta, null);
    }

    @Override
    public void updateMetaData(MetaEntity meta) {
        this.updateDataModelSchema(meta, null);
    }

    @Override
    public void removeMetaData(String definitionName) {
        EntityHandler eh = this.getRuntimeByName(definitionName);
        if (eh != null) {
            this.removeDataModelSchema(eh.getMetaData());
        }
    }

    @Override
    public Class<MetaEntity> getMetaDataType() {
        return MetaEntity.class;
    }

    @Override
    public Class<EntityHandler> getRuntimeType() {
        return EntityHandler.class;
    }

    public static class TypeMap
    extends DefinitionMetaDataTypeMap<EntityDefinition, MetaEntity> {
        public TypeMap() {
            super(EntityService.getFixedPath(), MetaEntity.class, EntityDefinition.class);
        }

        @Override
        public TypedDefinitionManager<EntityDefinition> typedDefinitionManager() {
            return ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
        }

        @Override
        public String toPath(String defName) {
            return this.pathPrefix + defName.replace('.', '/');
        }

        @Override
        public String toDefName(String path) {
            return path.substring(this.pathPrefix.length()).replace("/", ".");
        }
    }
}

