/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.lob;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.iplass.mtp.entity.EntityConcurrentUpdateException;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.impl.lob.LobDao;
import org.iplass.mtp.impl.lob.LobValidatedOutputStream;
import org.iplass.mtp.impl.lob.SizeUpdateOutputStream;
import org.iplass.mtp.impl.lob.lobstore.LobData;
import org.iplass.mtp.impl.lob.lobstore.LobStore;
import org.iplass.mtp.impl.lob.lobstore.LobValidator;
import org.iplass.mtp.impl.lob.lobstore.rdb.RdbLobStore;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lob {
    public static final String STATE_VALID = "V";
    public static final String STATE_TEMP = "T";
    static final long IS_NEW = -1L;
    static final long IS_NOT_INIT = -2L;
    private int tenantId;
    private long lobId;
    private String name;
    private String type;
    private String definitionId;
    private String propertyId;
    private String oid;
    private Long version;
    private String sessionId;
    private String status;
    private long lobDataId;
    private long prevLobDataId = -2L;
    private LobData lobData;
    private LobStore lobStore;
    private LobDao dao;
    private boolean updateSize;

    public Lob(int tenantId, long lobId, String name, String type, String definitionId, String propertyId, String oid, Long version, String sessionId, String status, long lobDataId, LobStore lobStore, LobDao dao, boolean updateSize) {
        this.tenantId = tenantId;
        this.lobId = lobId;
        this.name = name;
        this.type = type;
        this.definitionId = definitionId;
        this.propertyId = propertyId;
        this.oid = oid;
        this.version = version;
        this.sessionId = sessionId;
        this.status = status;
        this.lobDataId = lobDataId;
        this.lobStore = lobStore;
        this.dao = dao;
        this.updateSize = lobStore instanceof RdbLobStore ? false : updateSize;
    }

    public boolean isUpdateSize() {
        return this.updateSize;
    }

    public LobDao getDao() {
        return this.dao;
    }

    public LobStore getLobStore() {
        return this.lobStore;
    }

    public LobData getLobData() {
        if (this.lobData == null && this.lobDataId > 0L) {
            this.lobData = this.lobStore.load(this.tenantId, this.lobDataId);
        }
        return this.lobData;
    }

    public InputStream getBinaryInputStream() {
        if (this.getLobData() != null) {
            return this.getLobData().getBinaryInputStream();
        }
        return null;
    }

    public OutputStream getBinaryOutputStream() {
        this.allocateLobData(null);
        OutputStream os = null;
        LobValidator lv = this.lobStore.getLobValidator();
        os = lv == null ? this.lobData.getBinaryOutputStream() : new LobValidatedOutputStream(this.lobData.getBinaryOutputStream(), this, lv);
        if (this.updateSize) {
            os = new SizeUpdateOutputStream(os, this.tenantId, this.lobData, this.dao);
        }
        return os;
    }

    private void allocateLobData(Long size) {
        if (this.lobDataId == -1L) {
            this.prevLobDataId = this.lobDataId;
            this.lobDataId = this.lobId;
            if (!this.dao.updateLobDataId(this.tenantId, this.lobId, this.prevLobDataId, this.lobDataId)) {
                throw new EntityConcurrentUpdateException(Lob.resourceString("impl.lob.Lob.cantUpdate", new Object[0]));
            }
            this.dao.initLobData(this.tenantId, this.lobDataId, size);
            this.lobData = this.lobStore.create(this.tenantId, this.lobDataId);
        } else if (this.prevLobDataId == -2L) {
            this.prevLobDataId = this.lobDataId;
            this.lobDataId = this.dao.nextLobDataId(this.tenantId);
            if (!this.dao.updateLobDataId(this.tenantId, this.lobId, this.prevLobDataId, this.lobDataId)) {
                throw new EntityConcurrentUpdateException(Lob.resourceString("impl.lob.Lob.cantUpdate", new Object[0]));
            }
            this.dao.refCountUp(this.tenantId, this.prevLobDataId, -1);
            this.dao.initLobData(this.tenantId, this.lobDataId, size);
            this.lobData = this.lobStore.create(this.tenantId, this.lobDataId);
        }
    }

    public void transferFrom(File file) throws IOException {
        Long size = null;
        if (this.updateSize) {
            size = file.length();
        }
        this.allocateLobData(size);
        LobValidator lv = this.lobStore.getLobValidator();
        if (lv == null) {
            this.lobData.transferFrom(file);
        } else {
            byte[] buf = new byte[8192];
            try (FileInputStream is = new FileInputStream(file);
                 OutputStream los = this.lobData.getBinaryOutputStream();
                 LobValidatedOutputStream os = new LobValidatedOutputStream(los, this, lv);){
                int count;
                while ((count = ((InputStream)is).read(buf)) != -1) {
                    ((OutputStream)os).write(buf, 0, count);
                }
                ((OutputStream)os).flush();
            }
        }
    }

    public long getLobId() {
        return this.lobId;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public byte[] getByte() {
        InputStream is = this.getBinaryInputStream();
        if (is == null) {
            return null;
        }
        byte[] buf = new byte[8192];
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            int count;
            while ((count = is.read(buf)) != -1) {
                os.write(buf, 0, count);
            }
            os.flush();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new EntityRuntimeException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                this.logFailResourceCleaning(e);
            }
        }
    }

    public void setByte(byte[] binary) {
        OutputStream os = this.getBinaryOutputStream();
        byte[] buf = new byte[8192];
        ByteArrayInputStream is = new ByteArrayInputStream(binary);
        try {
            int count;
            while ((count = is.read(buf)) != -1) {
                os.write(buf, 0, count);
            }
            os.flush();
        }
        catch (IOException e) {
            throw new EntityRuntimeException(e);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                this.logFailResourceCleaning(e);
            }
        }
    }

    private void logFailResourceCleaning(Exception e) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.error("Fail to close BinaryData's Stream. Check whether resource is leak or not.", (Throwable)e);
    }

    public long getSize() {
        if (this.getLobData() != null) {
            return this.getLobData().getSize();
        }
        return 0L;
    }

    public String getDefinitionId() {
        return this.definitionId;
    }

    public String getOid() {
        return this.oid;
    }

    public Long getVersion() {
        return this.version;
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getStatus() {
        return this.status;
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public long getLobDataId() {
        return this.lobDataId;
    }

    public long getPrevLobDataId() {
        return this.prevLobDataId;
    }

    private static String resourceString(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }
}

