/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.lob.lobstore.file;

import java.io.File;
import org.iplass.mtp.impl.lob.LobStoreService;
import org.iplass.mtp.impl.lob.lobstore.LobData;
import org.iplass.mtp.impl.lob.lobstore.LobStore;
import org.iplass.mtp.impl.lob.lobstore.LobValidator;
import org.iplass.mtp.impl.lob.lobstore.file.FileLobData;
import org.iplass.mtp.impl.transaction.TransactionService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLobStore
implements LobStore {
    private static final Logger logger = LoggerFactory.getLogger(FileLobStore.class);
    private String rootDir;
    private boolean overwriteFile = false;
    private LobValidator lobValidator;

    @Override
    public LobValidator getLobValidator() {
        return this.lobValidator;
    }

    public void setLobValidator(LobValidator lobValidator) {
        this.lobValidator = lobValidator;
    }

    public boolean isOverwriteFile() {
        return this.overwriteFile;
    }

    public void setOverwriteFile(boolean overwriteFile) {
        this.overwriteFile = overwriteFile;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String rootDir) {
        this.rootDir = rootDir;
    }

    @Override
    public void inited(LobStoreService service, Config config) {
        if (this.rootDir == null) {
            throw new ServiceConfigrationException("rootDir is undefined at FileLobStoreService");
        }
    }

    @Override
    public void destroyed() {
    }

    @Override
    public LobData create(int tenantId, long lobDataId) {
        return new FileLobData(tenantId, lobDataId, this.rootDir, this.overwriteFile);
    }

    @Override
    public LobData load(int tenantId, long lobDataId) {
        return new FileLobData(tenantId, lobDataId, this.rootDir, this.overwriteFile);
    }

    @Override
    public void remove(int tenantId, long lobDataId) {
        Transaction t = ServiceRegistry.getRegistry().getService(TransactionService.class).getTransacitonManager().currentTransaction();
        if (t != null && t.getStatus() == TransactionStatus.ACTIVE) {
            t.afterCommit(() -> {
                FileLobData data = new FileLobData(tenantId, lobDataId, this.rootDir, this.overwriteFile);
                File f = data.toFile(lobDataId);
                if (f.exists() && !f.delete()) {
                    logger.warn("maybe can not delete file:" + f.getAbsolutePath());
                }
            });
        } else {
            FileLobData data = new FileLobData(tenantId, lobDataId, this.rootDir, this.overwriteFile);
            File f = data.toFile(lobDataId);
            if (f.exists() && !f.delete()) {
                logger.warn("maybe can not delete file:" + f.getAbsolutePath());
            }
        }
    }
}

