/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata.binary;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryMetaDataService
implements Service {
    private static Logger logger = LoggerFactory.getLogger(BinaryMetaDataService.class);
    private int keepInMemoryThreshold = 65536;
    private int cacheMemoryThreshold = 0x100000;
    private String tempFileDir;
    private int xmlBinaryChunkSize = 262144;
    private Path tempFileDirPath;
    private boolean deleteTempFileOnDestroy = true;
    private volatile boolean cleanedup;

    public int getXmlBinaryChunkSize() {
        return this.xmlBinaryChunkSize;
    }

    public int getKeepInMemoryThreshold() {
        return this.keepInMemoryThreshold;
    }

    public int getCacheMemoryThreshold() {
        return this.cacheMemoryThreshold;
    }

    public Path getTempFileDir() {
        return this.tempFileDirPath;
    }

    @Override
    public void init(Config config) {
        if (config.getValue("keepInMemoryThreshold") != null) {
            this.keepInMemoryThreshold = Integer.parseInt(config.getValue("keepInMemoryThreshold"));
        }
        if (config.getValue("cacheMemoryThreshold") != null) {
            this.cacheMemoryThreshold = Integer.parseInt(config.getValue("cacheMemoryThreshold"));
        }
        if (config.getValue("xmlBinaryChunkSize") != null) {
            this.xmlBinaryChunkSize = Integer.parseInt(config.getValue("xmlBinaryChunkSize"));
        }
        if (config.getValue("deleteTempFileOnDestroy") != null) {
            this.deleteTempFileOnDestroy = Boolean.valueOf(config.getValue("deleteTempFileOnDestroy"));
        }
        this.tempFileDir = config.getValue("tempFileDir");
        if (this.tempFileDir == null) {
            try {
                this.tempFileDirPath = Files.createTempDirectory("bmd_", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ServiceConfigrationException("can't create temporary file dir on default temp dir", e);
            }
        }
        try {
            this.tempFileDirPath = Files.createTempDirectory(FileSystems.getDefault().getPath(this.tempFileDir, new String[0]), "bmd_", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ServiceConfigrationException("can't create temporary file dir on " + this.tempFileDir, e);
        }
        logger.info("create temporary dir for binary metadata:" + this.tempFileDirPath);
        if (this.deleteTempFileOnDestroy) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (!this.cleanedup) {
                    BinaryMetaDataService binaryMetaDataService = this;
                    synchronized (binaryMetaDataService) {
                        if (!this.cleanedup) {
                            this.cleanupTempDir();
                        }
                    }
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupTempDir() {
        if (!this.cleanedup) {
            BinaryMetaDataService binaryMetaDataService = this;
            synchronized (binaryMetaDataService) {
                if (!this.cleanedup) {
                    try {
                        FileUtils.deleteDirectory((File)this.tempFileDirPath.toFile());
                    }
                    catch (IOException e) {
                        logger.warn("can't delete temporary dir for binary metadata:" + this.tempFileDirPath);
                    }
                    this.cleanedup = true;
                }
            }
        }
    }

    @Override
    public void destroy() {
        if (this.deleteTempFileOnDestroy) {
            this.cleanupTempDir();
        }
    }
}

