/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata.xmlfile;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.iplass.mtp.impl.metadata.AbstractXmlMetaDataStore;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.metadata.MetaDataEntryInfo;
import org.iplass.mtp.impl.metadata.MetaDataJAXBService;
import org.iplass.mtp.impl.metadata.MetaDataRepository;
import org.iplass.mtp.impl.metadata.MetaDataRepositoryKind;
import org.iplass.mtp.impl.metadata.MetaDataRuntimeException;
import org.iplass.mtp.impl.metadata.xmlfile.DomXmlExternalRefHandler;
import org.iplass.mtp.impl.metadata.xmlfile.XmlExternalRefHandler;
import org.iplass.mtp.impl.metadata.xmlfile.XmlFileMetaDataEntryThinWrapper;
import org.iplass.mtp.spi.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlFileMetaDataStore
extends AbstractXmlMetaDataStore {
    private static Logger logger = LoggerFactory.getLogger(XmlFileMetaDataStore.class);
    private String rootPath;
    private String fileStorePath;
    private String groovySourceStorePath;
    private int localTenantId;
    private String suffix = ".xml";
    private XmlExternalRefHandler xmlExternalRefHandler = new DomXmlExternalRefHandler();

    public void setXmlExternalRefHandler(XmlExternalRefHandler xmlExternalRefHandler) {
        this.xmlExternalRefHandler = xmlExternalRefHandler;
    }

    public XmlExternalRefHandler getXmlExternalRefHandler() {
        return this.xmlExternalRefHandler;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public String getFileStorePath() {
        if (this.rootPath == null) {
            return this.fileStorePath;
        }
        return this.rootPath + this.fileStorePath;
    }

    public void setFileStorePath(String fileStorePath) {
        this.fileStorePath = fileStorePath;
    }

    public String getGroovySourceStorePath() {
        return this.groovySourceStorePath;
    }

    public void setGroovySourceStorePath(String groovySourceStorePath) {
        this.groovySourceStorePath = groovySourceStorePath;
    }

    public int getLocalTenantId() {
        return this.localTenantId;
    }

    public void setLocalTenantId(int localTenantId) {
        this.localTenantId = localTenantId;
    }

    @Override
    public MetaDataEntry loadById(int tenantId, String id) {
        if (tenantId != this.localTenantId) {
            return null;
        }
        String prefixpath = this.getFileStorePath();
        MetaDataEntry e = this.searchFileById(id.trim(), new File(prefixpath));
        if (e == null) {
            return null;
        }
        return e;
    }

    @Override
    public MetaDataEntry loadById(int tenantId, String id, int version) {
        return this.loadById(tenantId, id);
    }

    @Override
    public List<MetaDataEntryInfo> definitionList(int tenantId, String prefixPath, boolean withInvalid) throws MetaDataRuntimeException {
        if (tenantId != this.localTenantId) {
            return new ArrayList<MetaDataEntryInfo>();
        }
        String path = prefixPath;
        if (path != null) {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if (path.contains("..")) {
                throw new MetaDataRuntimeException("invalid path:" + path);
            }
        }
        ArrayList<MetaDataEntryInfo> res = new ArrayList<MetaDataEntryInfo>();
        File dir = new File(this.getFileStorePath() + "/" + path);
        this.readMetaDataEntryInfoRecursive(res, prefixPath, dir);
        return res;
    }

    private void readMetaDataEntryInfoRecursive(ArrayList<MetaDataEntryInfo> res, String prefixPath, File f) {
        if (f.exists()) {
            if (f.isDirectory()) {
                String[] list;
                for (String l : list = f.list()) {
                    File subdirFile = new File(f, l);
                    this.readMetaDataEntryInfoRecursive(res, prefixPath, subdirFile);
                }
            } else if (this.isMetaDataXml(f)) {
                MetaDataEntry e = this.readMetaDataEntry(f);
                MetaDataEntryInfo node = new MetaDataEntryInfo();
                node.setPath(e.getPath());
                node.setId(e.getMetaData().getId());
                node.setDisplayName(e.getMetaData().getDisplayName());
                node.setDescription(e.getMetaData().getDescription());
                node.setSharable(false);
                node.setDataSharable(false);
                node.setPermissionSharable(false);
                node.setOverwritable(true);
                node.setRepository(MetaDataRepositoryKind.XMLFILE.getDisplayName());
                node.setState(MetaDataEntry.State.VALID);
                res.add(node);
            }
        }
    }

    @Override
    public void inited(MetaDataRepository service, Config config) {
        super.inited(service, config);
        if (this.fileStorePath != null) {
            this.fileStorePath = this.fileStorePath.replaceAll("\\\\", "/");
            if (!this.fileStorePath.endsWith("/")) {
                this.fileStorePath = this.fileStorePath + "/";
            }
            logger.debug("XmlFileRepository." + new File(this.fileStorePath).getAbsolutePath());
            MetaDataJAXBService jaxbService = config.getDependentService(MetaDataJAXBService.class);
            this.context = jaxbService.createJAXBContext(XmlFileMetaDataEntryThinWrapper.class);
            this.xmlExternalRefHandler.inited(service, this);
        }
        if (this.groovySourceStorePath != null) {
            this.groovySourceStorePath = this.groovySourceStorePath.replaceAll("\\\\", "/");
            if (!this.groovySourceStorePath.endsWith("/")) {
                this.groovySourceStorePath = this.groovySourceStorePath + "/";
            }
        }
    }

    private MetaDataEntry readMetaDataEntry(File file) {
        MetaDataEntry instance = null;
        try {
            instance = new MetaDataEntry();
            XmlFileMetaDataEntryThinWrapper meta = this.unmarshal(file);
            instance.setMetaData(meta.getMetaData());
            if (meta.getVersion() != null) {
                instance.setVersion(meta.getVersion());
            }
            instance.setState(MetaDataEntry.State.VALID);
            String storeRoot = this.getFileStorePath();
            if (storeRoot.endsWith("/")) {
                storeRoot = storeRoot.substring(0, storeRoot.length() - 1);
            }
            String filePath = file.getPath();
            String path = filePath.substring(storeRoot.length());
            path = path.substring(0, path.lastIndexOf(".")).replaceAll("\\\\", "/");
            instance.setPath(path);
        }
        catch (JAXBException e) {
            throw new MetaDataRuntimeException(e);
        }
        return instance;
    }

    private MetaDataEntry searchFileById(String id, File dir) {
        if (dir.isDirectory()) {
            String[] list;
            for (String l : list = dir.list()) {
                MetaDataEntry e;
                File f = new File(dir, l);
                if (f.isDirectory()) {
                    MetaDataEntry subDirMeta = this.searchFileById(id, f);
                    if (subDirMeta == null) continue;
                    return subDirMeta;
                }
                if (!this.isMetaDataXml(f) || !id.equals((e = this.readMetaDataEntry(f)).getMetaData().getId())) continue;
                return e;
            }
        }
        return null;
    }

    @Override
    public MetaDataEntry load(int tenantId, String path) {
        if (tenantId != this.localTenantId) {
            return null;
        }
        if (path.contains("..")) {
            throw new MetaDataRuntimeException("invalid path:" + path);
        }
        String filePath = "/" + path;
        try {
            String[] list;
            String dirPath = this.getFileStorePath() + filePath.substring(0, filePath.lastIndexOf("/"));
            String fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
            if (fileName.length() == 0) {
                return null;
            }
            File dir = new File(dirPath);
            if (!dir.exists()) {
                return null;
            }
            for (String l : list = dir.list()) {
                if (!l.equals(fileName + this.suffix)) continue;
                File file = new File(dir, l);
                MetaDataEntry instance = new MetaDataEntry();
                XmlFileMetaDataEntryThinWrapper meta = this.unmarshal(file);
                instance.setMetaData(meta.getMetaData());
                if (meta.getVersion() != null) {
                    instance.setVersion(meta.getVersion());
                }
                instance.setState(MetaDataEntry.State.VALID);
                instance.setPath(path);
                return instance;
            }
            return null;
        }
        catch (JAXBException e) {
            throw new MetaDataRuntimeException(e);
        }
    }

    @Override
    public MetaDataEntry load(int tenantId, String path, int version) throws MetaDataRuntimeException {
        return this.load(tenantId, path);
    }

    @Override
    public void store(int tenantId, MetaDataEntry metaDataEntry) throws MetaDataRuntimeException {
        this.store(tenantId, metaDataEntry, 0);
    }

    public void store(int tenantId, MetaDataEntry metaDataEntry, int version) throws MetaDataRuntimeException {
        if (tenantId != this.localTenantId) {
            throw new MetaDataRuntimeException("can not save metadata on local file store except tenantId {" + this.localTenantId + "}");
        }
        String filePath = "/" + metaDataEntry.getPath();
        XmlFileMetaDataEntryThinWrapper meta = new XmlFileMetaDataEntryThinWrapper(metaDataEntry.getMetaData());
        meta.setVersion(version);
        File xml = new File(this.getFileStorePath() + filePath + this.suffix);
        this.marshal(meta, xml);
    }

    @Override
    public void update(int tenantId, MetaDataEntry metaDataEntry) throws MetaDataRuntimeException {
        if (tenantId != this.localTenantId) {
            throw new MetaDataRuntimeException("can not update metadata on local file store except tenantId {" + this.localTenantId + "}");
        }
        String filePath = "/" + metaDataEntry.getPath();
        File file = new File(this.getFileStorePath() + filePath + this.suffix);
        int version = 0;
        try {
            MetaDataEntry prevMeta = this.loadById(tenantId, metaDataEntry.getMetaData().getId());
            if (prevMeta != null) {
                File oldFile = new File(this.getFileStorePath() + "/" + prevMeta.getPath() + this.suffix);
                XmlFileMetaDataEntryThinWrapper meta = this.unmarshal(oldFile);
                version = meta.getVersion() == null ? 0 : meta.getVersion() + 1;
                file.delete();
            }
            XmlFileMetaDataEntryThinWrapper meta = new XmlFileMetaDataEntryThinWrapper(metaDataEntry.getMetaData());
            meta.setVersion(version);
            this.marshal(meta, file);
            if (prevMeta != null && !prevMeta.getPath().equals(metaDataEntry.getPath())) {
                File oldFile = new File(this.getFileStorePath() + "/" + prevMeta.getPath() + this.suffix);
                File dir = oldFile.getParentFile();
                for (String oldName : dir.list()) {
                    if (!oldName.startsWith(oldFile.getName())) continue;
                    File unReferencedFile = new File(dir, oldName);
                    unReferencedFile.delete();
                }
            }
        }
        catch (JAXBException e) {
            throw new MetaDataRuntimeException(e);
        }
    }

    private void marshal(XmlFileMetaDataEntryThinWrapper meta, File file) {
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            Marshaller marshaller = this.context.createMarshaller();
            marshaller.marshal((Object)meta, file);
        }
        catch (JAXBException e) {
            throw new MetaDataRuntimeException(e);
        }
        this.xmlExternalRefHandler.putOutExtcontent(file);
    }

    private XmlFileMetaDataEntryThinWrapper unmarshal(File f) throws JAXBException {
        byte[] xmlRestoredExtenalContent = this.xmlExternalRefHandler.readRestoringExtContent(f);
        Unmarshaller unmarshaller = this.context.createUnmarshaller();
        return (XmlFileMetaDataEntryThinWrapper)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(xmlRestoredExtenalContent));
    }

    @Override
    public void remove(int tenantId, String path) throws MetaDataRuntimeException {
        String[] list;
        if (tenantId != this.localTenantId) {
            throw new MetaDataRuntimeException("can not remove metadata on local file store except tenantId {" + this.localTenantId + "}");
        }
        String filePath = "/" + path;
        String dirPath = this.getFileStorePath() + filePath.substring(0, filePath.lastIndexOf("/"));
        String fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
        File dir = new File(dirPath);
        if (!dir.exists()) {
            return;
        }
        for (String l : list = dir.list()) {
            File file;
            if (!l.startsWith(fileName) || (file = new File(dir, l)).delete()) continue;
            throw new MetaDataRuntimeException("\u6307\u5b9a\u306eMetaData\u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002XML\u30d5\u30a1\u30a4\u30eb\u540d=" + fileName);
        }
    }

    @Override
    public void updateConfigById(int tenantId, String id, MetaDataConfig config) {
        throw new MetaDataRuntimeException(id + "'s meta data is tenant local and overwritable only.");
    }

    @Override
    public List<MetaDataEntryInfo> getHistoryById(int tenantId, String id) {
        return Collections.emptyList();
    }

    @Override
    public void purgeById(int tenantId, String id) throws MetaDataRuntimeException {
    }

    @Override
    public List<Integer> getTenantIdsOf(String id) {
        return Collections.emptyList();
    }

    private boolean isMetaDataXml(File f) {
        int idx = f.getName().lastIndexOf(".");
        if (idx != -1) {
            String base = f.getName().substring(0, idx);
            return !base.contains(this.suffix);
        }
        return false;
    }
}

