/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.pushnotification.fcm;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.iplass.mtp.impl.http.ExponentialBackoff;
import org.iplass.mtp.impl.http.HttpClientConfig;
import org.iplass.mtp.impl.pushnotification.PushNotificationService;
import org.iplass.mtp.pushnotification.PushNotification;
import org.iplass.mtp.pushnotification.PushNotificationException;
import org.iplass.mtp.pushnotification.PushNotificationResult;
import org.iplass.mtp.pushnotification.fcm.RegistrationIdHandler;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.tenant.Tenant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FCMPushNotificationService
extends PushNotificationService {
    private static Logger logger = LoggerFactory.getLogger(FCMPushNotificationService.class);
    private String authorizationKey;
    private boolean dryRun;
    private boolean enableRetry = true;
    private RegistrationIdHandler registrationIdHandler;
    private ExponentialBackoff exponentialBackoff;
    private HttpClientConfig httpClientConfig;
    private String endpoint = "https://fcm.googleapis.com/fcm/send";
    private ObjectMapper jsonMapper;
    private Pattern conditionPattern = Pattern.compile(".*in\\s*topics.*", 2);

    @Override
    public void init(Config config) {
        super.init(config);
        this.authorizationKey = config.getValue("authorizationKey");
        if (config.getValue("dryRun") != null) {
            this.dryRun = Boolean.valueOf(config.getValue("dryRun"));
        }
        if (config.getValue("enableRetry") != null) {
            this.enableRetry = Boolean.valueOf(config.getValue("enableRetry"));
        }
        if (this.enableRetry) {
            this.exponentialBackoff = (ExponentialBackoff)config.getBean("exponentialBackoff");
            if (this.exponentialBackoff == null) {
                this.exponentialBackoff = new ExponentialBackoff();
            }
        } else {
            this.exponentialBackoff = ExponentialBackoff.NO_RETRY;
        }
        this.registrationIdHandler = (RegistrationIdHandler)config.getBean("registrationIdHandler");
        this.httpClientConfig = (HttpClientConfig)config.getBean("httpClientConfig");
        if (this.httpClientConfig == null) {
            this.httpClientConfig = new HttpClientConfig();
            this.httpClientConfig.inited(this, config);
        }
        if (config.getValue("endpoint") != null) {
            this.endpoint = config.getValue("endpoint");
        }
        this.jsonMapper = new ObjectMapper();
        this.jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.jsonMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        this.jsonMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
    }

    @Override
    public void destroy() {
        this.jsonMapper = null;
        super.destroy();
    }

    @Override
    protected PushNotificationResult pushImpl(Tenant tenant, PushNotification notification) {
        try {
            boolean isMulti = notification.getToList().size() > 1;
            long endTime = System.currentTimeMillis() + this.exponentialBackoff.getMaxElapsedTimeMillis();
            PushNotificationResult result = new PushNotificationResult();
            long[] retryAfter = new long[]{-1L};
            this.exponentialBackoff.execute(() -> {
                long currentTime = System.currentTimeMillis();
                if (retryAfter[0] > currentTime) {
                    if (retryAfter[0] > endTime) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("execution failed cause retryAfter Header value is over maxElapsedTimeMillis.");
                        }
                        result.setDetail("retryAfter", new Date(retryAfter[0]));
                        return true;
                    }
                    try {
                        Thread.sleep(retryAfter[0] - currentTime);
                    }
                    catch (Exception e) {
                        throw new PushNotificationException("FCM call thread is Interrupted.", e);
                    }
                }
                try {
                    if (isMulti) {
                        return this.multiRegistrationIdCall(notification, result, retryAfter);
                    }
                    return this.simpleCall(notification, result, retryAfter);
                }
                catch (IOException | ParseException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("can not access FCM... cause:" + e.getMessage(), e);
                    }
                    result.setDetail("lastException", e);
                    return false;
                }
            });
            return result;
        }
        catch (InterruptedException e) {
            throw new PushNotificationException("FCM call thread is Interrupted.", e);
        }
    }

    private long parseRetryAfter(HttpResponse res) {
        Header header = res.getFirstHeader("Retry-After");
        if (header == null) {
            return -1L;
        }
        String val = header.getValue();
        if (val == null) {
            return -1L;
        }
        try {
            long valLong = Long.parseLong(val);
            return System.currentTimeMillis() + valLong * 1000L;
        }
        catch (NumberFormatException valLong) {
            Date d = DateUtils.parseDate((String)val);
            if (d == null) {
                return -1L;
            }
            return d.getTime();
        }
    }

    private ResultType handleResult(Map<String, Object> res, String regId) {
        String newRegId;
        String error = (String)res.get("error");
        if (error != null) {
            if (error.equals("NotRegistered") && this.registrationIdHandler != null && regId != null) {
                this.registrationIdHandler.removeRegistrationId(regId);
            }
            if (this.isRetryableError(error)) {
                return ResultType.RETRY;
            }
            return ResultType.ERROR;
        }
        if (this.registrationIdHandler != null && regId != null && (newRegId = (String)res.get("registration_id")) != null) {
            this.registrationIdHandler.refreshRegistrationId(regId, newRegId);
        }
        return ResultType.SUCCESS;
    }

    private boolean isRetryableError(String error) {
        switch (error) {
            case "Unavailable": 
            case "InternalServerError": {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendMsg(PushNotification notification, ResHandler resHandler) throws ParseException, IOException {
        String jsonMsg = null;
        try {
            jsonMsg = this.jsonMapper.writeValueAsString(this.toMessageMap(notification));
        }
        catch (IOException e) {
            throw new PushNotificationException("can not serialize to json", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("call FCM whith message:" + jsonMsg);
        }
        int status = -1;
        CloseableHttpClient client = this.httpClientConfig.getInstance();
        HttpPost post = new HttpPost(this.endpoint);
        post.setHeader("Authorization", "key=" + this.authorizationKey);
        post.setHeader("Content-Type", "application/json");
        post.setEntity((HttpEntity)new StringEntity(jsonMsg, "UTF-8"));
        try {
            HttpResponse res = client.execute((HttpUriRequest)post);
            status = res.getStatusLine().getStatusCode();
            if (status == 401) {
                throw new PushNotificationException("can not auth.");
            }
            if (status == 400) {
                if (logger.isDebugEnabled()) {
                    logger.debug(res.getStatusLine().toString());
                    if (res.getAllHeaders() != null) {
                        for (Header h : res.getAllHeaders()) {
                            logger.debug(h.toString());
                        }
                    }
                    if (res.getEntity() != null) {
                        logger.debug(EntityUtils.toString((HttpEntity)res.getEntity(), (String)"UTF-8"));
                    }
                }
                throw new PushNotificationException("invalid json message:" + jsonMsg);
            }
            if ((status < 500 || status >= 600) && status != 200) {
                throw new PushNotificationException("FCM return unknown status:" + status);
            }
            resHandler.handle(res);
            int n = status;
            return n;
        }
        finally {
            post.releaseConnection();
        }
    }

    private boolean simpleCall(PushNotification notification, PushNotificationResult result, long[] retryAfter) throws ParseException, IOException {
        String[] content = new String[]{null};
        int status = this.sendMsg(notification, res -> {
            retryAfter[0] = this.parseRetryAfter(res);
            HttpEntity entity = res.getEntity();
            if (entity != null) {
                content[0] = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug("FCM response:status=" + status + ", content=" + content[0]);
        }
        if (status >= 500) {
            return false;
        }
        Map cmap = (Map)this.jsonMapper.readValue(content[0], Map.class);
        result.setDetails(cmap);
        ResultType rt = cmap.get("message_id") != null ? this.handleResult(cmap, null) : this.handleResult((Map)((List)cmap.get("results")).get(0), notification.getToList().get(0));
        switch (rt) {
            case ERROR: {
                return true;
            }
            case RETRY: {
                return false;
            }
            case SUCCESS: {
                result.setSuccess(true);
                return true;
            }
        }
        return false;
    }

    private boolean multiRegistrationIdCall(PushNotification notification, PushNotificationResult result, long[] retryAfter) throws ParseException, IOException {
        List orgResults = (List)result.getDetail("results");
        ArrayList<Integer> indexMap = null;
        List<String> ids = notification.getToList();
        PushNotification ntf = notification;
        if (orgResults != null) {
            indexMap = new ArrayList<Integer>();
            ids = new ArrayList<String>();
            List<String> orgList = notification.getToList();
            for (int i = 0; i < orgList.size(); ++i) {
                String error = (String)((Map)orgResults.get(i)).get("error");
                if (error == null || !this.isRetryableError(error)) continue;
                indexMap.add(i);
                ids.add(orgList.get(i));
            }
            ntf = new PushNotification();
            ntf.setToList(ids);
            ntf.setData(notification.getData());
            ntf.setNotification(notification.getNotification());
            ntf.setOptions(notification.getOptions());
        }
        String[] content = new String[]{null};
        int status = this.sendMsg(ntf, res -> {
            retryAfter[0] = this.parseRetryAfter(res);
            HttpEntity entity = res.getEntity();
            if (entity != null) {
                content[0] = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug("FCM response:status=" + status + ", content=" + content[0]);
        }
        if (status >= 500) {
            return false;
        }
        Map cmap = (Map)this.jsonMapper.readValue(content[0], Map.class);
        List rs = (List)cmap.get("results");
        boolean needRetry = false;
        for (int i = 0; i < ids.size(); ++i) {
            ResultType rt = this.handleResult((Map)rs.get(i), ids.get(i));
            if (rt != ResultType.RETRY) continue;
            needRetry = true;
        }
        if (orgResults == null) {
            result.setDetails(cmap);
            orgResults = rs;
        } else {
            int totalSuccessCount = ((Number)result.getDetail("success")).intValue();
            int totalFailureCount = ((Number)result.getDetail("failure")).intValue();
            int totalCanonicalIdsCount = ((Number)result.getDetail("canonical_ids")).intValue();
            int successCount = ((Number)cmap.get("success")).intValue();
            int canonicalIdsCount = ((Number)cmap.get("canonical_ids")).intValue();
            result.setDetail("success", totalSuccessCount += successCount);
            result.setDetail("failure", totalFailureCount -= successCount);
            result.setDetail("canonical_ids", totalCanonicalIdsCount += canonicalIdsCount);
            for (int i = 0; i < ids.size(); ++i) {
                orgResults.set((Integer)indexMap.get(i), rs.get(i));
            }
        }
        if (needRetry) {
            return false;
        }
        boolean hasError = false;
        for (int i = 0; i < orgResults.size(); ++i) {
            String error = (String)((Map)orgResults.get(i)).get("error");
            if (error == null) continue;
            hasError = true;
            break;
        }
        if (!hasError) {
            result.setSuccess(true);
        }
        return true;
    }

    private Map<String, Object> toMessageMap(PushNotification notification) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<String> toList = notification.getToList();
        if (toList.size() == 0) {
            throw new PushNotificationException("To list not specified.");
        }
        if (toList.size() == 1) {
            if (this.conditionPattern.matcher(toList.get(0)).matches()) {
                map.put("condition", toList.get(0));
            } else {
                map.put("to", toList.get(0));
            }
        } else {
            map.put("registration_ids", toList);
        }
        if (notification.getOptions() != null) {
            map.putAll(notification.getOptions());
        }
        if (notification.getData() != null && notification.getData().size() > 0) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            for (String key : notification.getData().keySet()) {
                dataMap.put(key, notification.getData().get(key));
            }
            map.put("data", dataMap);
        }
        if (notification.getNotification() != null && notification.getNotification().size() > 0) {
            HashMap<String, Object> notificationMap = new HashMap<String, Object>();
            for (String key : notification.getNotification().keySet()) {
                notificationMap.put(key, notification.getNotification().get(key));
            }
            map.put("notification", notificationMap);
        }
        if (this.dryRun) {
            map.put("dry_run", true);
        }
        return map;
    }

    static interface ResHandler {
        public void handle(HttpResponse var1) throws IOException;
    }

    private static enum ResultType {
        SUCCESS,
        RETRY,
        ERROR;

    }
}

