/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.condition.expr;

import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.Paren;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.condition.expr.OrSyntax;
import org.iplass.mtp.impl.query.condition.predicate.PredicateSyntax;

public class ParenSyntax
implements Syntax<Condition>,
QueryConstants {
    private OrSyntax or;
    private PredicateSyntax predicate;

    @Override
    public void init(SyntaxContext context) {
        this.or = context.getSyntax(OrSyntax.class);
        this.predicate = context.getSyntax(PredicateSyntax.class);
    }

    @Override
    public Condition parse(ParseContext str) throws ParseException {
        if (str.startsWith("(")) {
            int index = str.getCurrentIndex();
            try {
                str.consumeChars("(".length());
                str.consumeChars(ParseContext.WHITE_SPACES);
                Condition nested = this.or.parse(str);
                if (!str.startsWith(")")) {
                    throw new ParseException(new EvalError(") expected.", this, str));
                }
                str.consumeChars(")".length());
                str.consumeChars(ParseContext.WHITE_SPACES);
                return new Paren(nested);
            }
            catch (ParseException e) {
                str.setCurrentIndex(index);
                return this.predicate.parse(str);
            }
        }
        return this.predicate.parse(str);
    }
}

