/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.value.controlflow;

import java.util.ArrayList;
import org.iplass.mtp.entity.query.value.controlflow.Case;
import org.iplass.mtp.entity.query.value.controlflow.When;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.value.controlflow.ElseSyntax;
import org.iplass.mtp.impl.query.value.controlflow.WhenSyntax;

public class CaseSyntax
implements Syntax<Case>,
QueryConstants {
    private WhenSyntax when;
    private ElseSyntax elseClause;

    @Override
    public void init(SyntaxContext context) {
        this.when = context.getSyntax(WhenSyntax.class);
        this.elseClause = context.getSyntax(ElseSyntax.class);
    }

    @Override
    public Case parse(ParseContext str) throws ParseException {
        if (!str.equalsNextToken("CASE", ParseContext.WHITE_SPACES)) {
            throw new ParseException(new EvalError("CASE expected.", this, str));
        }
        str.consumeChars("CASE".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        Case caseClause = new Case();
        ArrayList<When> whenList = null;
        while (str.equalsNextToken("WHEN", ParseContext.WHITE_SPACES)) {
            When w = this.when.parse(str);
            if (whenList == null) {
                whenList = new ArrayList<When>();
            }
            whenList.add(w);
            str.consumeChars(ParseContext.WHITE_SPACES);
        }
        if (whenList != null) {
            caseClause.setWhen(whenList);
        }
        if (str.equalsNextToken("ELSE", ParseContext.WHITE_SPACES)) {
            caseClause.setElseClause(this.elseClause.parse(str));
            str.consumeChars(ParseContext.WHITE_SPACES);
        }
        if (!str.equalsNextToken("END", ParseContext.TOKEN_DELIMITERS)) {
            throw new ParseException(new EvalError("END expected.", this, str));
        }
        str.consumeChars("END".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        return caseClause;
    }
}

