/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.adapter.bulk;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkUpdateContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.ColumnValue;
import org.iplass.mtp.impl.rdb.adapter.bulk.DynamicColumnValue;
import org.iplass.mtp.impl.rdb.adapter.bulk.FixedExpressionColumnValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedBulkUpdateContext
implements BulkUpdateContext {
    private static final Logger logger = LoggerFactory.getLogger(PreparedBulkUpdateContext.class);
    private List<ColumnValue> keyColumnValue;
    private List<ColumnValue> updateColumnValue;
    private PreparedStatement ps;
    private int currentSize;

    @Override
    public void setContext(String tableName, List<ColumnValue> keyColumnValue, List<ColumnValue> updateColumnValue, String additionalConditionExpression, Connection con) throws SQLException {
        ColumnValue cvm;
        int i;
        this.keyColumnValue = keyColumnValue;
        this.updateColumnValue = updateColumnValue;
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(tableName);
        sql.append(" SET ");
        for (i = 0; i < updateColumnValue.size(); ++i) {
            if (i != 0) {
                sql.append(",");
            }
            cvm = updateColumnValue.get(i);
            sql.append(cvm.colName());
            sql.append("=");
            if (cvm instanceof FixedExpressionColumnValue) {
                sql.append(((FixedExpressionColumnValue)cvm).fixedValueExpression());
                continue;
            }
            if (cvm instanceof DynamicColumnValue) {
                ((DynamicColumnValue)cvm).bindExpression(sql);
                continue;
            }
            throw new IllegalArgumentException();
        }
        sql.append(" WHERE ");
        for (i = 0; i < keyColumnValue.size(); ++i) {
            if (i != 0) {
                sql.append(" AND ");
            }
            cvm = keyColumnValue.get(i);
            sql.append(cvm.colName());
            sql.append("=");
            if (cvm instanceof FixedExpressionColumnValue) {
                sql.append(((FixedExpressionColumnValue)cvm).fixedValueExpression());
                continue;
            }
            if (cvm instanceof DynamicColumnValue) {
                ((DynamicColumnValue)cvm).bindExpression(sql);
                continue;
            }
            throw new IllegalArgumentException();
        }
        if (additionalConditionExpression != null) {
            sql.append(" AND (").append(additionalConditionExpression).append(")");
        }
        this.ps = con.prepareStatement(sql.toString());
    }

    @Override
    public void add(List<Object> key, List<Object> values) throws SQLException {
        ColumnValue cvm;
        int i;
        if (this.keyColumnValue.size() != key.size()) {
            throw new IllegalArgumentException("key length not equals key col length");
        }
        if (this.updateColumnValue.size() != values.size()) {
            throw new IllegalArgumentException("values length not equals update col length");
        }
        int index = 1;
        for (i = 0; i < values.size(); ++i) {
            cvm = this.updateColumnValue.get(i);
            if (cvm instanceof FixedExpressionColumnValue) continue;
            ((DynamicColumnValue)cvm).setParameter(values.get(i), index, this.ps);
            ++index;
        }
        for (i = 0; i < key.size(); ++i) {
            cvm = this.keyColumnValue.get(i);
            if (cvm instanceof FixedExpressionColumnValue) continue;
            ((DynamicColumnValue)cvm).setParameter(key.get(i), index, this.ps);
            ++index;
        }
        this.ps.addBatch();
        ++this.currentSize;
    }

    @Override
    public void execute() throws SQLException {
        if (this.currentSize > 0) {
            this.ps.executeBatch();
            this.currentSize = 0;
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.ps != null) {
            try {
                this.ps.clearBatch();
            }
            catch (SQLException e) {
                logger.error("cant clearBatch. caluse " + e, (Throwable)e);
            }
            finally {
                this.ps.close();
            }
        }
    }

    @Override
    public int getCurrentSize() {
        return this.currentSize;
    }
}

