/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.rdb.connection.ConnectionException;
import org.iplass.mtp.impl.rdb.connection.ConnectionFactory;
import org.iplass.mtp.impl.rdb.connection.LocalTransactionConnectionWrapper;
import org.iplass.mtp.impl.rdb.connection.ResourceHolder;
import org.iplass.mtp.impl.rdb.connection.TransactionIsolationLevel;
import org.iplass.mtp.impl.transaction.LocalTransaction;
import org.iplass.mtp.impl.transaction.LocalTransactionManager;
import org.iplass.mtp.impl.transaction.TransactionService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionManager;
import org.iplass.mtp.transaction.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionFactory
extends ConnectionFactory {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConnectionFactory.class);
    private int warnLogThreshold;
    private boolean warnLogBefore;
    private boolean countSqlExecution;
    private TransactionIsolationLevel transactionIsolationLevel;
    private boolean isDefault;

    @Override
    public Connection getConnection() {
        return this.getConnection(null);
    }

    @Override
    public Connection getConnection(Function<Connection, Connection> afterGetPhysicalConnectionHandler) {
        if (this.isDefault) {
            TransactionService ts = ServiceRegistry.getRegistry().getService(TransactionService.class);
            int warnLogThreshold = this.getWarnLogThreshold();
            TransactionManager tm = ts.getTransacitonManager();
            Transaction ct = tm.currentTransaction();
            ResourceHolder rh = ResourceHolder.getResourceHolder();
            if (ct instanceof LocalTransaction) {
                LocalTransaction t = (LocalTransaction)ct;
                if (t.getStatus() == TransactionStatus.ACTIVE) {
                    if (t.getCon() == null) {
                        try {
                            if (rh == null || rh.isInUse()) {
                                t.setCon(new LocalTransactionConnectionWrapper(this.getPhysicalConnection(afterGetPhysicalConnectionHandler), true, null, warnLogThreshold, this.warnLogBefore, this.countSqlExecution));
                            } else {
                                t.setCon(new LocalTransactionConnectionWrapper(this.getHoldingConnection(rh, afterGetPhysicalConnectionHandler), true, rh, warnLogThreshold, this.warnLogBefore, this.countSqlExecution));
                            }
                        }
                        catch (SQLException e) {
                            throw new ConnectionException(e);
                        }
                    }
                    return t.getCon();
                }
                if (rh == null || rh.isInUse()) {
                    return new LocalTransactionConnectionWrapper(this.getPhysicalConnection(afterGetPhysicalConnectionHandler), false, null, warnLogThreshold, this.warnLogBefore, this.countSqlExecution);
                }
                return new LocalTransactionConnectionWrapper(this.getHoldingConnection(rh, afterGetPhysicalConnectionHandler), false, rh, warnLogThreshold, this.warnLogBefore, this.countSqlExecution);
            }
            if (tm instanceof LocalTransactionManager) {
                if (rh == null || rh.isInUse()) {
                    return new LocalTransactionConnectionWrapper(this.getPhysicalConnection(afterGetPhysicalConnectionHandler), false, null, warnLogThreshold, this.warnLogBefore, this.countSqlExecution);
                }
                return new LocalTransactionConnectionWrapper(this.getHoldingConnection(rh, afterGetPhysicalConnectionHandler), false, rh, warnLogThreshold, this.warnLogBefore, this.countSqlExecution);
            }
        }
        return new LocalTransactionConnectionWrapper(this.getPhysicalConnection(afterGetPhysicalConnectionHandler), false, null, this.warnLogThreshold, this.warnLogBefore, this.countSqlExecution);
    }

    Connection getHoldingConnection(ResourceHolder rh, Function<Connection, Connection> afterGetPhysicalConnectionHandler) {
        Connection con = rh.getConnection(this, afterGetPhysicalConnectionHandler);
        if (logger.isDebugEnabled()) {
            logger.debug("getConnection from ResourceHolder:" + con);
        }
        return con;
    }

    Connection getPhysicalConnection(Function<Connection, Connection> afterGetPhysicalConnectionHandler) {
        Connection con = this.getConnectionInternal();
        if (logger.isDebugEnabled()) {
            logger.debug("create physical connection:" + con);
        }
        if (this.transactionIsolationLevel != null) {
            try {
                con.setTransactionIsolation(this.transactionIsolationLevel.sqlIntValue());
            }
            catch (SQLException e) {
                throw new ConnectionException("Can not setTransactionIsolation level.", e);
            }
        }
        if (afterGetPhysicalConnectionHandler != null) {
            con = afterGetPhysicalConnectionHandler.apply(con);
        }
        return con;
    }

    protected abstract Connection getConnectionInternal();

    @Override
    public void init(Config config) {
        String serviceName = config.getServiceName();
        if (serviceName.equals(ConnectionFactory.class.getName())) {
            this.isDefault = true;
        }
        this.warnLogThreshold = config.getValue("warnLogThreshold", Integer.TYPE, 0);
        this.warnLogBefore = config.getValue("warnLogBefore", Boolean.TYPE, true);
        this.countSqlExecution = config.getValue("countSqlExecution", Boolean.TYPE, true);
        this.transactionIsolationLevel = config.getValue("transactionIsolationLevel", TransactionIsolationLevel.class);
    }

    @Override
    public boolean isWarnLogBefore() {
        return this.warnLogBefore;
    }

    @Override
    public int getWarnLogThreshold() {
        return this.warnLogThreshold;
    }

    @Override
    public TransactionIsolationLevel getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    @Override
    public boolean isCountSqlExecution() {
        return this.countSqlExecution;
    }

    @Override
    public AtomicInteger getCounterOfSqlExecution() {
        if (this.countSqlExecution) {
            ExecuteContext ec = ExecuteContext.getCurrentContext();
            AtomicInteger sqlCount = (AtomicInteger)ec.getAttribute("mtp.rdb.log.sqlCount");
            if (sqlCount == null) {
                sqlCount = new AtomicInteger();
                ec.setAttribute("mtp.rdb.log.sqlCount", sqlCount, true);
            }
            return sqlCount;
        }
        return null;
    }
}

