/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.connection;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.rdb.connection.AdditionalWarnLogInfo;
import org.iplass.mtp.impl.rdb.connection.ConnectionWrapper;
import org.iplass.mtp.impl.rdb.connection.ResultSetWrapper;
import org.iplass.mtp.impl.rdb.connection.SQLExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementWrapper
implements Statement {
    private static Logger logger = LoggerFactory.getLogger(StatementWrapper.class);
    private Statement wrapped;
    private ConnectionWrapper con;
    protected int warnLogThreshold;
    protected boolean warnLogBefore;
    protected boolean countSqlExecution;
    protected AdditionalWarnLogInfo additionalWarnLogInfo;
    protected AtomicInteger sqlCount;

    StatementWrapper(Statement wrapped, ConnectionWrapper con, int warnLogThreshold, boolean warnLogBefore, boolean countSqlExecution) {
        this.wrapped = wrapped;
        this.con = con;
        this.warnLogThreshold = warnLogThreshold;
        this.warnLogBefore = warnLogBefore;
        this.countSqlExecution = countSqlExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withLog(String method, String sql, SQLExecution<T> s) throws SQLException {
        if (this.countSqlExecution) {
            if (this.sqlCount == null) {
                ExecuteContext ec = ExecuteContext.getCurrentContext();
                this.sqlCount = (AtomicInteger)ec.getAttribute("mtp.rdb.log.sqlCount");
            }
            if (this.sqlCount != null) {
                this.sqlCount.incrementAndGet();
            }
        }
        long start = System.currentTimeMillis();
        try {
            if (this.warnLogBefore && this.additionalWarnLogInfo != null && this.additionalWarnLogInfo.logBefore()) {
                logger.warn(this.logStr(method, sql, -1L));
            }
            T t = s.run();
            return t;
        }
        finally {
            long queryTime = System.currentTimeMillis() - start;
            if (this.warnLogThreshold > 0 && queryTime > (long)this.warnLogThreshold) {
                if (logger.isWarnEnabled()) {
                    logger.warn(this.logStr(method, sql, queryTime));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug(this.logStr(method, sql, queryTime));
            }
        }
    }

    private String logStr(String method, String sql, long queryTime) {
        StringBuilder log = new StringBuilder();
        log.append(method);
        if (queryTime > -1L) {
            log.append(" time= ");
            log.append(queryTime);
            log.append(" ms.");
        }
        if (sql != null) {
            log.append(" sql=");
            log.append(sql);
        }
        if (this.additionalWarnLogInfo != null) {
            log.append(" -- ");
            log.append(this.additionalWarnLogInfo);
        }
        return log.toString();
    }

    public AdditionalWarnLogInfo getAdditionalWarnLogInfo() {
        return this.additionalWarnLogInfo;
    }

    public void setAdditionalWarnLogInfo(AdditionalWarnLogInfo additionalWarnLogInfo) {
        this.additionalWarnLogInfo = additionalWarnLogInfo;
    }

    @Override
    public final void addBatch(String sql) throws SQLException {
        logger.debug("addBatch: {}", (Object)sql);
        this.wrapped.addBatch(sql);
    }

    @Override
    public final void cancel() throws SQLException {
        this.wrapped.cancel();
    }

    @Override
    public final void clearBatch() throws SQLException {
        this.wrapped.clearBatch();
    }

    @Override
    public final void clearWarnings() throws SQLException {
        this.wrapped.clearWarnings();
    }

    @Override
    public final void close() throws SQLException {
        this.wrapped.close();
    }

    @Override
    public final boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.withLog("execute", sql, () -> this.wrapped.execute(sql, autoGeneratedKeys));
    }

    @Override
    public final boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.withLog("execute", sql, () -> this.wrapped.execute(sql, columnIndexes));
    }

    @Override
    public final boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.withLog("execute", sql, () -> this.wrapped.execute(sql, columnNames));
    }

    @Override
    public final boolean execute(String sql) throws SQLException {
        return this.withLog("execute", sql, () -> this.wrapped.execute(sql));
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.withLog("batch", null, () -> this.wrapped.executeBatch());
    }

    @Override
    public final ResultSet executeQuery(String sql) throws SQLException {
        return this.withLog("query", sql, () -> new ResultSetWrapper(this.wrapped.executeQuery(sql), this));
    }

    @Override
    public final int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.withLog("update", sql, () -> this.wrapped.executeUpdate(sql, autoGeneratedKeys));
    }

    @Override
    public final int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.withLog("update", sql, () -> this.wrapped.executeUpdate(sql, columnIndexes));
    }

    @Override
    public final int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.withLog("update", sql, () -> this.wrapped.executeUpdate(sql, columnNames));
    }

    @Override
    public final int executeUpdate(String sql) throws SQLException {
        return this.withLog("update", sql, () -> this.wrapped.executeUpdate(sql));
    }

    @Override
    public final Connection getConnection() throws SQLException {
        return this.con;
    }

    @Override
    public final int getFetchDirection() throws SQLException {
        return this.wrapped.getFetchDirection();
    }

    @Override
    public final int getFetchSize() throws SQLException {
        return this.wrapped.getFetchSize();
    }

    @Override
    public final ResultSet getGeneratedKeys() throws SQLException {
        return new ResultSetWrapper(this.wrapped.getGeneratedKeys(), this);
    }

    @Override
    public final int getMaxFieldSize() throws SQLException {
        return this.wrapped.getMaxFieldSize();
    }

    @Override
    public final int getMaxRows() throws SQLException {
        return this.wrapped.getMaxRows();
    }

    @Override
    public final boolean getMoreResults() throws SQLException {
        return this.wrapped.getMoreResults();
    }

    @Override
    public final boolean getMoreResults(int current) throws SQLException {
        return this.wrapped.getMoreResults(current);
    }

    @Override
    public final int getQueryTimeout() throws SQLException {
        return this.wrapped.getQueryTimeout();
    }

    @Override
    public final ResultSet getResultSet() throws SQLException {
        return new ResultSetWrapper(this.wrapped.getResultSet(), this);
    }

    @Override
    public final int getResultSetConcurrency() throws SQLException {
        return this.wrapped.getResultSetConcurrency();
    }

    @Override
    public final int getResultSetHoldability() throws SQLException {
        return this.wrapped.getResultSetHoldability();
    }

    @Override
    public final int getResultSetType() throws SQLException {
        return this.wrapped.getResultSetType();
    }

    @Override
    public final int getUpdateCount() throws SQLException {
        return this.wrapped.getUpdateCount();
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        return this.wrapped.getWarnings();
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.wrapped.isClosed();
    }

    @Override
    public final boolean isPoolable() throws SQLException {
        return this.wrapped.isPoolable();
    }

    @Override
    public final boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.wrapped.isWrapperFor(iface);
    }

    @Override
    public final void setCursorName(String name) throws SQLException {
        this.wrapped.setCursorName(name);
    }

    @Override
    public final void setEscapeProcessing(boolean enable) throws SQLException {
        this.wrapped.setEscapeProcessing(enable);
    }

    @Override
    public final void setFetchDirection(int direction) throws SQLException {
        this.wrapped.setFetchDirection(direction);
    }

    @Override
    public final void setFetchSize(int rows) throws SQLException {
        this.wrapped.setFetchSize(rows);
    }

    @Override
    public final void setMaxFieldSize(int max) throws SQLException {
        this.wrapped.setMaxFieldSize(max);
    }

    @Override
    public final void setMaxRows(int max) throws SQLException {
        this.wrapped.setMaxRows(max);
    }

    @Override
    public final void setPoolable(boolean poolable) throws SQLException {
        this.wrapped.setPoolable(poolable);
    }

    @Override
    public final void setQueryTimeout(int seconds) throws SQLException {
        this.wrapped.setQueryTimeout(seconds);
    }

    @Override
    public final <T> T unwrap(Class<T> iface) throws SQLException {
        return this.wrapped.unwrap(iface);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.wrapped.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.wrapped.isCloseOnCompletion();
    }
}

