/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.oracle;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.iplass.mtp.entity.query.GroupBy;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.value.aggregate.Aggregate;
import org.iplass.mtp.entity.query.value.aggregate.Median;
import org.iplass.mtp.entity.query.value.aggregate.Mode;
import org.iplass.mtp.impl.i18n.I18nService;
import org.iplass.mtp.impl.rdb.adapter.HintPlace;
import org.iplass.mtp.impl.rdb.adapter.MultiInsertContext;
import org.iplass.mtp.impl.rdb.adapter.MultiTableUpdateMethod;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UnsupportedDataTypeException;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkDeleteContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkInsertContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkUpdateContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.InOperatorBulkDeleteContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.PreparedBulkInsertContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.PreparedBulkUpdateContext;
import org.iplass.mtp.impl.rdb.adapter.function.DynamicTypedFunctionAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.StaticTypedFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.CurrentDateFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.CurrentDateTimeFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.CurrentTimeFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.ExtractDateFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.LocalTimeFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.RoundTruncFunctionAdapter;
import org.iplass.mtp.impl.rdb.oracle.OracleMultiInsertContext;
import org.iplass.mtp.impl.rdb.oracle.function.OracleDateAddFunctionAdapter;
import org.iplass.mtp.impl.rdb.oracle.function.OracleDateDiffFunctionAdapter;
import org.iplass.mtp.spi.ServiceRegistry;

public class OracleRdbAdapter
extends RdbAdapter {
    private static final String[] optimizerHintBracket = new String[]{"/*+", "*/"};
    private int lockTimeout = 0;
    private String timestampFunction = "CURRENT_TIMESTAMP(3)";
    private String addMonthsFunction = "ADD_MONTHS";
    private String monthsBetweenFunction = "MONTHS_BETWEEN";
    private boolean isUseSubQueryForIndexJoin = true;
    private String optimizerHint = "FIRST_ROWS(100)";
    private boolean enableInPartitioning = false;
    private boolean escapeFullwidthWildcard;
    private boolean enableBindHint = true;
    private boolean alwaysBind = true;
    private int batchSize = 100;
    private int thresholdCountOfUsePrepareStatement = 50;
    private int maxFetchSize = 100;
    private int defaultQueryTimeout;
    private int defaultFetchSize;
    private boolean useFetchFirstClause;
    private static final String DATE_MIN = "-47120101000000000";
    private static final String DATE_MAX = "99991231235959999";
    long dateMin;
    long dateMax;
    private static final String[] CAST_VARCHAR = new String[]{"CAST(", " AS VARCHAR2(4000))"};
    private static final String[] CAST_BIGINT = new String[]{"CAST(", " AS NUMBER)"};
    private static final String[] CAST_DECIMAL = new String[]{"CAST(", " AS NUMBER)"};
    private static final String[] CAST_DATE = new String[]{"TRUNC(CAST(", " AS DATE))"};
    private static final String[] CAST_DOUBLE = new String[]{"CAST(", " AS BINARY_DOUBLE)"};
    private static final String[] CAST_TIME = new String[]{"TO_TIMESTAMP(CONCAT('1970-01-01 ',TO_CHAR(CAST(", " AS TIMESTAMP),'HH24:MI:SS')),'YYYY-MM-DD HH24:MI:SS.FF')"};
    private static final String[] CAST_TIMESTAMP = new String[]{"CAST(", " AS TIMESTAMP)"};

    public OracleRdbAdapter() {
        this.addFunction(new StaticTypedFunctionAdapter("CHAR_LENGTH", "LENGTH", Long.class));
        this.addFunction(new StaticTypedFunctionAdapter("INSTR", Long.class));
        this.addFunction(new StaticTypedFunctionAdapter("CONCAT", String.class));
        this.addFunction(new StaticTypedFunctionAdapter("SUBSTR", String.class));
        this.addFunction(new StaticTypedFunctionAdapter("REPLACE", String.class));
        this.addFunction(new DynamicTypedFunctionAdapter("MOD", new int[]{0, 1}));
        this.addFunction(new StaticTypedFunctionAdapter("SQRT", Double.class));
        this.addFunction(new DynamicTypedFunctionAdapter("POWER", new int[]{0, 1}));
        this.addFunction(new DynamicTypedFunctionAdapter("ABS", new int[]{0}));
        this.addFunction(new StaticTypedFunctionAdapter("CEIL", Long.class));
        this.addFunction(new StaticTypedFunctionAdapter("FLOOR", Long.class));
        this.addFunction(new RoundTruncFunctionAdapter("ROUND", "ROUND"));
        this.addFunction(new RoundTruncFunctionAdapter("TRUNCATE", "TRUNC"));
        this.addFunction(new StaticTypedFunctionAdapter("UPPER", String.class));
        this.addFunction(new StaticTypedFunctionAdapter("LOWER", String.class));
        this.addFunction(new ExtractDateFunctionAdapter("SECOND"));
        this.addFunction(new ExtractDateFunctionAdapter("MINUTE"));
        this.addFunction(new ExtractDateFunctionAdapter("HOUR"));
        this.addFunction(new ExtractDateFunctionAdapter("DAY"));
        this.addFunction(new ExtractDateFunctionAdapter("MONTH"));
        this.addFunction(new ExtractDateFunctionAdapter("YEAR"));
        this.addFunction(new OracleDateAddFunctionAdapter());
        this.addFunction(new OracleDateDiffFunctionAdapter());
        this.addFunction(new CurrentDateFunctionAdapter());
        this.addFunction(new CurrentTimeFunctionAdapter());
        this.addFunction(new CurrentDateTimeFunctionAdapter());
        this.addFunction(new LocalTimeFunctionAdapter());
        DateFormatSymbols symbols = new DateFormatSymbols();
        symbols.setEras(new String[]{"-", ""});
        I18nService i18n = ServiceRegistry.getRegistry().getService(I18nService.class);
        SimpleDateFormat sdfMin = new SimpleDateFormat("GyyyyMMddHHmmssSSS", symbols);
        sdfMin.setTimeZone(i18n.getTimezone());
        SimpleDateFormat sdfMax = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        sdfMax.setTimeZone(i18n.getTimezone());
        try {
            this.dateMin = sdfMin.parse(DATE_MIN).getTime();
            this.dateMax = sdfMax.parse(DATE_MAX).getTime();
        }
        catch (ParseException e) {
            throw new UnsupportedDataTypeException(e);
        }
    }

    public boolean isUseFetchFirstClause() {
        return this.useFetchFirstClause;
    }

    public void setUseFetchFirstClause(boolean useFetchFirstClause) {
        this.useFetchFirstClause = useFetchFirstClause;
    }

    @Override
    public int getDefaultQueryTimeout() {
        return this.defaultQueryTimeout;
    }

    public void setDefaultQueryTimeout(int defaultQueryTimeout) {
        this.defaultQueryTimeout = defaultQueryTimeout;
    }

    @Override
    public int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    public void setDefaultFetchSize(int defaultFetchSize) {
        this.defaultFetchSize = defaultFetchSize;
    }

    @Override
    public int getMaxFetchSize() {
        return this.maxFetchSize;
    }

    public void setMaxFetchSize(int maxFetchSize) {
        this.maxFetchSize = maxFetchSize;
    }

    public boolean isEscapeFullwidthWildcard() {
        return this.escapeFullwidthWildcard;
    }

    public void setEscapeFullwidthWildcard(boolean escapeFullwidthWildcard) {
        this.escapeFullwidthWildcard = escapeFullwidthWildcard;
    }

    @Override
    public HintPlace getOptimizerHintPlace() {
        return HintPlace.AFTER_SELECT;
    }

    @Override
    public String[] getOptimizerHintBracket() {
        return optimizerHintBracket;
    }

    @Override
    public String getOptimizerHint() {
        return this.optimizerHint;
    }

    public void setOptimizerHint(String optimizerHint) {
        this.optimizerHint = optimizerHint;
    }

    public String getAddMonthsFunction() {
        return this.addMonthsFunction;
    }

    public void setAddMonthsFunction(String addMonthsFunction) {
        this.addMonthsFunction = addMonthsFunction;
    }

    public String getMonthsBetweenFunction() {
        return this.monthsBetweenFunction;
    }

    public void setMonthsBetweenFunction(String monthsBetweenFunction) {
        this.monthsBetweenFunction = monthsBetweenFunction;
    }

    public String getTimestampFunction() {
        return this.timestampFunction;
    }

    public void setTimestampFunction(String timestampFunction) {
        this.timestampFunction = timestampFunction;
    }

    public void setLockTimeout(int lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    public int getLockTimeout() {
        return this.lockTimeout;
    }

    private void checkDateRange(java.util.Date date) {
        long time;
        if (date != null && (this.dateMin > (time = date.getTime()) || this.dateMax < time)) {
            throw new UnsupportedDataTypeException("out of range Date:" + date);
        }
    }

    @Override
    public String toDateExpression(Date date) {
        this.checkDateRange(date);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
        return "TO_DATE('" + fmt.format(date) + "','YYYY-MM-DD')";
    }

    @Override
    public String toTimeExpression(Time time) {
        this.checkDateRange(time);
        SimpleDateFormat fmt = new SimpleDateFormat("HH:mm:ss");
        return "TO_TIMESTAMP('1970-01-01 " + fmt.format(time) + "','YYYY-MM-DD HH24:MI:SS.FF')";
    }

    @Override
    public String toTimeStampExpression(Timestamp date) {
        this.checkDateRange(date);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return "TO_TIMESTAMP('" + fmt.format(date) + "','YYYY-MM-DD HH24:MI:SS.FF')";
    }

    @Override
    public String systimestamp() {
        return this.timestampFunction;
    }

    @Override
    public String[] castExp(int sqlType, Integer lengthOrPrecision, Integer scale) {
        switch (sqlType) {
            case 12: {
                if (lengthOrPrecision != null) {
                    return new String[]{"CAST(", " AS VARCHAR2(" + lengthOrPrecision + " CHAR))"};
                }
                return CAST_VARCHAR;
            }
            case -5: {
                return CAST_BIGINT;
            }
            case 3: {
                if (lengthOrPrecision == null) {
                    if (scale == null) {
                        return CAST_DECIMAL;
                    }
                    return new String[]{"CAST(", " AS NUMBER(*," + scale + "))"};
                }
                if (scale == null) {
                    return new String[]{"CAST(", " AS NUMBER(" + lengthOrPrecision + ",0))"};
                }
                return new String[]{"CAST(", " AS NUMBER(" + lengthOrPrecision + "," + scale + "))"};
            }
            case 91: {
                return CAST_DATE;
            }
            case 8: {
                return CAST_DOUBLE;
            }
            case 92: {
                return CAST_TIME;
            }
            case 93: {
                return CAST_TIMESTAMP;
            }
        }
        return null;
    }

    @Override
    public CharSequence cast(int fromSqlType, int toSqlType, CharSequence valExpr, Integer lengthOrPrecision, Integer scale) {
        switch (toSqlType) {
            case 91: {
                if (fromSqlType != 12) break;
                return "TO_DATE(" + valExpr + ",'YYYY-MM-DD')";
            }
            case 92: {
                if (fromSqlType != 12) break;
                return "TO_TIMESTAMP(CONCAT('1970-01-01 '," + valExpr + "),'YYYY-MM-DD HH24:MI:SS.FF')";
            }
            case 93: {
                if (fromSqlType != 12) break;
                return "TO_TIMESTAMP(" + valExpr + ",'YYYY-MM-DD HH24:MI:SS.FF')";
            }
            case 12: {
                if (fromSqlType == 91) {
                    return "TO_CHAR(" + valExpr + ",'YYYY-MM-DD')";
                }
                if (fromSqlType == 92) {
                    return "TO_CHAR(" + valExpr + ",'HH24:MI:SS')";
                }
                if (fromSqlType != 93) break;
                return "TO_CHAR(" + valExpr + ",'YYYY-MM-DD HH24:MI:SS.FF')";
            }
        }
        return super.cast(fromSqlType, toSqlType, valExpr, lengthOrPrecision, scale);
    }

    @Override
    public MultiInsertContext createMultiInsertContext(Statement stmt) {
        return new OracleMultiInsertContext(stmt);
    }

    @Override
    protected String getDataTypeOf(int sqlType, Integer lengthOrPrecision, Integer scale) {
        switch (sqlType) {
            case 12: {
                if (lengthOrPrecision == null) {
                    return "VARCHAR2(4000)";
                }
                return "VARCHAR2(" + lengthOrPrecision + " CHAR)";
            }
            case -5: {
                return "NUMBER";
            }
            case 3: {
                if (lengthOrPrecision == null) {
                    if (scale == null) {
                        return "NUMBER";
                    }
                    return "NUMBER(*," + scale + ")";
                }
                if (scale == null) {
                    return "NUMBER(" + lengthOrPrecision + ")";
                }
                return "NUMBER(" + lengthOrPrecision + "," + scale + ")";
            }
            case 91: {
                return "DATE";
            }
            case 8: {
                return "BINARY_DOUBLE";
            }
            case 92: 
            case 93: {
                return "TIMESTAMP";
            }
        }
        return null;
    }

    @Override
    public String dual() {
        return "FROM DUAL";
    }

    @Override
    public String rowLockExpression() {
        if (this.lockTimeout == 0) {
            return "FOR UPDATE NOWAIT";
        }
        if (this.lockTimeout > 0) {
            return "FOR UPDATE WAIT " + this.lockTimeout;
        }
        return "FOR UPDATE";
    }

    @Override
    public String toLimitSql(String selectSql, int limitCount, int offset, boolean asBind) {
        if (this.useFetchFirstClause) {
            if (asBind) {
                StringBuilder sb = new StringBuilder();
                sb.append(selectSql);
                sb.append(" OFFSET ? ROWS FETCH FIRST ? ROWS ONLY");
                return sb.toString();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(selectSql);
            sb.append(" OFFSET ");
            sb.append(offset);
            sb.append(" ROWS FETCH FIRST ");
            sb.append(limitCount);
            sb.append(" ROWS ONLY");
            return sb.toString();
        }
        if (asBind) {
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT * FROM (SELECT A.*,ROWNUM RN FROM (");
            sb.append(selectSql);
            sb.append(") A) WHERE RN BETWEEN ? AND ? ORDER BY RN");
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM (SELECT A.*,ROWNUM RN FROM (");
        sb.append(selectSql);
        sb.append(") A) WHERE RN BETWEEN ");
        sb.append(offset + 1);
        sb.append(" AND ");
        sb.append(offset + limitCount);
        sb.append(" ORDER BY RN");
        return sb.toString();
    }

    @Override
    public Object[] toLimitSqlBindValue(int limitCount, int offset) {
        if (this.useFetchFirstClause) {
            return new Integer[]{offset, limitCount};
        }
        return new Integer[]{offset + 1, offset + limitCount};
    }

    @Override
    public boolean isDuplicateValueException(SQLException e) {
        if (e.getErrorCode() == 1) {
            return true;
        }
        return e instanceof BatchUpdateException && e.getMessage() != null && e.getMessage().contains("ORA-00001");
    }

    @Override
    public boolean isDeadLock(SQLException e) {
        return e.getErrorCode() == 60;
    }

    @Override
    public boolean isLockFailed(SQLException e) {
        return e.getErrorCode() == 54 || e.getErrorCode() == 30006;
    }

    @Override
    public boolean isCastFailed(SQLException e) {
        return e.getErrorCode() == 1722 || e.getErrorCode() >= 1830 && e.getErrorCode() <= 1865;
    }

    @Override
    public String addDate(String dateExpression, int day) {
        String ret = dateExpression + "+INTERVAL '" + day + "' DAY";
        if (day >= 10000) {
            ret = ret + "(5)";
        } else if (day >= 1000) {
            ret = ret + "(4)";
        } else if (day >= 100) {
            ret = ret + "(3)";
        }
        return ret;
    }

    @Override
    public String checkStatusQuery() {
        return "SELECT 1 FROM DUAL";
    }

    @Override
    public String escape() {
        return "ESCAPE '\\'";
    }

    @Override
    public String tableAlias(String selectSql) {
        return selectSql;
    }

    @Override
    public boolean isSupportGroupingExtention(GroupBy.RollType rollType) {
        return true;
    }

    @Override
    public String rollUpStart(GroupBy.RollType rollType) {
        switch (rollType) {
            case ROLLUP: {
                return " ROLLUP(";
            }
            case CUBE: {
                return " CUBE(";
            }
        }
        return "";
    }

    @Override
    public String rollUpEnd(GroupBy.RollType rollType) {
        if (rollType != null) {
            return ") ";
        }
        return "";
    }

    @Override
    public String seqNextSelectSql(String sequenceName, int tenantId, String entityDefId) {
        return "SELECT " + sequenceName + ".NEXTVAL FROM DUAL";
    }

    @Override
    public String likePattern(String str) {
        if (str == null) {
            return null;
        }
        boolean needSanitaizing = false;
        char current = '\u0000';
        for (int i = 0; i < str.length(); ++i) {
            current = str.charAt(i);
            switch (current) {
                case '\uff05': 
                case '\uff3f': {
                    if (!this.escapeFullwidthWildcard) break;
                    needSanitaizing = true;
                    break;
                }
            }
            if (needSanitaizing) break;
        }
        if (!needSanitaizing) {
            return str;
        }
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            current = str.charAt(i);
            switch (current) {
                case '\uff05': 
                case '\uff3f': {
                    if (!this.escapeFullwidthWildcard) break;
                    buff.append('\\');
                    break;
                }
            }
            buff.append(current);
        }
        return buff.toString();
    }

    @Override
    public String initBlob() {
        return "EMPTY_BLOB()";
    }

    @Override
    public boolean isUseSubQueryForIndexJoin() {
        return this.isUseSubQueryForIndexJoin;
    }

    public void setUseSubQueryForIndexJoin(boolean isUseSubQueryForIndexJoin) {
        this.isUseSubQueryForIndexJoin = isUseSubQueryForIndexJoin;
    }

    @Override
    public void appendSortSpecExpression(StringBuilder sb, CharSequence sortValue, SortSpec.SortType sortType, SortSpec.NullOrderingSpec nullOrderingSpec) {
        sb.append(sortValue);
        if (sortType != null) {
            switch (sortType) {
                case ASC: {
                    sb.append(" ASC");
                    break;
                }
                case DESC: {
                    sb.append(" DESC");
                    break;
                }
            }
        }
        if (nullOrderingSpec != null) {
            switch (nullOrderingSpec) {
                case FIRST: {
                    sb.append(" NULLS FIRST");
                    break;
                }
                case LAST: {
                    sb.append(" NULLS LAST");
                    break;
                }
            }
        }
    }

    @Override
    public String[] convertTZ(String to) {
        String[] ret = new String[]{"CAST(FROM_TZ(", ",SESSIONTIMEZONE) AT TIME ZONE '" + to + "' AS TIMESTAMP)"};
        return ret;
    }

    @Override
    public boolean isEnableInPartitioning() {
        return this.enableInPartitioning;
    }

    public void setEnableInPartitioning(boolean enableInPartitioning) {
        this.enableInPartitioning = enableInPartitioning;
    }

    @Override
    public int getInPartitioningSize() {
        return 1000;
    }

    @Override
    public String deleteTemporaryTable(String tableName) {
        return "DELETE FROM " + tableName;
    }

    @Override
    public boolean isSupportGlobalTemporaryTable() {
        return true;
    }

    @Override
    public String createLocalTemporaryTable(String tableName, String baseTableName, String[] baseColumnName) {
        return null;
    }

    @Override
    public boolean isSupportAutoClearTemporaryTableWhenCommit() {
        return true;
    }

    @Override
    public boolean isSupportGroupingExtentionWithOrderBy() {
        return true;
    }

    @Override
    public boolean isSupportGroupingExtention() {
        return true;
    }

    @Override
    public boolean isEnableBindHint() {
        return this.enableBindHint;
    }

    public void setEnableBindHint(boolean enableBindHint) {
        this.enableBindHint = enableBindHint;
    }

    @Override
    public String aggregateFunctionName(Aggregate agg) {
        if (agg instanceof Mode) {
            return "STATS_MODE";
        }
        if (agg instanceof Median) {
            return "MEDIAN";
        }
        return super.aggregateFunctionName(agg);
    }

    @Override
    public boolean isAlwaysBind() {
        return this.alwaysBind;
    }

    public void setAlwaysBind(boolean alwaysBind) {
        this.alwaysBind = alwaysBind;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public int getThresholdCountOfUsePrepareStatement() {
        return this.thresholdCountOfUsePrepareStatement;
    }

    public void setThresholdCountOfUsePrepareStatement(int thresholdCountOfUsePrepareStatement) {
        this.thresholdCountOfUsePrepareStatement = thresholdCountOfUsePrepareStatement;
    }

    @Override
    public BulkInsertContext createBulkInsertContext() {
        return new PreparedBulkInsertContext();
    }

    @Override
    public BulkUpdateContext createBulkUpdateContext() {
        return new PreparedBulkUpdateContext();
    }

    @Override
    public BulkDeleteContext createBulkDeleteContext() {
        return new InOperatorBulkDeleteContext();
    }

    @Override
    public MultiTableUpdateMethod getMultiTableUpdateMethod() {
        return MultiTableUpdateMethod.NO_SUPPORT;
    }

    @Override
    public ResultSet getTableNames(String tableNamePattern, Connection con) throws SQLException {
        DatabaseMetaData dbMeta = con.getMetaData();
        return dbMeta.getTables(null, dbMeta.getUserName().toUpperCase(), tableNamePattern, null);
    }

    @Override
    public boolean isSupportWindowFunction() {
        return true;
    }

    @Override
    public boolean isSupportOptimizerHint() {
        return true;
    }

    @Override
    public boolean isSupportTableHint() {
        return false;
    }

    @Override
    public String[] getTableHintBracket() {
        return null;
    }
}

