/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.sqlserver;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.iplass.mtp.entity.query.GroupBy;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.value.aggregate.Aggregate;
import org.iplass.mtp.entity.query.value.aggregate.StdDevPop;
import org.iplass.mtp.entity.query.value.aggregate.StdDevSamp;
import org.iplass.mtp.entity.query.value.aggregate.VarPop;
import org.iplass.mtp.entity.query.value.aggregate.VarSamp;
import org.iplass.mtp.impl.i18n.I18nService;
import org.iplass.mtp.impl.rdb.adapter.HintPlace;
import org.iplass.mtp.impl.rdb.adapter.MultiInsertContext;
import org.iplass.mtp.impl.rdb.adapter.MultiTableUpdateMethod;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UnsupportedDataTypeException;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkDeleteContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkInsertContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkUpdateContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.OrOperatorBulkDeleteContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.PreparedBulkInsertContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.PreparedBulkUpdateContext;
import org.iplass.mtp.impl.rdb.adapter.function.DynamicTypedFunctionAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.StaticTypedFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.CurrentDateFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.CurrentDateTimeFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.CurrentTimeFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.LocalTimeFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.RoundTruncFunctionAdapter;
import org.iplass.mtp.impl.rdb.sqlserver.SqlServerMultiInsertContext;
import org.iplass.mtp.impl.rdb.sqlserver.function.SqlServerDateAddFunctionAdapter;
import org.iplass.mtp.impl.rdb.sqlserver.function.SqlServerDateDiffFunctionAdapter;
import org.iplass.mtp.impl.rdb.sqlserver.function.SqlServerExtractDateFunctionAdapter;
import org.iplass.mtp.impl.rdb.sqlserver.function.SqlServerInstrFunctionAdapter;
import org.iplass.mtp.impl.rdb.sqlserver.function.SqlServerModFunctionAdapter;
import org.iplass.mtp.impl.rdb.sqlserver.function.SqlServerSubstrFunctionAdapter;
import org.iplass.mtp.spi.ServiceRegistry;

public class SqlServerRdbAdapter
extends RdbAdapter {
    private static final String[] optimizerHintBracket = new String[]{"OPTION (", ")"};
    private int lockTimeout = 0;
    private String timestampFunction = "GETDATE()";
    private String addMonthsFunction = "DATEADD";
    private String monthsBetweenFunction = "DATEDIFF";
    private boolean isUseSubQueryForIndexJoin = true;
    private String optimizerHint = "FAST 100";
    private boolean enableBindHint = false;
    private boolean alwaysBind = false;
    private int batchSize = 100;
    private int thresholdCountOfUsePrepareStatement = 50;
    private int maxFetchSize = 100;
    private int defaultQueryTimeout;
    private int defaultFetchSize;
    private static final String DATE_MIN = "17530101000000000";
    private static final String DATE_MAX = "99991231235959999";
    long dateMin;
    long dateMax;
    private static final String[] CAST_VARCHAR = new String[]{"CAST(", " AS NVARCHAR(4000))"};
    private static final String[] CAST_BIGINT = new String[]{"CAST(", " AS BIGINT)"};
    private static final String[] CAST_DECIMAL = new String[]{"CAST(", " AS NUMERIC(38))"};
    private static final String[] CAST_DATE = new String[]{"CAST(CAST(", " AS DATETIME2) AS DATE)"};
    private static final String[] CAST_DOUBLE = new String[]{"CAST(", " AS FLOAT)"};
    private static final String[] CAST_TIME = new String[]{"CONVERT(DATETIME2, CONCAT('1970-01-01 ',FORMAT(CAST(", " AS DATETIME2),'HH:mm:ss')), 20)"};
    private static final String[] CAST_TIMESTAMP = new String[]{"CAST(", " AS DATETIME2)"};

    public SqlServerRdbAdapter() {
        this.addFunction(new StaticTypedFunctionAdapter("CHAR_LENGTH", "LEN", Long.class));
        this.addFunction(new SqlServerInstrFunctionAdapter("INSTR"));
        this.addFunction(new StaticTypedFunctionAdapter("CONCAT", String.class));
        this.addFunction(new SqlServerSubstrFunctionAdapter("SUBSTR"));
        this.addFunction(new StaticTypedFunctionAdapter("REPLACE", "REPLACE", String.class));
        this.addFunction(new SqlServerModFunctionAdapter("MOD"));
        this.addFunction(new StaticTypedFunctionAdapter("SQRT", Double.class));
        this.addFunction(new DynamicTypedFunctionAdapter("POWER", new int[]{0, 1}));
        this.addFunction(new DynamicTypedFunctionAdapter("ABS", new int[]{0}));
        this.addFunction(new StaticTypedFunctionAdapter("CEIL", "CEILING", Long.class));
        this.addFunction(new StaticTypedFunctionAdapter("FLOOR", Long.class));
        this.addFunction(new RoundTruncFunctionAdapter("ROUND", "ROUND"));
        this.addFunction(new RoundTruncFunctionAdapter("TRUNCATE", "ROUND"));
        this.addFunction(new StaticTypedFunctionAdapter("UPPER", String.class));
        this.addFunction(new StaticTypedFunctionAdapter("LOWER", String.class));
        this.addFunction(new SqlServerExtractDateFunctionAdapter("SECOND"));
        this.addFunction(new SqlServerExtractDateFunctionAdapter("MINUTE"));
        this.addFunction(new SqlServerExtractDateFunctionAdapter("HOUR"));
        this.addFunction(new SqlServerExtractDateFunctionAdapter("DAY"));
        this.addFunction(new SqlServerExtractDateFunctionAdapter("MONTH"));
        this.addFunction(new SqlServerExtractDateFunctionAdapter("YEAR"));
        this.addFunction(new SqlServerDateAddFunctionAdapter());
        this.addFunction(new SqlServerDateDiffFunctionAdapter());
        this.addFunction(new CurrentDateFunctionAdapter());
        this.addFunction(new CurrentTimeFunctionAdapter());
        this.addFunction(new CurrentDateTimeFunctionAdapter());
        this.addFunction(new LocalTimeFunctionAdapter());
        I18nService i18n = ServiceRegistry.getRegistry().getService(I18nService.class);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        sdf.setTimeZone(i18n.getTimezone());
        try {
            this.dateMin = sdf.parse(DATE_MIN).getTime();
            this.dateMax = sdf.parse(DATE_MAX).getTime();
        }
        catch (ParseException e) {
            throw new UnsupportedDataTypeException(e);
        }
    }

    @Override
    public int getDefaultQueryTimeout() {
        return this.defaultQueryTimeout;
    }

    public void setDefaultQueryTimeout(int defaultQueryTimeout) {
        this.defaultQueryTimeout = defaultQueryTimeout;
    }

    @Override
    public int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    public void setDefaultFetchSize(int defaultFetchSize) {
        this.defaultFetchSize = defaultFetchSize;
    }

    @Override
    public int getMaxFetchSize() {
        return this.maxFetchSize;
    }

    public void setMaxFetchSize(int maxFetchSize) {
        this.maxFetchSize = maxFetchSize;
    }

    @Override
    public HintPlace getOptimizerHintPlace() {
        return HintPlace.AFTER_SELECT;
    }

    @Override
    public String[] getOptimizerHintBracket() {
        return optimizerHintBracket;
    }

    @Override
    public String getOptimizerHint() {
        return this.optimizerHint;
    }

    public void setOptimizerHint(String optimizerHint) {
        this.optimizerHint = optimizerHint;
    }

    public String getAddMonthsFunction() {
        return this.addMonthsFunction;
    }

    public void setAddMonthsFunction(String addMonthsFunction) {
        this.addMonthsFunction = addMonthsFunction;
    }

    public String getMonthsBetweenFunction() {
        return this.monthsBetweenFunction;
    }

    public void setMonthsBetweenFunction(String monthsBetweenFunction) {
        this.monthsBetweenFunction = monthsBetweenFunction;
    }

    public String getTimestampFunction() {
        return this.timestampFunction;
    }

    public void setTimestampFunction(String timestampFunction) {
        this.timestampFunction = timestampFunction;
    }

    public void setLockTimeout(int lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    public int getLockTimeout() {
        return this.lockTimeout;
    }

    private void checkDateRange(java.util.Date date) {
        long time;
        if (date != null && (this.dateMin > (time = date.getTime()) || this.dateMax < time)) {
            throw new UnsupportedDataTypeException("out of range Date:" + date);
        }
    }

    @Override
    public String toDateExpression(Date date) {
        this.checkDateRange(date);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
        return "CONVERT(DATE, '" + fmt.format(date) + "')";
    }

    @Override
    public String toTimeExpression(Time time) {
        this.checkDateRange(time);
        SimpleDateFormat fmt = new SimpleDateFormat("HH:mm:ss");
        return "CONVERT(DATETIME2, '1970-01-01 " + fmt.format(time) + "')";
    }

    @Override
    public String toTimeStampExpression(Timestamp date) {
        this.checkDateRange(date);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return "CONVERT(DATETIME2, '" + fmt.format(date) + "')";
    }

    @Override
    public String systimestamp() {
        return this.timestampFunction;
    }

    @Override
    public String[] castExp(int sqlType, Integer lengthOrPrecision, Integer scale) {
        switch (sqlType) {
            case 12: {
                if (lengthOrPrecision != null) {
                    return new String[]{"CAST(", " AS NVARCHAR(" + lengthOrPrecision + "))"};
                }
                return CAST_VARCHAR;
            }
            case -5: {
                return CAST_BIGINT;
            }
            case 3: {
                if (lengthOrPrecision == null) {
                    if (scale == null) {
                        return CAST_DECIMAL;
                    }
                    if (scale < 0) {
                        return new String[]{"ROUND(CAST(", " AS NUMERIC(38))," + scale + ")"};
                    }
                    return new String[]{"CAST(", " AS NUMERIC(38," + scale + "))"};
                }
                if (scale == null) {
                    return new String[]{"CAST(", " AS NUMERIC(" + lengthOrPrecision + ",0))"};
                }
                if (scale < 0) {
                    return new String[]{"ROUND(CAST(", " AS NUMERIC(" + lengthOrPrecision + -scale.intValue() + ",0))," + scale + ")"};
                }
                return new String[]{"CAST(", " AS NUMERIC(" + lengthOrPrecision + "," + scale + "))"};
            }
            case 91: {
                return CAST_DATE;
            }
            case 8: {
                return CAST_DOUBLE;
            }
            case 92: {
                return CAST_TIME;
            }
            case 93: {
                return CAST_TIMESTAMP;
            }
        }
        return null;
    }

    @Override
    public CharSequence cast(int fromSqlType, int toSqlType, CharSequence valExpr, Integer lengthOrPrecision, Integer scale) {
        if (toSqlType == 3 && scale != null && scale < 0) {
            CharSequence castString = super.cast(fromSqlType, toSqlType, valExpr, lengthOrPrecision, 0);
            return "ROUND(" + castString + "," + scale + ")";
        }
        return super.cast(fromSqlType, toSqlType, valExpr, lengthOrPrecision, scale);
    }

    @Override
    public MultiInsertContext createMultiInsertContext(Statement stmt) {
        return new SqlServerMultiInsertContext(stmt);
    }

    @Override
    public String getDataTypeOf(int sqlType, Integer lengthOrPrecision, Integer scale) {
        switch (sqlType) {
            case 12: {
                if (lengthOrPrecision == null) {
                    return "NVARCHAR(4000)";
                }
                return "NVARCHAR(" + lengthOrPrecision + ")";
            }
            case -5: {
                return "BIGINT";
            }
            case 3: {
                if (lengthOrPrecision == null) {
                    if (scale == null) {
                        return "NUMERIC(38)";
                    }
                    return "NUMERIC(38," + scale + ")";
                }
                if (scale == null) {
                    return "NUMERIC(" + lengthOrPrecision + ",0)";
                }
                return "NUMERIC(" + lengthOrPrecision + "," + scale + ")";
            }
            case 91: {
                return "DATE";
            }
            case 8: {
                return "FLOAT";
            }
            case 92: 
            case 93: {
                return "DATETIME2";
            }
        }
        return null;
    }

    @Override
    public String dual() {
        return "";
    }

    @Override
    public String rowLockExpression() {
        if (this.lockTimeout == 0) {
            return "WITH (UPDLOCK,NOWAIT)";
        }
        return "WITH (UPDLOCK)";
    }

    @Override
    public String toLimitSql(String selectSql, int limitCount, int offset, boolean asBind) {
        if (asBind) {
            StringBuilder sb = new StringBuilder();
            sb.append(selectSql);
            sb.append(" OFFSET ? ROWS FETCH FIRST ? ROWS ONLY");
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(selectSql);
        sb.append(" OFFSET ");
        sb.append(offset);
        sb.append(" ROWS FETCH FIRST ");
        sb.append(limitCount);
        sb.append(" ROWS ONLY");
        return sb.toString();
    }

    @Override
    public Object[] toLimitSqlBindValue(int limitCount, int offset) {
        return new Integer[]{offset, limitCount};
    }

    @Override
    public boolean isDuplicateValueException(SQLException e) {
        if (e.getErrorCode() == 2627) {
            return true;
        }
        return e instanceof BatchUpdateException;
    }

    @Override
    public boolean isDeadLock(SQLException e) {
        return e.getErrorCode() == 1205;
    }

    @Override
    public boolean isLockFailed(SQLException e) {
        return e.getErrorCode() == 1222;
    }

    @Override
    public boolean isCastFailed(SQLException e) {
        return e.getErrorCode() == 8114;
    }

    @Override
    public String addDate(String dateExpression, int day) {
        return "DATEADD(day," + day + "," + dateExpression + ")";
    }

    @Override
    public String checkStatusQuery() {
        return "SELECT 1";
    }

    @Override
    public String escape() {
        return "ESCAPE '\\'";
    }

    @Override
    public String tableAlias(String selectSql) {
        return selectSql;
    }

    @Override
    public boolean isSupportGroupingExtention(GroupBy.RollType rollType) {
        return true;
    }

    @Override
    public String rollUpStart(GroupBy.RollType rollType) {
        return "";
    }

    @Override
    public String rollUpEnd(GroupBy.RollType rollType) {
        switch (rollType) {
            case ROLLUP: {
                return " WITH ROLLUP ";
            }
            case CUBE: {
                return " WITH CUBE ";
            }
        }
        return " ";
    }

    @Override
    public String seqNextSelectSql(String sequenceName, int tenantId, String entityDefId) {
        return "SELECT NEXT VALUE FOR " + sequenceName;
    }

    @Override
    public String likePattern(String str) {
        return str;
    }

    @Override
    public String initBlob() {
        return "0x";
    }

    @Override
    public boolean isUseSubQueryForIndexJoin() {
        return this.isUseSubQueryForIndexJoin;
    }

    public void setUseSubQueryForIndexJoin(boolean isUseSubQueryForIndexJoin) {
        this.isUseSubQueryForIndexJoin = isUseSubQueryForIndexJoin;
    }

    @Override
    public void appendSortSpecExpression(StringBuilder sb, CharSequence sortValue, SortSpec.SortType sortType, SortSpec.NullOrderingSpec nullOrderingSpec) {
        if (nullOrderingSpec != null) {
            switch (nullOrderingSpec) {
                case FIRST: {
                    sb.append("CASE WHEN ");
                    sb.append(sortValue);
                    sb.append(" IS NULL THEN 0 ELSE 1 END ASC, ");
                    break;
                }
                case LAST: {
                    sb.append("CASE WHEN ");
                    sb.append(sortValue);
                    sb.append(" IS NULL THEN 0 ELSE 1 END DESC, ");
                    break;
                }
            }
        }
        sb.append(sortValue);
        if (sortType != null) {
            switch (sortType) {
                case ASC: {
                    sb.append(" ASC");
                    break;
                }
                case DESC: {
                    sb.append(" DESC");
                    break;
                }
            }
        }
    }

    @Override
    public String[] convertTZ(String to) {
        String[] ret = new String[]{"", ""};
        return ret;
    }

    @Override
    public boolean isEnableInPartitioning() {
        return false;
    }

    @Override
    public int getInPartitioningSize() {
        return -1;
    }

    @Override
    public String deleteTemporaryTable(String tableName) {
        String tempTableName = this.getTemplaryTablePrefix() + tableName;
        return "IF OBJECT_ID('tempdb.dbo." + tempTableName + "', 'U') IS NOT NULL DROP TABLE " + tempTableName;
    }

    @Override
    public boolean isSupportGlobalTemporaryTable() {
        return false;
    }

    @Override
    public String createLocalTemporaryTable(String tableName, String baseTableName, String[] baseColumnName) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        for (int i = 0; i < baseColumnName.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(baseColumnName[i]);
        }
        sb.append(" INTO ");
        sb.append(this.getTemplaryTablePrefix());
        sb.append(tableName);
        sb.append(" FROM ");
        sb.append(baseTableName);
        sb.append(" WHERE 1=2");
        return sb.toString();
    }

    @Override
    public String getTemplaryTablePrefix() {
        return "#";
    }

    @Override
    public boolean isSupportAutoClearTemporaryTableWhenCommit() {
        return false;
    }

    @Override
    public boolean isSupportGroupingExtentionWithOrderBy() {
        return true;
    }

    @Override
    public boolean isSupportGroupingExtention() {
        return true;
    }

    @Override
    public boolean isEnableBindHint() {
        return this.enableBindHint;
    }

    public void setEnableBindHint(boolean enableBindHint) {
        this.enableBindHint = enableBindHint;
    }

    @Override
    public boolean isAlwaysBind() {
        return this.alwaysBind;
    }

    public void setAlwaysBind(boolean alwaysBind) {
        this.alwaysBind = alwaysBind;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public int getThresholdCountOfUsePrepareStatement() {
        return this.thresholdCountOfUsePrepareStatement;
    }

    @Override
    public String aggregateFunctionName(Aggregate agg) {
        if (agg instanceof StdDevPop) {
            return "STDEVP";
        }
        if (agg instanceof StdDevSamp) {
            return "STDEV";
        }
        if (agg instanceof VarPop) {
            return "VARP";
        }
        if (agg instanceof VarSamp) {
            return "VAR";
        }
        return super.aggregateFunctionName(agg);
    }

    public void setThresholdCountOfUsePrepareStatement(int thresholdCountOfUsePrepareStatement) {
        this.thresholdCountOfUsePrepareStatement = thresholdCountOfUsePrepareStatement;
    }

    @Override
    public BulkInsertContext createBulkInsertContext() {
        return new PreparedBulkInsertContext();
    }

    @Override
    public BulkUpdateContext createBulkUpdateContext() {
        return new PreparedBulkUpdateContext();
    }

    @Override
    public BulkDeleteContext createBulkDeleteContext() {
        return new OrOperatorBulkDeleteContext();
    }

    @Override
    public MultiTableUpdateMethod getMultiTableUpdateMethod() {
        return MultiTableUpdateMethod.NO_SUPPORT;
    }

    @Override
    public ResultSet getTableNames(String tableNamePattern, Connection con) throws SQLException {
        DatabaseMetaData dbMeta = con.getMetaData();
        return dbMeta.getTables(null, dbMeta.getUserName().toUpperCase(), tableNamePattern, null);
    }

    @Override
    public boolean isSupportWindowFunction() {
        return true;
    }

    @Override
    public boolean isSupportOptimizerHint() {
        return false;
    }

    @Override
    public boolean isSupportTableHint() {
        return false;
    }

    @Override
    public String[] getTableHintBracket() {
        return null;
    }

    @Override
    public String createRowLockSql(String sql) {
        int idxWhere;
        StringBuilder lockSql = new StringBuilder();
        if (this.lockTimeout != 0) {
            lockSql.append("SET LOCK_TIMEOUT " + this.lockTimeout + " ");
        }
        if ((idxWhere = sql.toUpperCase().indexOf("WHERE")) > 0) {
            lockSql.append(sql.substring(0, idxWhere - 1) + " " + this.rowLockExpression() + " " + sql.substring(idxWhere, sql.length()));
        } else if (idxWhere < 0) {
            lockSql.append(sql + " " + this.rowLockExpression());
        } else {
            lockSql.append(this.rowLockExpression() + " " + sql);
        }
        return lockSql.toString();
    }

    @Override
    public boolean isSupportRowValueConstructor() {
        return false;
    }

    @Override
    public boolean isNeedFromClauseTableAliasUpdateStatement() {
        return true;
    }
}

