/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.runtime;

import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.impl.runtime.EntryPointBuilderImpl;
import org.iplass.mtp.impl.runtime.EntryPointImpl;
import org.iplass.mtp.runtime.AlreadyInitializedException;
import org.iplass.mtp.runtime.EntryPointBuilder;
import org.iplass.mtp.runtime.Runner;

public interface EntryPoint
extends AutoCloseable {
    public static EntryPoint getInstance() {
        EntryPoint i = EntryPointImpl.getInstance();
        if (i == null) {
            try {
                i = EntryPoint.init();
            }
            catch (AlreadyInitializedException e) {
                i = EntryPointImpl.getInstance();
            }
        }
        return i;
    }

    public static EntryPoint init() {
        return EntryPoint.builder().build();
    }

    public static EntryPointBuilder builder() {
        return new EntryPointBuilderImpl();
    }

    public static boolean isInited() {
        return EntryPointImpl.isInited();
    }

    public Runner runner();

    default public Runner withLang(String lang) {
        return this.runner().withLang(lang);
    }

    default public Runner withAuth(Credential credential) {
        return this.runner().withAuth(credential);
    }

    default public Runner withTenant(String tenantUrl) {
        return this.runner().withTenant(tenantUrl);
    }

    default public Runner withTenant(Integer tenantId) {
        return this.runner().withTenant(tenantId);
    }

    public void destroy();

    @Override
    default public void close() {
        this.destroy();
    }
}

