/*
 * Copyright (C) 2016 INFORMATION SERVICES INTERNATIONAL - DENTSU, LTD. All Rights Reserved.
 * 
 * Unless you have purchased a commercial license,
 * the following license terms apply:
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */
package org.iplass.mtp.impl.auth.authenticate;

import org.iplass.mtp.auth.login.Credential;

public class AutoLoginInstruction {
	
	public static AutoLoginInstruction THROUGH = new AutoLoginInstruction(Instruction.THROUGH, null);
	public static AutoLoginInstruction ERROR = new AutoLoginInstruction(Instruction.ERROR, null);
	public static AutoLoginInstruction LOGOUT = new AutoLoginInstruction(Instruction.LOGOUT, null);
	
	public enum Instruction {
		DO_AUTH,
		THROUGH,
		LOGOUT,
		ERROR
	}
	
	private final Instruction instruction;
	private final Credential credential;
	
	public AutoLoginInstruction(Credential credential) {
		this.instruction = Instruction.DO_AUTH;
		this.credential = credential;
	}
	
	public AutoLoginInstruction(Instruction instruction, Credential credential) {
		this.instruction = instruction;
		this.credential = credential;
	}

	public Instruction getInstruction() {
		return instruction;
	}

	public Credential getCredential() {
		return credential;
	}

}
