/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp;

import org.iplass.mtp.Manager;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.core.ManagerLocatorImpl;

public abstract class ManagerLocator {
    public static final String MANAGER_LOCATOR_SYSTEM_PROPERTY_NAME = "mtp.managerlocator";

    public static ManagerLocator getInstance() {
        return Holder.instance;
    }

    public static <M extends Manager> M manager(Class<M> type) {
        return ManagerLocator.getInstance().getManager(type);
    }

    public abstract <M extends Manager> M getManager(Class<M> var1);

    private static final class Holder {
        private static final ManagerLocator instance;

        private Holder() {
        }

        static {
            String managerLocatorName = System.getProperty(ManagerLocator.MANAGER_LOCATOR_SYSTEM_PROPERTY_NAME);
            if (managerLocatorName != null) {
                try {
                    instance = (ManagerLocator)Class.forName(managerLocatorName).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new SystemException(managerLocatorName + " can't instanceate.");
                }
            } else {
                instance = new ManagerLocatorImpl();
            }
        }
    }
}

