/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.command.async;

import java.util.ArrayList;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.async.ResultHandler;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.UpdateOption;

public class WriteToEntityHandler
implements ResultHandler {
    private static final long serialVersionUID = -3139078172022183983L;
    public static final String FAIL_STATUS = "FAIL";
    private String entityDefinitionName;
    private String propertyName;
    private String propertyNameForExceptionName;
    private String propertyNameForExceptionMessage;
    private String oid;
    private boolean exceptionIfNoEntity = false;

    public WriteToEntityHandler() {
    }

    public WriteToEntityHandler(String entityDefinitionName, String propertyName, String oid, boolean exceptionIfNoEntity) {
        this.entityDefinitionName = entityDefinitionName;
        this.propertyName = propertyName;
        this.oid = oid;
        this.exceptionIfNoEntity = exceptionIfNoEntity;
    }

    public WriteToEntityHandler(String entityDefinitionName, String propertyName, String propertyNameForExceptionName, String propertyNameForExceptionMessage, String oid, boolean exceptionIfNoEntity) {
        this.entityDefinitionName = entityDefinitionName;
        this.propertyName = propertyName;
        this.propertyNameForExceptionName = propertyNameForExceptionName;
        this.propertyNameForExceptionMessage = propertyNameForExceptionMessage;
        this.oid = oid;
        this.exceptionIfNoEntity = exceptionIfNoEntity;
    }

    public String getEntityDefinitionName() {
        return this.entityDefinitionName;
    }

    public void setEntityDefinitionName(String entityDefinitionName) {
        this.entityDefinitionName = entityDefinitionName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public String getPropertyNameForExceptionName() {
        return this.propertyNameForExceptionName;
    }

    public void setPropertyNameForExceptionName(String propertyNameForExceptionName) {
        this.propertyNameForExceptionName = propertyNameForExceptionName;
    }

    public String getPropertyNameForExceptionMessage() {
        return this.propertyNameForExceptionMessage;
    }

    public void setPropertyNameForExceptionMessage(String propertyNameForExceptionMessage) {
        this.propertyNameForExceptionMessage = propertyNameForExceptionMessage;
    }

    public boolean isExceptionIfNoEntity() {
        return this.exceptionIfNoEntity;
    }

    public void setExceptionIfNoEntity(boolean exceptionIfNoEntity) {
        this.exceptionIfNoEntity = exceptionIfNoEntity;
    }

    @Override
    public void handle(String commandResult) {
        EntityManager em = ManagerLocator.getInstance().getManager(EntityManager.class);
        Entity e = em.load(this.oid, this.entityDefinitionName, new LoadOption(false, false));
        if (e == null && this.exceptionIfNoEntity) {
            throw new EntityRuntimeException("entity[definitionName=" + this.entityDefinitionName + ", oid=" + this.oid + "] not found.");
        }
        e.setValue(this.propertyName, commandResult);
        UpdateOption opt = new UpdateOption(true);
        opt.setUpdateProperties(this.propertyName);
        em.update(e, opt);
    }

    @Override
    public void handle(Throwable exception) {
        EntityManager em = ManagerLocator.getInstance().getManager(EntityManager.class);
        Entity e = em.load(this.oid, this.entityDefinitionName, new LoadOption(false, false));
        if (e == null && this.exceptionIfNoEntity) {
            throw new EntityRuntimeException("entity[definitionName=" + this.entityDefinitionName + ", oid=" + this.oid + "] not found.");
        }
        ArrayList<String> updateProperties = new ArrayList<String>();
        e.setValue(this.propertyName, FAIL_STATUS);
        updateProperties.add(this.propertyName);
        if (this.propertyNameForExceptionName != null) {
            e.setValue(this.propertyNameForExceptionName, exception.getClass().getName());
            updateProperties.add(this.propertyNameForExceptionName);
        }
        if (this.propertyNameForExceptionMessage != null) {
            e.setValue(this.propertyNameForExceptionMessage, exception.getMessage());
            updateProperties.add(this.propertyNameForExceptionMessage);
        }
        UpdateOption opt = new UpdateOption(true);
        opt.setUpdateProperties(updateProperties);
        em.update(e, opt);
    }
}

